/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.common.PPLootTables;

public class ModCompat {
    public static void stopHoldingOffHandItem(Piglin piglin, boolean doBarter) {
        Entity interactor = ReputationHelper.getPreviousInteractor((Mob)piglin);
        boolean willDropLoot = ModCompat.willDropLootFor(piglin, interactor);
        ItemStack offHandItem = piglin.m_21120_(InteractionHand.OFF_HAND);
        piglin.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        if (piglin.m_34667_()) {
            boolean barterItem = PiglinTasksHelper.isBarterItem((ItemStack)offHandItem);
            if (doBarter && barterItem) {
                if (willDropLoot) {
                    PiglinTasksHelper.dropItemsAccountingForNearbyPlayer((AbstractPiglin)piglin, PiglinTasksHelper.isCheapBarterItem((ItemStack)offHandItem) ? ModCompat.getNuggetBarteringLoot((AbstractPiglin)piglin) : (PiglinTasksHelper.isExpensiveBarterItem((ItemStack)offHandItem) ? ModCompat.getBlockBarteringLoot((AbstractPiglin)piglin) : ModCompat.getBarterResponseItems((AbstractPiglin)piglin)));
                }
                ReputationHelper.updatePreviousInteractorReputation((Mob)piglin, (ReputationEventType)PiglinReputationType.BARTER);
                ModCompat.markAsBartered(offHandItem);
                ModCompat.putInInventory(piglin, offHandItem);
            } else if (!barterItem) {
                boolean equippedItem;
                if (PiglinTasksHelper.isPiglinLoved((ItemStack)offHandItem)) {
                    ReputationHelper.updatePreviousInteractorReputation((Mob)piglin, (ReputationEventType)PiglinReputationType.GOLD_GIFT);
                }
                if (!(equippedItem = piglin.m_21540_(offHandItem))) {
                    ModCompat.putInInventory(piglin, offHandItem);
                }
            }
        } else {
            boolean barterItem = piglin.m_21540_(offHandItem);
            if (!barterItem) {
                ItemStack mainHandItem = piglin.m_21205_();
                if (PiglinTasksHelper.isPiglinLoved((ItemStack)mainHandItem)) {
                    ModCompat.putInInventory(piglin, mainHandItem);
                } else {
                    PiglinTasksHelper.dropItemsAccountingForNearbyPlayer((AbstractPiglin)piglin, Collections.singletonList(mainHandItem));
                }
                piglin.m_8061_(EquipmentSlot.MAINHAND, offHandItem);
                piglin.m_21508_(EquipmentSlot.MAINHAND);
                piglin.m_21530_();
            }
        }
    }

    private static void markAsBartered(ItemStack offHandItem) {
        CompoundTag compoundNBT = offHandItem.m_41784_();
        compoundNBT.m_128379_("Bartered", true);
    }

    private static boolean willDropLootFor(Piglin piglinEntity, Entity interactorEntity) {
        LivingEntity living;
        return interactorEntity instanceof LivingEntity && ReputationHelper.isAllowedToBarter((Piglin)piglinEntity, (LivingEntity)(living = (LivingEntity)interactorEntity)) || interactorEntity == null && (Boolean)SapienceConfig.COMMON.REQUIRE_LIVING_FOR_BARTER.get() == false;
    }

    private static List<ItemStack> getNuggetBarteringLoot(AbstractPiglin piglinEntity) {
        if (piglinEntity.f_19853_.m_7654_() != null) {
            LootTable loottable = piglinEntity.f_19853_.m_7654_().m_129898_().m_79217_(PPLootTables.PIGLIN_BARTERING_CHEAP);
            return loottable.m_230922_(new LootContext.Builder((ServerLevel)piglinEntity.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)piglinEntity).m_230911_(piglinEntity.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getBlockBarteringLoot(AbstractPiglin piglinEntity) {
        if (piglinEntity.f_19853_.m_7654_() != null) {
            LootTable loottable = piglinEntity.f_19853_.m_7654_().m_129898_().m_79217_(PPLootTables.PIGLIN_BARTERING_EXPENSIVE);
            return loottable.m_230922_(new LootContext.Builder((ServerLevel)piglinEntity.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)piglinEntity).m_230911_(piglinEntity.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getBarterResponseItems(AbstractPiglin piglin) {
        LootTable loottable = piglin.f_19853_.m_7654_().m_129898_().m_79217_(PPLootTables.ALCHEMIST_BARTER);
        return loottable.m_230922_(new LootContext.Builder((ServerLevel)piglin.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)piglin).m_230911_(piglin.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
    }

    private static void putInInventory(Piglin piglin, ItemStack stack) {
        ItemStack remainder;
        if (PiglinTasksHelper.isBarterItem((ItemStack)stack)) {
            CompoundTag tag = stack.m_41784_();
            remainder = GreedHelper.addGreedItemToGreedInventory((Mob)piglin, (ItemStack)stack, (boolean)tag.m_128471_("Bartered"));
        } else {
            remainder = piglin.m_35311_().m_19173_(stack);
        }
        if (remainder.m_41619_() || !PiglinTasksHelper.isPiglinLoved((ItemStack)remainder) && !PiglinTasksHelper.isBarterItem((ItemStack)remainder)) {
            ModCompat.dropItemsNearSelf((AbstractPiglin)piglin, Collections.singletonList(remainder));
        }
    }

    private static void dropItems(AbstractPiglin piglinEntity, List<ItemStack> itemStacks, Vec3 vector3d) {
        if (!itemStacks.isEmpty()) {
            piglinEntity.m_6674_(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : itemStacks) {
                BehaviorUtils.m_22613_((LivingEntity)piglinEntity, (ItemStack)itemstack, (Vec3)vector3d.m_82520_(0.0, 1.0, 0.0));
            }
        }
    }

    private static void dropItemsNearSelf(AbstractPiglin piglinEntity, List<ItemStack> itemStacks) {
        ModCompat.dropItems(piglinEntity, itemStacks, ModCompat.getNearbyVectorOrPositionVector(piglinEntity));
    }

    private static Vec3 getNearbyVectorOrPositionVector(AbstractPiglin piglinEntity) {
        Vec3 vector3d = LandRandomPos.m_148488_((PathfinderMob)piglinEntity, (int)4, (int)2);
        return vector3d == null ? piglinEntity.m_20182_() : vector3d;
    }
}

