/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import tallestred.piglinproliferation.capablities.PPCapablities;
import tallestred.piglinproliferation.capablities.TransformationSourceListener;
import tallestred.piglinproliferation.capablities.TransformationSourceProvider;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.PPItems;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinCallForHelpGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinSwimInLavaGoal;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.PPNetworking;
import tallestred.piglinproliferation.networking.ZiglinCapablitySyncPacket;

@Mod.EventBusSubscriber(modid="piglinproliferation")
public class PPEvents {
    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        TransformationSourceProvider provider = new TransformationSourceProvider();
        if (event.getObject() instanceof ZombifiedPiglin) {
            event.addCapability(TransformationSourceProvider.IDENTIFIER, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ZombifiedPiglin) {
            TransformationSourceListener transformationSource;
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getEntity().f_19853_.f_46443_ && (transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin)) != null) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), transformationSource.getTransformationSource()));
            }
        }
        if ((entity = event.getEntity()) instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_6060_() && !piglin1.m_21023_(MobEffects.f_19607_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43610_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19605_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43589_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19601_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43581_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() / 2.0f && piglin1.m_5448_() != null && !piglin1.m_21023_(MobEffects.f_19600_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43592_));
            piglin.f_21345_.m_25352_(1, (Goal)new PiglinSwimInLavaGoal((Mob)piglin));
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ZombifiedPiglin) {
            TransformationSourceListener transformationSource;
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getTarget().f_19853_.f_46443_ && (transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin)) != null) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), transformationSource.getTransformationSource()));
            }
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, -1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            if (((Boolean)PPConfig.COMMON.healingArrowDamage.get()).booleanValue()) {
                for (MobEffectInstance mobeffectinstance : arrow.f_36855_.m_43488_()) {
                    if (mobeffectinstance.m_19544_() != MobEffects.f_19605_ && mobeffectinstance.m_19544_() != MobEffects.f_19601_) continue;
                    if (event.getEntity() instanceof Mob && event.getEntity().m_21222_()) {
                        return;
                    }
                    event.setAmount(0.0f);
                    arrow.f_19853_.m_5594_(null, arrow.m_20183_(), (SoundEvent)PPSounds.REGEN_HEALING_ARROW_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(-1.0, -1.0, -1.0));
                    event.getEntity().f_19802_ = 0;
                    event.getEntity().f_20916_ = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void attackEntity(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            for (Entity rider : mob.m_20197_()) {
                if (!mob.m_21222_() || !(event.getSource().m_7639_() instanceof AbstractPiglin) || !(rider instanceof AbstractPiglin)) continue;
                AbstractPiglin piglin = (AbstractPiglin)rider;
                if (!event.getSource().m_19387_()) continue;
                if (event.getEntity().f_19853_.f_46443_) {
                    return;
                }
                piglin.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void visionPercent(LivingEvent.LivingVisibilityEvent event) {
        if (event.getLookingEntity() != null) {
            ItemStack itemstack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
            EntityType entitytype = event.getLookingEntity().m_6095_();
            if (event.getLookingEntity() instanceof AbstractPiglin && (itemstack.m_150930_((Item)PPItems.PIGLIN_HEAD_ITEM.get()) || itemstack.m_150930_((Item)PPItems.PIGLIN_ALCHEMIST_HEAD_ITEM.get()) || itemstack.m_150930_((Item)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get())) || entitytype == EntityType.f_20531_ && itemstack.m_150930_((Item)PPItems.ZOMBIFIED_PIGLIN_HEAD_ITEM.get())) {
                event.modifyVisibility(0.5);
            }
        }
    }

    @SubscribeEvent
    public static void onConvert(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (event.getOutcome().m_6095_() == EntityType.f_20531_) {
                if (piglin.f_19853_.f_46443_) {
                    return;
                }
                ZombifiedPiglin ziglin = (ZombifiedPiglin)event.getOutcome();
                TransformationSourceListener transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin);
                String piglinName = ForgeRegistries.ENTITY_TYPES.getKey((Object)piglin.m_6095_()).m_135815_();
                transformationSource.setTransformationSource(piglinName);
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_19879_(), piglinName));
            }
        }
    }

    @SubscribeEvent
    public static void onLootDropEntity(LivingDropsEvent event) {
        Fireball fireBall;
        Creeper creeper;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            if (event.getEntity().m_6095_() == EntityType.f_20511_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_HEAD_ITEM.get());
            } else if (event.getEntity().m_6095_() == EntityType.f_20531_) {
                event.getEntity().m_19998_((ItemLike)PPItems.ZOMBIFIED_PIGLIN_HEAD_ITEM.get());
            } else if (event.getEntity().m_6095_() == EntityType.f_20512_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get());
            }
            creeper.m_32314_();
        }
        if ((entity = event.getSource().m_7640_()) instanceof Fireball && (fireBall = (Fireball)entity).m_37282_() instanceof Ghast) {
            if (event.getEntity().m_6095_() == EntityType.f_20511_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_HEAD_ITEM.get());
            } else if (event.getEntity().m_6095_() == EntityType.f_20512_) {
                event.getEntity().m_19998_((ItemLike)PPItems.PIGLIN_BRUTE_HEAD_ITEM.get());
            }
        }
    }

    public static TransformationSourceListener getTransformationSourceListener(LivingEntity entity) {
        LazyOptional listener = entity.getCapability(PPCapablities.TRANSFORMATION_SOURCE_TRACKER);
        if (listener.isPresent()) {
            return (TransformationSourceListener)listener.orElseThrow(() -> new IllegalStateException("Capability not found! Report this to the piglin proliferation github!"));
        }
        return null;
    }
}

