/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class BowAttack<E extends PiglinAlchemist, T extends LivingEntity>
extends Behavior<E> {
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private Path path;
    private int attackTime = -1;
    private int seeTime;
    private int avoidTime;

    public BowAttack(Map<MemoryModuleType<?>, MemoryStatus> map, double speedModifier, float attackRadius, int attackIntervalMin) {
        super(map, 12000);
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.attackIntervalMin = attackIntervalMin;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        return alchemist.m_21093_(is -> is.m_41720_() instanceof BowItem) && BehaviorUtils.m_22667_(alchemist, (LivingEntity)target);
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        return target != null && this.checkExtraStartConditions(level, alchemist);
    }

    protected void tick(ServerLevel level, E alchemist, long gameTime) {
        LivingEntity target = this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist));
        if (target != null) {
            double distanceSquared = alchemist.m_20280_((Entity)target);
            boolean canSee = alchemist.m_21574_().m_148306_((Entity)target);
            boolean seeTimeGreaterThanZero = this.seeTime > 0;
            alchemist.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
            alchemist.m_21563_().m_148051_((Entity)target);
            alchemist.m_21391_((Entity)target, 30.0f, 30.0f);
            if (alchemist.m_6117_()) {
                if (!canSee && this.seeTime < -60) {
                    alchemist.m_5810_();
                } else if (canSee) {
                    int timeToShoot;
                    int i = alchemist.m_21252_();
                    int n = timeToShoot = distanceSquared <= 40.0 ? Mth.m_14107_((double)Mth.m_14139_((double)(distanceSquared / (double)this.attackRadiusSqr), (double)5.0, (double)20.0)) : 20;
                    if (i >= timeToShoot) {
                        alchemist.m_5810_();
                        ((PiglinAlchemist)((Object)alchemist)).m_6504_(target, BowItem.m_40661_((int)i));
                        this.attackTime = this.attackIntervalMin;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                alchemist.m_6672_(ProjectileUtil.getWeaponHoldingHand(alchemist, item -> item instanceof BowItem));
            }
            if (distanceSquared > (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.path = alchemist.m_21573_().m_6570_((Entity)target, 0);
                alchemist.m_21573_().m_26536_(this.path, this.speedModifier);
            } else if (distanceSquared < (double)this.attackRadiusSqr && this.seeTime >= 20) {
                alchemist.m_21573_().m_26573_();
            }
            if (canSee != seeTimeGreaterThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceSquared <= 6.0 || ((PiglinAlchemist)((Object)alchemist)).getArrowsShot() >= 3) {
                if (this.getTargetToShootAt((PiglinAlchemist)((Object)alchemist)) instanceof AbstractPiglin) {
                    return;
                }
                this.avoidTime = this.avoidTime <= 0 ? 60 : (this.avoidTime -= 10);
                if (((PiglinAlchemist)((Object)alchemist)).getArrowsShot() >= 3) {
                    ((PiglinAlchemist)((Object)alchemist)).setArrowsShot(0);
                }
            }
            if (this.avoidTime == 0) {
                alchemist.m_21573_().m_26573_();
            }
            if (this.avoidTime < 0) {
                this.avoidTime = 0;
            }
            if (this.avoidTime > 60) {
                this.avoidTime = 60;
            }
            if (--this.avoidTime > 0) {
                Vec3 vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist));
                if (distanceSquared <= (double)this.attackRadiusSqr && vec3 != null && alchemist.m_21573_().m_26571_()) {
                    this.path = alchemist.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    alchemist.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(new BlockPos(vec3.f_82479_, alchemist.m_20188_(), vec3.f_82481_)));
                    if (this.path != null && this.path.m_77403_()) {
                        alchemist.m_21573_().m_26536_(this.path, this.speedModifier);
                        this.attackTime = -1;
                        alchemist.m_5810_();
                    }
                }
            }
        }
    }

    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        alchemist.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        alchemist.m_5810_();
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        if (this.getTargetToShootAt(alchemist) != null) {
            return LandRandomPos.m_148521_((PathfinderMob)alchemist, (int)5, (int)7, (Vec3)this.getTargetToShootAt(alchemist).m_20182_());
        }
        return LandRandomPos.m_148488_((PathfinderMob)alchemist, (int)5, (int)7);
    }

    protected LivingEntity getTargetToShootAt(PiglinAlchemist alchemist) {
        return alchemist.m_5448_();
    }
}

