/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BaseThrowPotion;

public class ThrowPotionAtSelfTask<E extends PiglinAlchemist>
extends BaseThrowPotion<E> {
    public ThrowPotionAtSelfTask(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector) {
        super(stack, pCanUseSelector);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)this.itemToUse)) {
            if (!super.checkExtraStartConditions(level, alchemist)) continue;
            List list = (List)alchemist.m_6274_().m_21952_(MemoryModuleType.f_26346_).orElse(ImmutableList.of());
            if (alchemist.m_21023_(mobeffectinstance.m_19544_())) continue;
            if (alchemist.m_5448_() != null) {
                return list.size() > 2;
            }
            return !list.stream().filter(abstractPiglin -> abstractPiglin instanceof PiglinAlchemist && ((PiglinAlchemist)((Object)abstractPiglin)).isGonnaThrowPotion()).findAny().isPresent();
        }
        return false;
    }

    protected void tick(ServerLevel level, E alchemist, long gameTIme) {
        Vec3 vec3;
        BlockPos lookPos = new BlockPos(alchemist.m_20182_().f_82479_, alchemist.m_20191_().f_82289_ - 0.5000001, alchemist.m_20182_().f_82481_);
        alchemist.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(lookPos));
        List list = ((PiglinAlchemist)((Object)alchemist)).f_19853_.m_45976_(LivingEntity.class, alchemist.m_20191_().m_82377_(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (entity == alchemist || (alchemist.m_5448_() == null || alchemist.m_5448_() != entity) && (!(entity instanceof Mob) || (((Mob)entity).m_5448_() == null || ((Mob)entity).m_5448_() != alchemist) && (entity.m_21214_() == null || !(entity.m_21214_() instanceof AbstractPiglin))) || !((double)entity.m_20270_(alchemist) <= 4.0) && !((double)alchemist.m_20270_((Entity)entity) <= 4.0)) continue;
                if (this.panicTicks <= 0) {
                    this.panicTicks = 20;
                }
                this.ticksUntilThrow += 5;
            }
        }
        if (this.ticksUntilThrow > 20) {
            this.ticksUntilThrow = 20;
        }
        if (this.panicTicks >= 15) {
            this.panicTicks = 15;
        }
        if (--this.panicTicks > 0 && (vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist))) != null && alchemist.m_21573_().m_26571_()) {
            alchemist.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.5);
        }
        alchemist.m_146922_(Mth.m_14094_((float)alchemist.m_146908_(), (float)((PiglinAlchemist)((Object)alchemist)).f_20885_, (float)0.0f));
        alchemist.m_146926_(Mth.m_14094_((float)alchemist.m_146909_(), (float)alchemist.m_8132_(), (float)0.0f));
        if (this.ticksUntilThrow == 5) {
            alchemist.m_5496_((SoundEvent)PPSounds.ALCHEMIST_ABOUT_TO_THROW_POTION.get(), 1.0f, 1.0f);
        }
        if (--this.ticksUntilThrow <= 0 && this.panicTicks <= 0) {
            alchemist.m_5616_(-200.0f);
            alchemist.m_146926_(90.0f);
            this.throwPotion(alchemist);
        }
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        List list = (List)alchemist.m_6274_().m_21952_(MemoryModuleType.f_26347_).orElse(ImmutableList.of());
        if (alchemist.m_5448_() != null) {
            return list.size() > 2;
        }
        Iterator iterator = PotionUtils.m_43547_((ItemStack)this.itemToUse).iterator();
        if (iterator.hasNext()) {
            MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
            return this.canUseSelector.test(alchemist) && !alchemist.m_21023_(mobeffectinstance.m_19544_()) && this.ticksUntilThrow > 0;
        }
        return !list.stream().filter(abstractPiglin -> abstractPiglin instanceof PiglinAlchemist && ((PiglinAlchemist)((Object)abstractPiglin)).isGonnaThrowPotion()).findAny().isPresent();
    }

    @Override
    protected void start(ServerLevel level, E alchemist, long gameTime) {
        super.start(level, alchemist, gameTime);
        alchemist.m_6274_().m_21879_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), alchemist);
        alchemist.m_6274_().m_21889_((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
        if (this.ticksUntilThrow <= 0) {
            this.ticksUntilThrow = 15;
        }
    }

    @Override
    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        this.ticksUntilThrow = 0;
        this.panicTicks = 0;
        alchemist.m_6274_().m_21936_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        return LandRandomPos.m_148488_((PathfinderMob)alchemist, (int)8, (int)7);
    }
}

