/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.client.gui.screen.inventory;

import com.cerbon.better_beacons.config.BBClientConfigs;
import com.cerbon.better_beacons.config.BBCommonConfigs;
import com.cerbon.better_beacons.menu.custom.NewBeaconMenu;
import com.cerbon.better_beacons.packet.BBPacketHandler;
import com.cerbon.better_beacons.packet.custom.BeaconC2SPacket;
import com.cerbon.better_beacons.util.BBConstants;
import com.cerbon.better_beacons.util.BBUtils;
import com.cerbon.better_beacons.util.NumberToRoman;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class NewBeaconScreen
extends AbstractContainerScreen<NewBeaconMenu> {
    private static final ResourceLocation BEACON_TEXTURE_LOCATION = new ResourceLocation(NewBeaconMenu.isTertiaryEffectsEnabled ? "textures/gui/container/beacon2.png" : "textures/gui/container/beacon1.png");
    public static final Component PRIMARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.primary");
    public static final Component SECONDARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.secondary");
    private final List<BeaconButton> beaconButtons = Lists.newArrayList();
    @Nullable
    MobEffect primary;
    @Nullable
    MobEffect secondary;
    @Nullable
    MobEffect tertiary;
    boolean isEffectsActive;
    String paymentItem;
    int primaryEffectAmplifier;

    public NewBeaconScreen(final NewBeaconMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = NewBeaconMenu.isTertiaryEffectsEnabled ? 256 : 230;
        this.f_97727_ = 219;
        menu.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu containerToSend, int dataSlotIndex, @NotNull ItemStack itemStack) {
            }

            public void m_142153_(@NotNull AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
                NewBeaconScreen.this.primary = menu.getPrimaryEffect();
                NewBeaconScreen.this.secondary = menu.getSecondaryEffect();
                NewBeaconScreen.this.tertiary = menu.getTertiaryEffect();
                NewBeaconScreen.this.isEffectsActive = menu.isEffectsActive();
                NewBeaconScreen.this.paymentItem = menu.getPaymentItem();
                NewBeaconScreen.this.primaryEffectAmplifier = menu.getPrimaryEffectAmplifier();
            }
        });
    }

    private <T extends AbstractWidget> void addBeaconButton(T beaconButton) {
        this.m_142416_((GuiEventListener)beaconButton);
        this.beaconButtons.add((BeaconButton)beaconButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.beaconButtons.clear();
        this.addBeaconButton(new BeaconConfirmButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 171 : this.f_97735_ + 172, this.f_97736_ + 106));
        this.addBeaconButton(new BeaconCancelButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 196 : this.f_97735_ + 197, this.f_97736_ + 106));
        for (int i = 0; i <= 2; ++i) {
            int j = BeaconBlockEntity.f_58646_[i].length;
            int k = j * 22 + (j - 1) * 2;
            for (int l = 0; l < j; ++l) {
                MobEffect mobeffect = BeaconBlockEntity.f_58646_[i][l];
                BeaconPowerButton beaconscreen$beaconpowerbutton = new BeaconPowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 74 + l * 24 - k / 2 : this.f_97735_ + 76 + l * 24 - k / 2, this.f_97736_ + 22 + i * 25, mobeffect, true, false, i);
                beaconscreen$beaconpowerbutton.f_93623_ = false;
                this.addBeaconButton(beaconscreen$beaconpowerbutton);
            }
        }
        int j1 = BeaconBlockEntity.f_58646_[3].length;
        int k1 = j1 * 22 + (j1 - 1) * 2;
        for (int l1 = 0; l1 < j1; ++l1) {
            MobEffect mobeffect1 = BeaconBlockEntity.f_58646_[3][l1];
            BeaconPowerButton beaconscreen$beaconpowerbutton2 = new BeaconPowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 164 + l1 * 24 - k1 / 2 : this.f_97735_ + 168 + l1 * 24 - k1 / 2, this.f_97736_ + 47, mobeffect1, false, true, 3);
            beaconscreen$beaconpowerbutton2.f_93623_ = false;
            this.addBeaconButton(beaconscreen$beaconpowerbutton2);
        }
        if (NewBeaconMenu.isTertiaryEffectsEnabled) {
            int j2 = BeaconBlockEntity.f_58646_[4].length;
            for (int i = 0; i < j2; ++i) {
                MobEffect mobEffect2 = BeaconBlockEntity.f_58646_[4][i];
                BeaconPowerButton beaconscreen$beaconpowerbutton3 = new BeaconPowerButton(this.f_97735_ + 222, this.f_97736_ + 47 + i * 25, mobEffect2, false, false, 4);
                beaconscreen$beaconpowerbutton3.f_93623_ = false;
                this.addBeaconButton(beaconscreen$beaconpowerbutton3);
            }
        }
        BeaconUpgradePowerButton beaconscreen$beaconpowerbutton1 = new BeaconUpgradePowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 153 : this.f_97735_ + 156, this.f_97736_ + 72, BeaconBlockEntity.f_58646_[0][0]);
        beaconscreen$beaconpowerbutton1.f_93624_ = false;
        this.addBeaconButton(beaconscreen$beaconpowerbutton1);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    void updateButtons() {
        int i = ((NewBeaconMenu)this.f_97732_).getLevels();
        this.beaconButtons.forEach(button -> button.updateStatus(i));
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)PRIMARY_EFFECT_LABEL, (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 60 : 63), (int)10, (int)0xE0E0E0);
        NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)SECONDARY_EFFECT_LABEL, (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 165 : 170), (int)10, (int)0xE0E0E0);
        if (((Boolean)BBCommonConfigs.ENABLE_PAYMENT_ITEM_RANGE.get()).booleanValue()) {
            NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)BBConstants.BEACON_RANGE_LABEL, (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 74 : 77), (int)105, (int)0xE0E0E0);
            NewBeaconScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"++", (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 20 : 23), (int)106, (int)0xE0E0E0);
            NewBeaconScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"--", (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 128 : 131), (int)106, (int)0xE0E0E0);
        } else {
            NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)BBConstants.PAYMENT_ITEM_LABEL, (int)(NewBeaconMenu.isTertiaryEffectsEnabled ? 74 : 77), (int)105, (int)0xE0E0E0);
        }
        if (NewBeaconMenu.isTertiaryEffectsEnabled) {
            NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)BBConstants.TERTIARY_POWER_LABEL, (int)233, (int)10, (int)0xE0E0E0);
            NewBeaconScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)BBConstants.CURRENT_PAYMENT_LABEL, (int)239, (int)106, (int)0xE0E0E0);
        }
        for (BeaconButton beaconscreen$beaconbutton : this.beaconButtons) {
            if (!beaconscreen$beaconbutton.isShowingTooltip()) continue;
            beaconscreen$beaconbutton.renderToolTip1(poseStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
            break;
        }
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BEACON_TEXTURE_LOCATION);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.f_96542_.f_115093_ = 100.0f;
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42418_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 12 : i + 14, j + 114);
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42415_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 33 : i + 35, j + 114);
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42616_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 31 + 22 : i + 33 + 22, j + 114);
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42417_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 31 + 44 : i + 33 + 44, j + 114);
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42416_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 31 + 66 : i + 34 + 66, j + 114);
        this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_151052_), NewBeaconMenu.isTertiaryEffectsEnabled ? i + 31 + 88 : i + 34 + 88, j + 114);
        this.f_96542_.f_115093_ = 0.0f;
        if (this.paymentItem != null && NewBeaconMenu.isTertiaryEffectsEnabled) {
            this.f_96542_.m_115203_(new ItemStack((ItemLike)BBUtils.getItemByKey(this.paymentItem)), i + 165 + 66, j + 114);
        }
        poseStack.m_85849_();
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface BeaconButton {
        public boolean isShowingTooltip();

        public void renderToolTip1(PoseStack var1, int var2, int var3);

        public void updateStatus(int var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BeaconConfirmButton
    extends BeaconSpriteScreenButton {
        protected BeaconConfirmButton(int x, int y) {
            super(x, y, 90, 220, CommonComponents.f_130655_);
        }

        @Override
        public void renderToolTip1(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
            if (((Boolean)BBClientConfigs.ENABLE_CONFIRM_BUTTON_TOOLTIP.get()).booleanValue()) {
                NewBeaconScreen.this.m_96602_(poseStack, BBConstants.CONFIRM_BUTTON_TOOLTIP, mouseX, mouseY);
            }
        }

        public void m_5691_() {
            BBPacketHandler.sendToServer(new BeaconC2SPacket(Optional.ofNullable(NewBeaconScreen.this.primary), Optional.ofNullable(NewBeaconScreen.this.secondary), Optional.ofNullable(NewBeaconScreen.this.tertiary)));
            ((NewBeaconScreen)NewBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = ((NewBeaconMenu)NewBeaconScreen.this.f_97732_).hasPayment() && NewBeaconScreen.this.primary != null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BeaconCancelButton
    extends BeaconSpriteScreenButton {
        public BeaconCancelButton(int x, int y) {
            super(x, y, 112, 220, CommonComponents.f_130656_);
        }

        @Override
        public void renderToolTip1(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
            if (((Boolean)BBClientConfigs.ENABLE_CANCEL_BUTTON_TOOLTIP.get()).booleanValue()) {
                if (((Boolean)BBClientConfigs.CANCEL_BUTTON_REMOVE_EFFECTS.get()).booleanValue()) {
                    NewBeaconScreen.this.m_96602_(poseStack, BBConstants.CANCEL_BUTTON_REMOVE_EFFECTS_TOOLTIP, mouseX, mouseY);
                } else {
                    NewBeaconScreen.this.m_96602_(poseStack, BBConstants.CANCEL_BUTTON_CLOSE_CONTAINER_TOOLTIP, mouseX, mouseY);
                }
            }
        }

        public void m_5691_() {
            if (((Boolean)BBClientConfigs.CANCEL_BUTTON_REMOVE_EFFECTS.get()).booleanValue()) {
                BBPacketHandler.sendToServer(new BeaconC2SPacket(Optional.empty(), Optional.empty(), Optional.empty()));
            }
            ((NewBeaconScreen)NewBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = NewBeaconScreen.this.isEffectsActive && NewBeaconScreen.this.primary != null || (Boolean)BBClientConfigs.CANCEL_BUTTON_REMOVE_EFFECTS.get() == false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BeaconPowerButton
    extends BeaconScreenButton {
        private final boolean isPrimary;
        private final boolean isSecondary;
        protected final int tier;
        private MobEffect effect;
        private TextureAtlasSprite sprite;
        private Component tooltip;

        public BeaconPowerButton(int x, int y, MobEffect effect, boolean isPrimary, boolean isSecondary, int tier) {
            super(x, y);
            this.isPrimary = isPrimary;
            this.isSecondary = isSecondary;
            this.tier = tier;
            this.setEffect(effect);
        }

        protected void setEffect(MobEffect effect) {
            this.effect = effect;
            this.sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect);
            this.tooltip = this.createEffectDescription(effect);
        }

        protected MutableComponent createEffectDescription(@NotNull MobEffect effect) {
            MutableComponent component = Component.m_237115_((String)effect.m_19481_());
            if (this.isPrimary && NewBeaconScreen.this.primaryEffectAmplifier > 0) {
                component.m_130946_(" " + NumberToRoman.convert(NewBeaconScreen.this.primaryEffectAmplifier + 1));
            }
            return component;
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                if (this.isPrimary) {
                    NewBeaconScreen.this.primary = this.effect;
                } else if (this.isSecondary) {
                    NewBeaconScreen.this.secondary = this.effect;
                } else {
                    NewBeaconScreen.this.tertiary = this.effect;
                }
                NewBeaconScreen.this.updateButtons();
            }
        }

        @Override
        public void renderToolTip1(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
            NewBeaconScreen.this.m_96602_(poseStack, this.tooltip, mouseX, mouseY);
        }

        @Override
        protected void renderIcon(@NotNull PoseStack poseStack) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.sprite.m_118414_().m_118330_());
            BeaconPowerButton.m_93200_((PoseStack)poseStack, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (int)this.m_93252_(), (int)18, (int)18, (TextureAtlasSprite)this.sprite);
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = this.tier < beaconTier;
            this.tooltip = this.createEffectDescription(this.effect);
            if (this.isPrimary) {
                this.setSelected(this.effect == NewBeaconScreen.this.primary);
            } else if (this.isSecondary) {
                this.setSelected(this.effect == NewBeaconScreen.this.secondary);
            } else {
                this.setSelected(this.effect == NewBeaconScreen.this.tertiary);
            }
        }

        @NotNull
        protected MutableComponent m_5646_() {
            return this.createEffectDescription(this.effect);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BeaconUpgradePowerButton
    extends BeaconPowerButton {
        public BeaconUpgradePowerButton(int x, int y, MobEffect effect) {
            super(x, y, effect, false, true, 3);
        }

        @Override
        protected MutableComponent createEffectDescription(@NotNull MobEffect effect) {
            return Component.m_237115_((String)effect.m_19481_()).m_130946_(" " + NumberToRoman.convert(NewBeaconScreen.this.primaryEffectAmplifier + 2));
        }

        @Override
        public void updateStatus(int beaconTier) {
            if (NewBeaconScreen.this.primary != null) {
                this.f_93624_ = true;
                this.setEffect(NewBeaconScreen.this.primary);
                super.updateStatus(beaconTier);
            } else {
                this.f_93624_ = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract class BeaconSpriteScreenButton
    extends BeaconScreenButton {
        private final int iconX;
        private final int iconY;

        protected BeaconSpriteScreenButton(int x, int y, int iconX, int iconY, Component component) {
            super(x, y, component);
            this.iconX = iconX;
            this.iconY = iconY;
        }

        @Override
        protected void renderIcon(@NotNull PoseStack poseStack) {
            this.m_93228_(poseStack, this.f_93620_ + 2, this.f_93621_ + 2, this.iconX, this.iconY, 18, 18);
        }

        @Override
        public void renderToolTip1(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
            NewBeaconScreen.this.m_96602_(poseStack, NewBeaconScreen.this.f_96539_, mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BeaconScreenButton
    extends AbstractButton
    implements BeaconButton {
        private boolean selected;

        protected BeaconScreenButton(int x, int y) {
            super(x, y, 22, 22, CommonComponents.f_237098_);
        }

        protected BeaconScreenButton(int x, int y, Component message) {
            super(x, y, 22, 22, message);
        }

        public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)BEACON_TEXTURE_LOCATION);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.selected) {
                j += this.f_93618_;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, j, 219, this.f_93618_, this.f_93619_);
            this.renderIcon(poseStack);
        }

        protected abstract void renderIcon(PoseStack var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public boolean isShowingTooltip() {
            return this.f_93622_;
        }

        public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

