/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.menu.custom;

import com.cerbon.better_beacons.config.BBCommonConfigs;
import com.cerbon.better_beacons.menu.BBMenuTypes;
import com.cerbon.better_beacons.util.BBUtils;
import com.cerbon.better_beacons.util.StringIntMapping;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class NewBeaconMenu
extends AbstractContainerMenu {
    private final Container beacon = new SimpleContainer(1){

        public boolean m_7013_(int index, ItemStack itemStack) {
            return itemStack.m_204117_(ItemTags.f_13164_);
        }

        public int m_6893_() {
            return 1;
        }
    };
    private final PaymentSlot paymentSlot;
    private final ContainerLevelAccess access;
    private final ContainerData beaconData;
    public static boolean isTertiaryEffectsEnabled = (Boolean)BBCommonConfigs.ENABLE_TERTIARY_EFFECTS.get();

    public NewBeaconMenu(int containerId, Container container, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, container, (ContainerData)new SimpleContainerData(6), ContainerLevelAccess.f_39287_);
    }

    public NewBeaconMenu(int containerId, Container container, ContainerData beaconData, ContainerLevelAccess access) {
        super((MenuType)BBMenuTypes.NEW_BEACON_MENU.get(), containerId);
        NewBeaconMenu.m_38886_((ContainerData)beaconData, (int)6);
        this.beaconData = beaconData;
        this.access = access;
        this.paymentSlot = new PaymentSlot(this.beacon, 0, isTertiaryEffectsEnabled ? 151 : 153, 109);
        this.m_38897_(this.paymentSlot);
        this.m_38884_(beaconData);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot(container, x + y * 9 + 9, isTertiaryEffectsEnabled ? 48 + 18 * x : 35 + x * 18, 137 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot(container, x, isTertiaryEffectsEnabled ? 48 + 18 * x : 35 + x * 18, 195));
        }
    }

    public void m_6877_(@NotNull Player player) {
        ItemStack itemstack;
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_ && !(itemstack = this.paymentSlot.m_6201_(this.paymentSlot.m_6641_())).m_41619_()) {
            player.m_36176_(itemstack, false);
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return NewBeaconMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)Blocks.f_50273_);
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
        this.m_38946_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else {
                if (this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= 1 && index < 28 && !this.m_38903_(itemstack1, 28, 37, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= 28 && index < 37 && !this.m_38903_(itemstack1, 1, 28, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 1, 37, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public int getLevels() {
        return this.beaconData.m_6413_(0);
    }

    @Nullable
    public MobEffect getPrimaryEffect() {
        return MobEffect.m_19453_((int)this.beaconData.m_6413_(1));
    }

    @Nullable
    public MobEffect getSecondaryEffect() {
        return MobEffect.m_19453_((int)this.beaconData.m_6413_(2));
    }

    @Nullable
    public MobEffect getTertiaryEffect() {
        return MobEffect.m_19453_((int)this.beaconData.m_6413_(3));
    }

    public String getPaymentItem() {
        return StringIntMapping.getString(this.beaconData.m_6413_(4));
    }

    public int getPrimaryEffectAmplifier() {
        return this.beaconData.m_6413_(5);
    }

    public boolean isEffectsActive() {
        return MobEffect.m_19453_((int)this.beaconData.m_6413_(1)) != null;
    }

    public void updateEffects(Optional<MobEffect> primaryEffect, Optional<MobEffect> secondaryEffect, Optional<MobEffect> tertiaryEffect) {
        if (this.paymentSlot.m_6657_()) {
            this.beaconData.m_8050_(1, primaryEffect.map(MobEffect::m_19459_).orElse(-1).intValue());
            this.beaconData.m_8050_(2, secondaryEffect.map(MobEffect::m_19459_).orElse(-1).intValue());
            this.beaconData.m_8050_(3, tertiaryEffect.map(MobEffect::m_19459_).orElse(-1).intValue());
            this.beaconData.m_8050_(4, StringIntMapping.addString(BBUtils.getItemKeyAsString(this.paymentSlot.m_7993_().m_41720_())));
            this.paymentSlot.m_6201_(1);
            this.access.m_39292_(Level::m_151543_);
        }
    }

    public void removeActiveEffects() {
        this.beaconData.m_8050_(1, -1);
        this.beaconData.m_8050_(2, -1);
        this.beaconData.m_8050_(3, -1);
        this.access.m_39292_(Level::m_151543_);
    }

    public boolean hasPayment() {
        return !this.beacon.m_8020_(0).m_41619_();
    }

    public static class PaymentSlot
    extends Slot {
        public PaymentSlot(Container container, int containerIndex, int xPos, int yPos) {
            super(container, containerIndex, xPos, yPos);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(ItemTags.f_13164_);
        }

        public int m_6641_() {
            return 1;
        }
    }
}

