/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.util;

import com.cerbon.better_beacons.config.BBCommonConfigs;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BBUtils {
    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean canUnlock(Player player, Component displayName) {
        if (((Boolean)BBCommonConfigs.LOCK_BEACON.get()).booleanValue() && !player.getPersistentData().m_128471_("BBUnlockedBeacon")) {
            List keys = (List)BBCommonConfigs.KEYS.get();
            String mainHandItemKey = BBUtils.getItemKeyAsString(player.m_21205_().m_41720_());
            if (!player.m_5833_() && !keys.contains(mainHandItemKey)) {
                player.m_5661_((Component)Component.m_237110_((String)"beacon.isLocked", (Object[])new Object[]{displayName, BBCommonConfigs.KEYS.get()}).m_130940_(ChatFormatting.RED), true);
                player.m_6330_(SoundEvents.f_12107_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return false;
            }
            player.getPersistentData().m_128379_("BBUnlockedBeacon", true);
            player.m_5661_((Component)Component.m_237110_((String)"beacon.unlocked", (Object[])new Object[]{displayName}).m_130940_(ChatFormatting.GREEN), true);
            player.m_6330_(SoundEvents.f_144243_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return true;
    }

    public static String getItemKeyAsString(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString();
    }

    public static MobEffect[][] getBeaconEffectsFromConfigFile() {
        MobEffect[] level1Effects = (MobEffect[])((List)BBCommonConfigs.LEVEL1_EFFECTS.get()).stream().map(BBUtils::getMobEffectByKey).filter(Objects::nonNull).toArray(MobEffect[]::new);
        MobEffect[] level2Effects = (MobEffect[])((List)BBCommonConfigs.LEVEL2_EFFECTS.get()).stream().map(BBUtils::getMobEffectByKey).filter(Objects::nonNull).toArray(MobEffect[]::new);
        MobEffect[] level3Effects = (MobEffect[])((List)BBCommonConfigs.LEVEL3_EFFECTS.get()).stream().map(BBUtils::getMobEffectByKey).filter(Objects::nonNull).toArray(MobEffect[]::new);
        MobEffect[] secondaryEffects = (MobEffect[])((List)BBCommonConfigs.SECONDARY_EFFECTS.get()).stream().map(BBUtils::getMobEffectByKey).filter(Objects::nonNull).toArray(MobEffect[]::new);
        MobEffect[] tertiaryEffects = (MobEffect[])((List)BBCommonConfigs.TERTIARY_EFFECTS.get()).stream().map(BBUtils::getMobEffectByKey).filter(Objects::nonNull).toArray(MobEffect[]::new);
        return new MobEffect[][]{level1Effects, level2Effects, level3Effects, secondaryEffects, tertiaryEffects};
    }

    public static MobEffect getMobEffectByKey(String key) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(key));
    }

    public static Item getItemByKey(String key) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key));
    }
}

