/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.util.json;

import com.cerbon.better_beacons.BetterBeacons;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BeaconBaseBlocksAmplifierManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final BeaconBaseBlocksAmplifierManager INSTANCE = new BeaconBaseBlocksAmplifierManager();
    private static final String DIRECTORY = "base_blocks_amplifier";
    private static final HashMap<Block, Integer> blockAmplifierMap = new HashMap();

    public BeaconBaseBlocksAmplifierManager() {
        super(GSON, DIRECTORY);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resources, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        blockAmplifierMap.clear();
        resources.forEach((resourceLocation, jsonElement) -> {
            try {
                DataResult dataResult = ValuesListCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                dataResult.resultOrPartial(result -> {}).ifPresent(this::addToBlockAmplifierMap);
            }
            catch (Exception e) {
                BetterBeacons.LOGGER.error("Better Beacons Error: Couldn't parse beacon base block amplifier file {}", resourceLocation, (Object)e);
            }
        });
    }

    private void addToBlockAmplifierMap(ValuesListCodec valuesList) {
        valuesList.values().forEach(entry -> blockAmplifierMap.put(entry.block(), Math.max(Math.min(entry.amplifier(), 254), 0)));
    }

    public static BeaconBaseBlocksAmplifierManager getInstance() {
        return INSTANCE;
    }

    public static HashMap<Block, Integer> getBlockAmplifierMap() {
        return blockAmplifierMap;
    }

    public static int getHighestAmplifier() {
        return Collections.max(blockAmplifierMap.values());
    }

    public static int getLowestAmplifier() {
        return Collections.min(blockAmplifierMap.values());
    }

    public record ValuesListCodec(List<BlockAmplifierCodec> values) {
        public static final Codec<ValuesListCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockAmplifierCodec.CODEC.listOf().fieldOf("values").forGetter(ValuesListCodec::values)).apply((Applicative)instance, instance.stable(ValuesListCodec::new)));
    }

    public record BlockAmplifierCodec(Block block, int amplifier) {
        public static final Codec<BlockAmplifierCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.BLOCKS.getCodec().fieldOf("block").forGetter(BlockAmplifierCodec::block), (App)Codec.INT.fieldOf("amplifier").forGetter(BlockAmplifierCodec::amplifier)).apply((Applicative)instance, instance.stable(BlockAmplifierCodec::new)));
    }
}

