/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.util.mixin;

import com.cerbon.better_beacons.advancement.BBCriteriaTriggers;
import com.cerbon.better_beacons.config.BBCommonConfigs;
import com.cerbon.better_beacons.util.BBConstants;
import com.cerbon.better_beacons.util.BBUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import vazkii.quark.content.world.block.CorundumClusterBlock;
import vazkii.quark.content.world.module.CorundumModule;

public class BeaconRedirectionAndTransparency {
    public static int horizontalMoveLimit = (Integer)BBCommonConfigs.HORIZONTAL_MOVE_LIMIT.get();
    public static boolean allowRedirecting = (Boolean)BBCommonConfigs.ENABLE_BEACON_BEAM_REDIRECTION.get();
    public static boolean allowTintedGlassTransparency = (Boolean)BBCommonConfigs.ENABLE_BEACON_BEAM_TRANSPARENCY.get();

    public static int tickBeacon(BeaconBlockEntity beacon) {
        BlockPos beaconPos;
        Level level = beacon.m_58904_();
        BlockPos currPos = beaconPos = beacon.m_58899_();
        int i = beaconPos.m_123341_();
        int j = beaconPos.m_123342_();
        int k = beaconPos.m_123343_();
        int horizontalMoves = horizontalMoveLimit;
        int targetHeight = Objects.requireNonNull(level).m_6924_(Heightmap.Types.WORLD_SURFACE, beaconPos.m_123341_(), beaconPos.m_123343_());
        boolean broke = false;
        boolean didRedirection = false;
        beacon.f_58649_.clear();
        float[] currColor = new float[]{1.0f, 1.0f, 1.0f};
        float alpha = 1.0f;
        Direction lastDir = null;
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vec3i.f_123288_, currColor, alpha);
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        boolean hardColorSet = false;
        while (level.m_46739_(currPos) && horizontalMoves > 0) {
            boolean added;
            if (currSegment.dir == Direction.UP && currSegment.dir != lastDir) {
                int heightmapVal = level.m_6924_(Heightmap.Types.WORLD_SURFACE, currPos.m_123341_(), currPos.m_123343_());
                if (heightmapVal == currPos.m_123342_() + 1) {
                    currSegment.setHeight(heightmapVal + 1000);
                    break;
                }
                lastDir = currSegment.dir;
            }
            currPos = currPos.m_121945_(currSegment.dir);
            horizontalMoves = currSegment.dir.m_122434_().m_122479_() ? --horizontalMoves : horizontalMoveLimit;
            BlockState blockstate = level.m_8055_(currPos);
            Block block = blockstate.m_60734_();
            float[] targetColor = blockstate.getBeaconColorMultiplier((LevelReader)level, currPos, beaconPos);
            float targetAlpha = -1.0f;
            if (allowTintedGlassTransparency && block.m_49966_().m_204336_(BBConstants.BEACON_TRANSPARENCY)) {
                float f = targetAlpha = alpha < 0.3f ? 0.0f : alpha / 2.0f;
                if (targetAlpha <= 0.0f) {
                    for (ServerPlayer serverplayer : Objects.requireNonNull(beacon.m_58904_()).m_45976_(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82377_(10.0, 5.0, 10.0))) {
                        BBCriteriaTriggers.INVISIBLE_BEAM.trigger(serverplayer);
                    }
                }
            }
            if (BeaconRedirectionAndTransparency.isRedirectingBlock(block) && allowRedirecting) {
                Direction dir = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61372_);
                if (dir == currSegment.dir) {
                    currSegment.m_58719_();
                } else {
                    beacon.f_58649_.add(currSegment);
                    targetColor = BeaconRedirectionAndTransparency.getTargetColor(block);
                    if (targetColor[0] == 1.0f && targetColor[1] == 1.0f && targetColor[2] == 1.0f) {
                        targetColor = currColor;
                    }
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0] * 3.0f) / 4.0f, (currColor[1] + targetColor[1] * 3.0f) / 4.0f, (currColor[2] + targetColor[2] * 3.0f) / 4.0f};
                    currColor = mixedColor;
                    alpha = 1.0f;
                    didRedirection = true;
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), currColor, alpha);
                }
            } else if (targetColor != null || targetAlpha != -1.0f) {
                if (Arrays.equals(targetColor, currColor) && targetAlpha == alpha) {
                    currSegment.m_58719_();
                } else {
                    beacon.f_58649_.add(currSegment);
                    float[] mixedColor = currColor;
                    if (targetColor != null) {
                        mixedColor = new float[]{(currColor[0] + targetColor[0]) / 2.0f, (currColor[1] + targetColor[1]) / 2.0f, (currColor[2] + targetColor[2]) / 2.0f};
                        if (!hardColorSet) {
                            mixedColor = targetColor;
                            hardColorSet = true;
                        }
                        currColor = mixedColor;
                    }
                    if (targetAlpha != -1.0f) {
                        alpha = targetAlpha;
                    }
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), mixedColor, alpha);
                }
            } else {
                boolean bedrock = blockstate.m_204336_(BBConstants.BEACON_TRANSPARENT);
                if (!bedrock && blockstate.m_60739_((BlockGetter)level, currPos) >= 15) {
                    broke = true;
                    break;
                }
                currSegment.m_58719_();
                if (bedrock) continue;
            }
            if (added = seenPositions.add(currPos)) continue;
            broke = true;
            break;
        }
        if (horizontalMoves == 0 || currPos.m_123342_() <= level.m_141937_()) {
            broke = true;
        }
        String tag = "better_beacons:redirected";
        if (!broke) {
            beacon.f_58649_.add(currSegment);
            beacon.f_58651_ = targetHeight + 1;
        } else {
            beacon.getPersistentData().m_128379_("better_beacons:redirected", false);
            beacon.f_58649_.clear();
            beacon.f_58651_ = targetHeight;
        }
        if (!beacon.getPersistentData().m_128471_("better_beacons:redirected") && didRedirection && !beacon.f_58649_.isEmpty()) {
            beacon.getPersistentData().m_128379_("better_beacons:redirected", true);
            for (ServerPlayer serverplayer : Objects.requireNonNull(beacon.m_58904_()).m_45976_(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82377_(10.0, 5.0, 10.0))) {
                BBCriteriaTriggers.REDIRECT_BEACON.trigger(serverplayer);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isRedirectingBlock(Block block) {
        if (BBUtils.isModLoaded("quark") && CorundumModule.staticEnabled) {
            return block instanceof CorundumClusterBlock || block.m_49966_().m_204336_(BBConstants.BEACON_REDIRECT);
        }
        return block.m_49966_().m_204336_(BBConstants.BEACON_REDIRECT);
    }

    private static float[] getTargetColor(Block block) {
        if (BBUtils.isModLoaded("quark")) {
            float[] fArray;
            if (block instanceof CorundumClusterBlock) {
                CorundumClusterBlock cc = (CorundumClusterBlock)block;
                fArray = cc.base.colorComponents;
            } else {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            }
            return fArray;
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static class ExtendedBeamSegment
    extends BeaconBlockEntity.BeaconBeamSection {
        public final Direction dir;
        public final Vec3i offset;
        public final float alpha;

        public ExtendedBeamSegment(Direction dir, Vec3i offset, float[] colorsIn, float alpha) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
            this.alpha = alpha;
        }

        public void m_58719_() {
            super.m_58719_();
        }

        public void setHeight(int target) {
            this.f_58716_ = target;
        }
    }
}

