/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.crafting.v1;

import com.google.gson.JsonObject;
import dev.architectury.registry.registries.DeferredRegister;
import gg.moonflower.pollen.api.crafting.v1.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenGrindstoneRecipe;
import gg.moonflower.pollen.core.crafting.PollenBrewingRecipeImpl;
import gg.moonflower.pollen.core.crafting.PollenShapelessGrindstoneRecipeImpl;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.ApiStatus;

public final class PollenRecipeTypes {
    @ApiStatus.Internal
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"pollen", (ResourceKey)Registry.f_122915_);
    @ApiStatus.Internal
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((String)"pollen", (ResourceKey)Registry.f_122914_);
    public static final Supplier<RecipeType<PollenBrewingRecipe>> BREWING_TYPE = PollenRecipeTypes.register("brewing");
    public static final Supplier<RecipeSerializer<PollenBrewingRecipe>> BREWING = RECIPE_SERIALIZERS.register("brewing", () -> PollenRecipeTypes.createSerializer(PollenBrewingRecipeImpl::fromJson, PollenBrewingRecipeImpl::fromNetwork, PollenBrewingRecipeImpl::toNetwork));
    public static final Supplier<RecipeType<PollenGrindstoneRecipe>> GRINDSTONE_TYPE = PollenRecipeTypes.register("grindstone");
    public static final Supplier<RecipeSerializer<PollenShapelessGrindstoneRecipeImpl>> GRINDSTONE = RECIPE_SERIALIZERS.register("grindstone", () -> PollenRecipeTypes.createSerializer(PollenShapelessGrindstoneRecipeImpl::fromJson, PollenShapelessGrindstoneRecipeImpl::fromNetwork, PollenShapelessGrindstoneRecipeImpl::toNetwork));

    private PollenRecipeTypes() {
    }

    public static <T extends Recipe<?>> RecipeSerializer<T> createSerializer(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, FriendlyByteBuf, T> fromNetwork, BiConsumer<FriendlyByteBuf, T> toNetwork) {
        return new PollenRecipeSerializer<T>(fromJson, fromNetwork, toNetwork);
    }

    private static <T extends Recipe<?>> Supplier<RecipeType<T>> register(final String name) {
        return RECIPES.register(name, () -> new RecipeType<T>(){

            public String toString() {
                return "pollen:" + name;
            }
        });
    }

    private record PollenRecipeSerializer<T extends Recipe<?>>(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, FriendlyByteBuf, T> fromNetwork, BiConsumer<FriendlyByteBuf, T> toNetwork) implements RecipeSerializer<T>
    {
        public T m_6729_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return (T)((Recipe)this.fromJson.apply(resourceLocation, jsonObject));
        }

        public T m_8005_(ResourceLocation id, FriendlyByteBuf buf) {
            return (T)((Recipe)this.fromNetwork.apply(id, buf));
        }

        public void m_6178_(FriendlyByteBuf buf, T recipe) {
            this.toNetwork.accept(buf, (FriendlyByteBuf)recipe);
        }
    }
}

