/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gg.moonflower.pollen.api.crafting.v1.PollenGrindstoneRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenShapelessGrindstoneRecipeImpl
implements PollenGrindstoneRecipe {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final int experience;

    public PollenShapelessGrindstoneRecipeImpl(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, int experience) {
        this.id = id;
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.experience = experience;
    }

    public static NonNullList<Ingredient> itemsFromJson(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    @ApiStatus.Internal
    public static PollenShapelessGrindstoneRecipeImpl fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = PollenShapelessGrindstoneRecipeImpl.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for grindstone recipe");
        }
        if (ingredients.size() > 2) {
            throw new JsonParseException("Too many ingredients for grindstone recipe");
        }
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        int experience = GsonHelper.m_13824_((JsonObject)json, (String)"experience", (int)0);
        return new PollenShapelessGrindstoneRecipeImpl(recipeId, group, result, ingredients, experience);
    }

    @ApiStatus.Internal
    public static PollenShapelessGrindstoneRecipeImpl fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String group = buf.m_130277_();
        ItemStack result = buf.m_130267_();
        int experience = buf.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
        ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
        return new PollenShapelessGrindstoneRecipeImpl(id, group, result, (NonNullList<Ingredient>)ingredients, experience);
    }

    @ApiStatus.Internal
    public static void toNetwork(FriendlyByteBuf buf, PollenShapelessGrindstoneRecipeImpl recipe) {
        buf.m_130070_(recipe.group);
        buf.m_130055_(recipe.result);
        buf.m_130130_(recipe.experience);
        buf.m_130130_(recipe.ingredients.size());
        for (Ingredient ingredient : recipe.ingredients) {
            ingredient.m_43923_(buf);
        }
    }

    public boolean m_5818_(Container container, Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            ItemStack itemStack = container.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public ItemStack m_5874_(Container container) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= this.ingredients.size();
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public RecipeSerializer<?> m_7707_() {
        return PollenRecipeTypes.GRINDSTONE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public int getResultExperience() {
        return this.experience;
    }
}

