/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.animation;

import gg.moonflower.pinwheel.api.animation.AnimationData;
import gg.moonflower.pinwheel.api.animation.PlayingAnimation;
import gg.moonflower.pinwheel.impl.animation.PlayingAnimationImpl;
import gg.moonflower.pollen.api.animation.v1.RenderAnimationTimer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollenPlayingAnimationImpl
extends PlayingAnimationImpl {
    private RenderAnimationTimer timer = RenderAnimationTimer.LINEAR;
    private float lastTime;
    private float renderTime;

    public PollenPlayingAnimationImpl(AnimationData animation) {
        super(animation);
    }

    public void tick() {
        float time = this.getAnimationTime();
        this.setAnimationTime(time + 0.05f);
        this.lastTime = time;
    }

    public void setRenderTime(float partialTicks) {
        this.renderTime = this.timer.getRenderAnimationTime((PlayingAnimation)this, this.lastTime, partialTicks);
    }

    public float getRenderAnimationTime() {
        return switch (this.getAnimation().loop()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationData.Loop.NONE -> this.renderTime;
            case AnimationData.Loop.LOOP -> this.renderTime % this.getLength();
            case AnimationData.Loop.HOLD_ON_LAST_FRAME -> Math.min(this.renderTime, this.getLength());
        };
    }

    public void setAnimationTime(float time) {
        super.setAnimationTime(time);
        this.lastTime = time;
    }

    public void setTimer(@Nullable RenderAnimationTimer timer) {
        this.timer = timer != null ? timer : RenderAnimationTimer.LINEAR;
    }
}

