/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.platform;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.impl.platform.InvalidSidedPlatformImpl;
import gg.moonflower.pollen.impl.platform.SidedPlatformImpl;
import gg.moonflower.pollen.impl.platform.forge.PlatformImplImpl;
import java.util.Optional;
import java.util.ServiceLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PlatformImpl {
    private static final SidedPlatformImpl CLIENT_PLATFORM = ServiceLoader.load(SidedPlatformImpl.class).findFirst().orElseGet(InvalidSidedPlatformImpl::new);
    private static MinecraftServer runningServer;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isProduction() {
        return PlatformImplImpl.isProduction();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return PlatformImplImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isOptifineLoaded() {
        return PlatformImplImpl.isOptifineLoaded();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockableEventLoop<?> getGameExecutor() {
        return PlatformImplImpl.getGameExecutor();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatformImplImpl.isModLoaded(modId);
    }

    public static Optional<MinecraftServer> getRunningServer() {
        return Optional.ofNullable(runningServer);
    }

    public static Optional<RecipeManager> getRecipeManager() {
        if (runningServer != null) {
            return Optional.of(runningServer.m_129894_());
        }
        return PlatformImpl.isClient() ? CLIENT_PLATFORM.getRecipeManager() : Optional.empty();
    }

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(server -> {
            runningServer = server;
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            runningServer = null;
        });
    }
}

