/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.registry.wrapper;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import gg.moonflower.pollen.api.registry.wrapper.v1.PollinatedEntityRegistry;
import gg.moonflower.pollen.impl.registry.wrapper.PollinatedRegistryImpl;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollinatedEntityRegistryImpl
extends PollinatedRegistryImpl<EntityType<?>>
implements PollinatedEntityRegistry {
    private final DeferredRegister<MemoryModuleType<?>> memoryModuleTypeRegistry = DeferredRegister.create((String)this.getModId(), (ResourceKey)Registry.f_122811_);
    private final DeferredRegister<SensorType<?>> sensorTypeRegistry = DeferredRegister.create((String)this.getModId(), (ResourceKey)Registry.f_122812_);
    private final DeferredRegister<Schedule> scheduleRegistry = DeferredRegister.create((String)this.getModId(), (ResourceKey)Registry.f_122813_);
    private final DeferredRegister<Activity> activityRegistry = DeferredRegister.create((String)this.getModId(), (ResourceKey)Registry.f_122814_);

    public PollinatedEntityRegistryImpl(DeferredRegister<EntityType<?>> entityRegistry) {
        super(entityRegistry);
    }

    @Override
    public void register() {
        super.register();
        this.memoryModuleTypeRegistry.register();
        this.sensorTypeRegistry.register();
        this.scheduleRegistry.register();
        this.activityRegistry.register();
    }

    @Override
    public <R> RegistrySupplier<MemoryModuleType<R>> registerMemoryModuleType(String id) {
        return this.registerMemoryModuleType(id, null);
    }

    @Override
    public <R> RegistrySupplier<MemoryModuleType<R>> registerMemoryModuleType(String id, @Nullable Codec<R> codec) {
        return this.memoryModuleTypeRegistry.register(id, () -> new MemoryModuleType(Optional.ofNullable(codec)));
    }

    @Override
    public <R extends Sensor<?>> RegistrySupplier<SensorType<R>> registerSensorType(String id, Supplier<R> supplier) {
        return this.sensorTypeRegistry.register(id, () -> new SensorType(supplier));
    }

    @Override
    public RegistrySupplier<Schedule> registerSchedule(String id, Consumer<ScheduleBuilder> builder) {
        return this.scheduleRegistry.register(id, () -> {
            Schedule schedule = new Schedule();
            builder.accept(new ScheduleBuilder(schedule));
            return schedule;
        });
    }

    @Override
    public RegistrySupplier<Activity> registerActivity(String id) {
        return this.activityRegistry.register(id, () -> new Activity(this.getModId() + ":" + id));
    }

    @Override
    public DeferredRegister<MemoryModuleType<?>> getMemoryModuleTypeRegistry() {
        return this.memoryModuleTypeRegistry;
    }

    @Override
    public DeferredRegister<SensorType<?>> getSensorTypeRegistry() {
        return this.sensorTypeRegistry;
    }

    @Override
    public DeferredRegister<Schedule> getScheduleRegistry() {
        return this.scheduleRegistry;
    }

    @Override
    public DeferredRegister<Activity> getActivityRegistry() {
        return this.activityRegistry;
    }
}

