/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.animation;

import gg.moonflower.pinwheel.api.animation.AnimationData;
import gg.moonflower.pinwheel.api.animation.AnimationParser;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalAnimationLoader
implements BackgroundLoader<Map<ResourceLocation, AnimationData>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FOLDER = "pinwheel/animations";

    @Override
    public CompletableFuture<Map<ResourceLocation, AnimationData>> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, AnimationData> animationData = new HashMap<ResourceLocation, AnimationData>();
            for (Map.Entry entry : resourceManager.m_214159_(FOLDER, resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).entrySet()) {
                ResourceLocation animationLocation = (ResourceLocation)entry.getKey();
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        AnimationData[] animations;
                        for (AnimationData animation : animations = AnimationParser.parse((Reader)reader)) {
                            ResourceLocation id = new ResourceLocation(animationLocation.m_135827_(), animation.name());
                            if (animationData.put(id, animation) == null) continue;
                            LOGGER.warn("Duplicate animation: " + id);
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load animation file '" + animationLocation.m_135827_() + ":" + animationLocation.m_135815_().substring(FOLDER.length() + 1, animationLocation.m_135815_().length() - 5) + "'", (Throwable)e);
                }
            }
            return animationData;
        }, backgroundExecutor);
    }
}

