/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import dev.architectury.registry.ReloadListenerRegistry;
import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryModelManager;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import gg.moonflower.pollen.impl.render.geometry.LocalGeometryModelLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class GeometryModelManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger(GeometryModelManager.class);
    private static final Reloader RELOADER = new Reloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, GeometryModel>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, GeometryModel>>>();
    private static final Map<ResourceLocation, GeometryModel> MODELS = new HashMap<ResourceLocation, GeometryModel>();

    public static void init() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)RELOADER, (ResourceLocation)new ResourceLocation("pollen", "geometry_model_manager"));
        GeometryModelManagerImpl.addLoader(new LocalGeometryModelLoader());
    }

    public static void addLoader(BackgroundLoader<Map<ResourceLocation, GeometryModel>> loader) {
        LOADERS.add(loader);
    }

    public static GeometryModel getModel(ResourceLocation location) {
        return MODELS.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown geometry model with key '{}'", (Object)location);
            return GeometryModel.EMPTY;
        });
    }

    private static class Reloader
    implements PreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap geometryModels = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(modelLoader -> modelLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(models -> {
                for (Map.Entry entry : models.entrySet()) {
                    if (geometryModels.put((ResourceLocation)entry.getKey(), (GeometryModel)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate geometry model: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + geometryModels.size() + " geometry models.");
                MODELS.clear();
                MODELS.putAll(geometryModels);
            }, gameExecutor);
        }
    }
}

