/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pinwheel.api.geometry.GeometryModelData;
import gg.moonflower.pinwheel.api.geometry.GeometryModelParser;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import gg.moonflower.pollen.impl.render.geometry.BedrockGeometryModel;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class LocalGeometryModelLoader
implements BackgroundLoader<Map<ResourceLocation, GeometryModel>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FOLDER = "pinwheel/geometry";

    @Override
    public CompletableFuture<Map<ResourceLocation, GeometryModel>> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, BedrockGeometryModel> modelLocations = new HashMap<ResourceLocation, BedrockGeometryModel>();
            for (Map.Entry entry : resourceManager.m_214159_(FOLDER, resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).entrySet()) {
                ResourceLocation modelLocation = (ResourceLocation)entry.getKey();
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        GeometryModelData[] models;
                        for (GeometryModelData model : models = GeometryModelParser.parseModel((Reader)reader)) {
                            ResourceLocation id = new ResourceLocation(modelLocation.m_135827_(), model.description().identifier());
                            if (modelLocations.put(id, new BedrockGeometryModel(model)) == null) continue;
                            LOGGER.warn("Duplicate geometry model with id '" + id + "'");
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load geometry file '" + modelLocation.m_135827_() + ":" + modelLocation.m_135815_().substring(FOLDER.length() + 1, modelLocation.m_135815_().length() - 5) + "'", (Throwable)e);
                }
            }
            return modelLocations;
        }, backgroundExecutor);
    }
}

