/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.instance;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.bridge.MolangVariable;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pinwheel.api.particle.ParticleContext;
import gg.moonflower.pinwheel.api.particle.ParticleData;
import gg.moonflower.pinwheel.api.particle.ParticleEvent;
import gg.moonflower.pinwheel.api.particle.component.ParticleComponent;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponentFactory;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponentType;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponents;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleCurves;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleManager;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleComponent;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysics;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysicsComponent;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleTickComponent;
import gg.moonflower.pollen.api.render.particle.v1.listener.BedrockParticleListener;
import gg.moonflower.pollen.impl.render.particle.BedrockParticlePhysicsImpl;
import gg.moonflower.pollen.impl.render.particle.ProfilingMolangEnvironment;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public abstract class BedrockParticleImpl
extends Particle
implements BedrockParticle,
MolangVariableProvider {
    private static final Set<VoxelShape> COLLISION_SHAPES = new HashSet<VoxelShape>();
    protected static final Logger LOGGER = LoggerFactory.getLogger(BedrockParticle.class);
    protected static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);
    protected final ResourceLocation name;
    protected final ParticleData data;
    protected final BedrockParticleCurves curves;
    protected final MolangEnvironment environment;
    protected final Random random;
    protected final MolangVariable renderAge;
    protected final MolangVariable lifetime;
    protected final MolangVariable random1;
    protected final MolangVariable random2;
    protected final MolangVariable random3;
    protected final MolangVariable random4;
    private final Set<BedrockParticleListener> listeners;
    private final Set<BedrockParticleTickComponent> tickComponents;
    private final Set<BedrockParticlePhysicsComponent> physicsComponents;
    private final Vector3d pos;
    private final Vector3d renderPos;
    private final BlockPos.MutableBlockPos blockPos;
    private final Vector3d delta;
    private BedrockParticlePhysicsImpl physics;
    private float radius;
    protected int age;
    protected boolean disableMovement;

    protected BedrockParticleImpl(ClientLevel level, double x, double y, double z, ResourceLocation name) {
        super(level, x, y, z);
        this.name = name;
        this.data = BedrockParticleManager.getParticle(this.name);
        this.curves = new BedrockParticleCurves(this.data);
        this.environment = new ProfilingMolangEnvironment(MolangRuntime.runtime().setVariables((MolangVariableProvider)this.curves).create(), level.m_46658_());
        this.random = new Random();
        this.renderAge = MolangVariable.create();
        this.lifetime = MolangVariable.create();
        this.random1 = MolangVariable.create((float)this.random.nextFloat());
        this.random2 = MolangVariable.create((float)this.random.nextFloat());
        this.random3 = MolangVariable.create((float)this.random.nextFloat());
        this.random4 = MolangVariable.create((float)this.random.nextFloat());
        this.listeners = new HashSet<BedrockParticleListener>();
        this.tickComponents = new HashSet<BedrockParticleTickComponent>();
        this.physicsComponents = new HashSet<BedrockParticlePhysicsComponent>();
        this.pos = new Vector3d();
        this.renderPos = new Vector3d();
        this.blockPos = new BlockPos.MutableBlockPos();
        this.delta = new Vector3d();
        this.f_107204_ = 0.0f;
        this.f_107231_ = 0.0f;
        this.physics = null;
        this.radius = 0.1f;
        this.age = -1;
    }

    protected void addComponents() {
        this.data.components().forEach((component, data) -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)component);
            if (id == null) {
                LOGGER.warn(this.getPrefix().getString() + "Invalid component id: {}", component);
                return;
            }
            BedrockParticleComponentType type = (BedrockParticleComponentType)BedrockParticleComponents.COMPONENTS.getRegistrar().get(id);
            if (type == null) {
                LOGGER.warn(this.getPrefix().getString() + "Unknown component: {}", (Object)id);
                return;
            }
            try {
                this.addComponent(type.componentFactory(), (ParticleComponent)data);
            }
            catch (Exception e) {
                LOGGER.error(this.getPrefix().getString() + "Failed to create component: {}", component, (Object)e);
            }
        });
    }

    @Nullable
    protected BedrockParticleComponent addComponent(BedrockParticleComponentFactory<?> type, ParticleComponent data) {
        BedrockParticleComponent tickComponent;
        if (!type.isValid(this)) {
            return null;
        }
        BedrockParticleComponent component = type.create(this, data);
        if (component instanceof BedrockParticleListener) {
            BedrockParticleListener listener = (BedrockParticleListener)((Object)component);
            this.addListener(listener);
        }
        if (component instanceof BedrockParticleTickComponent) {
            tickComponent = (BedrockParticleTickComponent)component;
            this.tickComponents.add((BedrockParticleTickComponent)tickComponent);
        }
        if (component instanceof BedrockParticlePhysicsComponent) {
            tickComponent = (BedrockParticlePhysicsComponent)component;
            this.physicsComponents.add((BedrockParticlePhysicsComponent)tickComponent);
            if (this.physics == null) {
                this.physics = new BedrockParticlePhysicsImpl();
            }
        }
        return component;
    }

    protected Component getPrefix() {
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)("[" + this.name + "]")).m_130940_(ChatFormatting.AQUA)).m_130946_(" ");
    }

    public void m_5989_() {
        ProfilerFiller profiler = this.f_107208_.m_46473_();
        profiler.m_6180_("pollen");
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        if (this.age == -1) {
            this.age = 0;
            profiler.m_6180_("init");
            this.listeners.forEach(listener -> listener.onCreate(this));
            profiler.m_7238_();
        }
        this.curves.evaluate(this.getEnvironment(), profiler);
        profiler.m_6180_("components");
        this.tickComponents.forEach(BedrockParticleTickComponent::tick);
        profiler.m_7238_();
        if (this.physics != null) {
            this.f_107219_ = this.physics.hasCollision();
            if (this.f_107219_) {
                profiler.m_6180_("physics");
                float radius = this.physics.getCollisionRadius();
                if (this.radius != radius) {
                    this.radius = radius;
                    this.m_107250_(radius * 2.0f, radius * 2.0f);
                }
                if (!this.disableMovement) {
                    profiler.m_6180_("components");
                    this.physicsComponents.forEach(BedrockParticlePhysicsComponent::physicsTick);
                    profiler.m_6182_("move");
                    this.physics.tick();
                    float speed = this.physics.getSpeed();
                    if ((double)(speed * speed) > 1.0E-7) {
                        Vector3dc direction = this.physics.getDirection();
                        this.m_6257_(direction.x() * (double)speed, direction.y() * (double)speed, direction.z() * (double)speed);
                    }
                    profiler.m_7238_();
                }
                profiler.m_7238_();
            }
        }
        ++this.age;
        profiler.m_7238_();
    }

    public void m_6257_(double dx, double dy, double dz) {
        double g = dx;
        double h = dy;
        double i = dz;
        if (this.physics != null && (dx != 0.0 || dy != 0.0 || dz != 0.0) && dx * dx + dy * dy + dz * dz < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            BedrockParticleImpl.collideBoundingBox(this.delta.set(dx, dy, dz), this.m_107277_(), (Level)this.f_107208_);
            dx = this.delta.x();
            dy = this.delta.y();
            dz = this.delta.z();
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
            this.m_107275_();
            for (BedrockParticleListener listener2 : this.listeners) {
                listener2.onMove(this, dx, dy, dz);
            }
        }
        if (this.physics != null) {
            boolean xCollision = Math.abs(g) >= (double)1.0E-5f && Math.abs(dx) < (double)1.0E-5f;
            boolean yCollision = Math.abs(h) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f;
            boolean zCollision = Math.abs(i) >= (double)1.0E-5f && Math.abs(dz) < (double)1.0E-5f;
            boolean bl = this.f_107218_ = h != dy && h < 0.0;
            if (xCollision || yCollision || zCollision) {
                this.listeners.forEach(listener -> listener.onCollide(this, xCollision, yCollision, zCollision));
                if (this.f_107218_ && (double)(this.physics.getSpeed() * this.physics.getSpeed()) <= 1.0E-7) {
                    this.disableMovement = true;
                }
            }
        }
    }

    private static synchronized void collideBoundingBox(Vector3d delta, AABB box, Level level) {
        boolean zCollide;
        COLLISION_SHAPES.clear();
        level.m_186434_(null, box.m_82363_(delta.x(), delta.y(), delta.z())).forEach(COLLISION_SHAPES::add);
        if (COLLISION_SHAPES.isEmpty()) {
            return;
        }
        double x = delta.x();
        double y = delta.y();
        double z = delta.z();
        if (y != 0.0 && (y = Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)box, COLLISION_SHAPES, (double)y)) != 0.0) {
            box = box.m_82386_(0.0, y, 0.0);
        }
        boolean bl = zCollide = Math.abs(x) < Math.abs(z);
        if (zCollide && z != 0.0 && (z = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)box, COLLISION_SHAPES, (double)z)) != 0.0) {
            box = box.m_82386_(0.0, 0.0, z);
        }
        if (x != 0.0) {
            x = Shapes.m_193135_((Direction.Axis)Direction.Axis.X, (AABB)box, COLLISION_SHAPES, (double)x);
            if (!zCollide && x != 0.0) {
                box = box.m_82386_(x, 0.0, 0.0);
            }
        }
        if (!zCollide && z != 0.0) {
            z = Shapes.m_193135_((Direction.Axis)Direction.Axis.Z, (AABB)box, COLLISION_SHAPES, (double)z);
        }
        delta.set(x, y, z);
    }

    public void m_107274_() {
        super.m_107274_();
        this.listeners.forEach(listener -> listener.onExpire(this));
    }

    @Override
    public void addListener(BedrockParticleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(BedrockParticleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void runEvent(String name) {
        if (this.data.events().containsKey(name)) {
            ((ParticleEvent)this.data.events().get(name)).execute((ParticleContext)this);
        }
    }

    public void particleEffect(String effect, ParticleEvent.ParticleSpawnType type) {
        try {
            switch (type) {
                case EMITTER: 
                case EMITTER_BOUND: {
                    this.getEmitter().particleEffect(effect, ParticleEvent.ParticleSpawnType.PARTICLE);
                    break;
                }
                case PARTICLE: {
                    this.f_107208_.m_7106_(BedrockParticle.getOptions(effect), this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                    break;
                }
                case PARTICLE_WITH_VELOCITY: {
                    double zd;
                    double yd;
                    double xd;
                    if (this.physics != null) {
                        Vector3dc velocity = this.physics.getVelocity();
                        xd = velocity.x();
                        yd = velocity.y();
                        zd = velocity.z();
                    } else {
                        xd = 0.0;
                        yd = 0.0;
                        zd = 0.0;
                    }
                    this.f_107208_.m_7106_(BedrockParticle.getOptions(effect), this.f_107212_, this.f_107213_, this.f_107214_, xd, yd, zd);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(this.getPrefix().getString() + "Failed to spawn particle: {}", (Object)effect, (Object)e);
        }
    }

    public void soundEffect(String sound) {
        ResourceLocation soundId = ResourceLocation.m_135820_((String)sound);
        if (soundId == null) {
            LOGGER.error("Invalid sound id: {}", (Object)sound);
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundId, SoundSource.AMBIENT, 1.0f, 1.0f, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.LINEAR, this.f_107212_, this.f_107213_, this.f_107214_, false));
    }

    public void log(String message) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237119_().m_7220_(this.getPrefix()).m_130946_(message));
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public Vector3dc position() {
        return this.pos.set(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPos;
    }

    @Override
    public float roll() {
        return this.f_107231_;
    }

    @Override
    public Vector3dc position(float partialTicks) {
        return this.renderPos.set(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_), Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_), Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_));
    }

    @Override
    public float roll(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
    }

    @Override
    public void expire() {
        this.m_107274_();
    }

    @Override
    public boolean isExpired() {
        return !this.m_107276_();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    public ClientLevel getLevel() {
        return this.f_107208_;
    }

    @Override
    @Nullable
    public BedrockParticlePhysics getPhysics() {
        return this.physics;
    }

    public float getParticleAge() {
        return this.renderAge.getValue();
    }

    public float getParticleLifetime() {
        return this.lifetime.getValue();
    }

    @Override
    public void setLifetime(float time) {
        this.lifetime.setValue(time);
    }

    @Override
    public void setX(double x) {
        this.f_107212_ = x;
        this.blockPos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Override
    public void setY(double y) {
        this.f_107213_ = y;
        this.blockPos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Override
    public void setZ(double z) {
        this.f_107214_ = z;
        this.blockPos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.m_107259_(new AABB(x - (double)this.radius, y, z - (double)this.radius, x + (double)this.radius, y + (double)(this.radius * 2.0f), z + (double)this.radius));
        this.blockPos.m_122169_(x, y, z);
    }

    @Override
    public void setRoll(float roll) {
        if (this.f_107204_ == 0.0f && this.f_107231_ == 0.0f) {
            this.f_107204_ = roll;
        }
        this.f_107231_ = roll;
    }

    public MolangEnvironment getEnvironment() {
        return this.environment;
    }
}

