/*
 * Decompiled with CFR 0.152.
 */
package net.sydokiddo.auditory.mixin.items;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.sydokiddo.auditory.Auditory;
import net.sydokiddo.auditory.sound.ModSoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class WeaponSwingMixin
extends Entity {
    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    public WeaponSwingMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private void auditory_playSwordSounds() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.ITEM_SWORD_SWING.get(), SoundSource.PLAYERS, 0.1f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
    }

    @Unique
    private void auditory_playAxeSounds() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.ITEM_AXE_SWING.get(), SoundSource.PLAYERS, 0.1f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
    }

    @Unique
    private void auditory_playToolSounds() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.ITEM_TOOL_SWING.get(), SoundSource.PLAYERS, 0.1f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
    }

    @Unique
    private void auditory_playLightweightToolSounds() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.ITEM_TOOL_SWING.get(), SoundSource.PLAYERS, 0.1f, 1.4f + this.f_19853_.f_46441_.m_188501_() * 0.8f);
    }

    @Unique
    private void auditory_playEmptyHandSounds() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 0.1f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
    }

    @Inject(at={@At(value="NEW", target="net/minecraft/network/protocol/game/ClientboundAnimatePacket")}, method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"})
    private void auditory_swingSounds(InteractionHand interactionHand, boolean bl, CallbackInfo ci) {
        ItemStack itemStack = this.m_21120_(interactionHand);
        if (itemStack.m_41720_() instanceof SwordItem && Auditory.getConfig().weapon_sounds.sword_swinging_sounds) {
            this.auditory_playSwordSounds();
        } else if (itemStack.m_41720_() instanceof AxeItem && Auditory.getConfig().weapon_sounds.axe_swinging_sounds) {
            this.auditory_playAxeSounds();
        } else if (itemStack.m_41720_() instanceof TridentItem && Auditory.getConfig().weapon_sounds.trident_swinging_sounds) {
            this.auditory_playSwordSounds();
        } else if (itemStack.m_41720_() instanceof PickaxeItem && Auditory.getConfig().weapon_sounds.pickaxe_swinging_sounds) {
            this.auditory_playToolSounds();
        } else if (itemStack.m_41720_() instanceof ShovelItem && Auditory.getConfig().weapon_sounds.shovel_swinging_sounds) {
            this.auditory_playToolSounds();
        } else if (itemStack.m_41720_() instanceof HoeItem && Auditory.getConfig().weapon_sounds.hoe_swinging_sounds) {
            this.auditory_playToolSounds();
        } else if (itemStack.m_41720_() instanceof ShearsItem && Auditory.getConfig().weapon_sounds.shear_swinging_sounds) {
            this.auditory_playLightweightToolSounds();
        } else if (itemStack.m_41619_() && Auditory.getConfig().weapon_sounds.fist_swinging_sounds) {
            this.auditory_playEmptyHandSounds();
        }
    }
}

