/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.blockswap.BlockSwap;
import corgitaco.blockswap.shadow.blue.endless.jankson.api.SyntaxError;
import corgitaco.blockswap.util.CodecUtil;
import corgitaco.blockswap.util.CommentedCodec;
import corgitaco.blockswap.util.jankson.JanksonJsonOps;
import corgitaco.blockswap.util.jankson.JanksonUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;

public record MissingBlockIDsConfig(Map<String, Block> idRemapper) {
    private static final String ID_REMAPPER_EXAMPLE = "\t\"swapper\": {\n\t          Broken ID             Valid ID\n\t\t\"minecraft:coarse_dirt\": \"minecraft:dirt\",\n\t\t\"minecraft:diamond_block\": \"minecraft:emerald_block\"\n\t}\n";
    private static final Codec<MissingBlockIDsConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommentedCodec.of(Codec.unboundedMap((Codec)Codec.STRING, CodecUtil.BLOCK_CODEC), "id_remapper", "A map of blocks that specifies what the \"old\" broken block is and what its \"new\" functional block is.\nExample:\n\t\"swapper\": {\n\t          Broken ID             Valid ID\n\t\t\"minecraft:coarse_dirt\": \"minecraft:dirt\",\n\t\t\"minecraft:diamond_block\": \"minecraft:emerald_block\"\n\t}\n").forGetter(MissingBlockIDsConfig::idRemapper)).apply((Applicative)builder, MissingBlockIDsConfig::new));
    private static MissingBlockIDsConfig CONFIG = null;

    public static MissingBlockIDsConfig getConfig(boolean reload) {
        return MissingBlockIDsConfig.getConfig(reload, false);
    }

    public static MissingBlockIDsConfig getConfig(boolean reload, boolean genempty) {
        if (CONFIG == null || reload) {
            Path path = BlockSwap.CONFIG_PATH.resolve("missing_block_ids.json5");
            File configFile = path.toFile();
            try {
                if (!configFile.exists()) {
                    JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map<String, String>)new Object2ObjectOpenHashMap(), JanksonJsonOps.INSTANCE, new MissingBlockIDsConfig(new IdentityHashMap<String, Block>()));
                }
                if (genempty && !configFile.exists()) {
                    JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map<String, String>)new Object2ObjectOpenHashMap(), JanksonJsonOps.INSTANCE, new MissingBlockIDsConfig(new IdentityHashMap<String, Block>()));
                    return null;
                }
                CONFIG = JanksonUtil.readConfig(path, CODEC, JanksonJsonOps.INSTANCE);
            }
            catch (SyntaxError | IOException e) {
                e.printStackTrace();
            }
        }
        return CONFIG;
    }
}

