/*
 * Decompiled with CFR 0.152.
 */
package forge.cc.cassian.campfire;

import dev.architectury.injectables.annotations.ExpectPlatform;
import forge.cc.cassian.campfire.config.ModConfig;
import forge.cc.cassian.campfire.forge.CampfireModImpl;
import java.util.List;
import java.util.Objects;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public final class CampfireMod {
    public static final String MOD_ID = "comfortable_campfires";
    public static final Logger LOGGER = LogManager.getLogManager().getLogger("Comfortable Campfires");

    public static void init() {
        ModConfig.load();
    }

    public static void applyPlayerEffects(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            int amplifier = 0;
            AABB box = new AABB(pos).m_82400_((double)ModConfig.get().distance).m_82363_(0.0, (double)ModConfig.get().distance, 0.0);
            List list = world.m_45976_(Player.class, box);
            MobEffect statusEffect = CampfireMod.checkConfigAndGetEffect();
            for (Player playerEntity : list) {
                if (playerEntity.m_21023_(statusEffect)) {
                    if (Objects.requireNonNull(playerEntity.m_21124_(statusEffect)).m_19557_() >= 60) continue;
                    playerEntity.m_7292_(new MobEffectInstance(statusEffect, ModConfig.get().duration * 20, amplifier, true, true));
                    continue;
                }
                playerEntity.m_7292_(new MobEffectInstance(statusEffect, ModConfig.get().duration * 20, amplifier, true, true));
            }
        }
    }

    public static MobEffect checkConfigAndGetEffect() {
        if (ModConfig.get().useComfort) {
            return CampfireMod.getEffect();
        }
        return MobEffects.f_19605_;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MobEffect getEffect() {
        return CampfireModImpl.getEffect();
    }
}

