/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.env.pocket.AirPocket;
import team.creative.ambientsounds.env.pocket.AirPocketScanner;
import team.creative.creativecore.client.CreativeCoreClient;

public class TerrainEnvironment {
    public double averageHeight = 60.0;
    public int minHeight = 60;
    public int maxHeight = 60;
    public AirPocket airPocket = new AirPocket();
    public AirPocketScanner scanner;

    public void analyze(AmbientEngine engine, AmbientDimension dimension, Player player, Level level) {
        this.analyzeHeight(engine, dimension, player, level);
        this.analyzeAirPocket(engine, player, level);
    }

    public void analyzeHeight(AmbientEngine engine, AmbientDimension dimension, Player player, Level level) {
        if (dimension.averageHeight != null) {
            this.averageHeight = dimension.averageHeight.intValue();
            this.minHeight = dimension.averageHeight;
            this.maxHeight = dimension.averageHeight;
            return;
        }
        int sum = 0;
        int count = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos center = player.m_20183_();
        for (int x = -engine.averageHeightScanCount; x <= engine.averageHeightScanCount; ++x) {
            for (int z = -engine.averageHeightScanCount; z <= engine.averageHeightScanCount; ++z) {
                pos.m_122178_(center.m_123341_() + engine.averageHeightScanDistance * x, center.m_123342_(), center.m_123343_() + engine.averageHeightScanDistance * z);
                int height = TerrainEnvironment.getHeightBlock(level, pos);
                min = Math.min(height, min);
                max = Math.max(height, max);
                sum += height;
                ++count;
            }
        }
        this.averageHeight = (double)sum / (double)count;
        this.minHeight = min;
        this.maxHeight = max;
    }

    public void analyzeAirPocket(AmbientEngine engine, Player player, Level level) {
        if (this.scanner == null) {
            this.scanner = new AirPocketScanner(engine, level, new BlockPos(player.m_20299_(CreativeCoreClient.getFrameTime())), x -> {
                this.airPocket = x;
                this.scanner = null;
            });
        }
    }

    public static int getHeightBlock(Level level, BlockPos.MutableBlockPos pos) {
        int heighest = 0;
        for (int y = level.m_6042_().f_156648_(); y > level.m_6042_().f_156647_(); --y) {
            pos.m_142448_(y);
            BlockState state = level.m_8055_((BlockPos)pos);
            if (!state.m_60804_((BlockGetter)level, (BlockPos)pos) && !state.m_204336_(BlockTags.f_13035_) && !level.m_6425_((BlockPos)pos).m_205070_(FluidTags.f_13131_)) continue;
            heighest = y;
            break;
        }
        return heighest;
    }
}

