/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.berry_good.core;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.berry_good.core.BGConfig;
import com.teamabnormals.berry_good.core.data.client.BGBlockStateProvider;
import com.teamabnormals.berry_good.core.data.client.BGItemModelProvider;
import com.teamabnormals.berry_good.core.data.client.BGLanguageProvider;
import com.teamabnormals.berry_good.core.data.client.BGSoundDefinitionsProvider;
import com.teamabnormals.berry_good.core.data.server.BGLootTableProvider;
import com.teamabnormals.berry_good.core.data.server.BGRecipeProvider;
import com.teamabnormals.berry_good.core.data.server.modifiers.BGAdvancementModifierProvider;
import com.teamabnormals.berry_good.core.data.server.tags.BGBlockTagsProvider;
import com.teamabnormals.berry_good.core.data.server.tags.BGItemTagsProvider;
import com.teamabnormals.berry_good.core.registry.BGItems;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod(value="berry_good")
public class BerryGood {
    public static final String MOD_ID = "berry_good";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("berry_good");

    public BerryGood() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BGConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DataUtil.registerCompostable((ItemLike)((ItemLike)BGItems.SWEET_BERRY_PIPS.get()), (float)0.3f);
            DataUtil.registerCompostable((ItemLike)((ItemLike)BGItems.GLOW_BERRY_PIPS.get()), (float)0.3f);
            if (((Boolean)BGConfig.COMMON.glowBerriesGiveGlowing.get()).booleanValue()) {
                Supplier<MobEffectInstance> instance = () -> new MobEffectInstance(MobEffects.f_19619_, 300);
                ObfuscationReflectionHelper.setPrivateValue(FoodProperties.class, (Object)Foods.f_150381_, Collections.singletonList(Pair.of(instance, (Object)Float.valueOf(1.0f))), (String)"f_38728_");
            }
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        BGBlockTagsProvider blockTags = new BGBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new BGItemTagsProvider(generator, blockTags, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new BGLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new BGRecipeProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new BGAdvancementModifierProvider(generator));
        boolean includeClient = event.includeClient();
        generator.m_236039_(includeClient, (DataProvider)new BGItemModelProvider(generator, existingFileHelper));
        generator.m_236039_(includeClient, (DataProvider)new BGBlockStateProvider(generator, existingFileHelper));
        generator.m_236039_(includeClient, (DataProvider)new BGLanguageProvider(generator));
        generator.m_236039_(includeClient, (DataProvider)new BGSoundDefinitionsProvider(generator, existingFileHelper));
    }
}

