/*
 * Decompiled with CFR 0.152.
 */
package ihh.propertymodifier;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import ihh.propertymodifier.Logger;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> ConfigObject<T> define(ForgeConfigSpec.Builder builder, String name, Codec<T> codec, T defaultValue) {
        Object o = codec.encodeStart((DynamicOps)TomlConfigOps.INSTANCE, defaultValue).getOrThrow(false, e -> Logger.forceError("Unable to encode default value: " + e));
        return new ConfigObject<T>((ForgeConfigSpec.ConfigValue<Object>)builder.define(name, o), codec, defaultValue, o);
    }

    private static class TomlConfigOps
    implements DynamicOps<Object> {
        public static TomlConfigOps INSTANCE = new TomlConfigOps();

        private TomlConfigOps() {
        }

        public Object empty() {
            return NullObject.NULL_OBJECT;
        }

        public <T> T convertTo(DynamicOps<T> ops, Object o) {
            if (o instanceof Config) {
                return (T)this.convertMap(ops, o);
            }
            if (o instanceof Collection) {
                return (T)this.convertList(ops, o);
            }
            if (o == null || o instanceof NullObject) {
                return (T)ops.empty();
            }
            if (o instanceof Enum) {
                Enum e = (Enum)o;
                return (T)ops.createString(e.name());
            }
            if (o instanceof Temporal) {
                return (T)ops.createString(o.toString());
            }
            if (o instanceof String) {
                String s = (String)o;
                return (T)ops.createString(s);
            }
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                return (T)ops.createBoolean(b.booleanValue());
            }
            if (o instanceof Number) {
                Number n = (Number)o;
                return (T)ops.createNumeric(n);
            }
            throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + o);
        }

        public DataResult<Number> getNumberValue(Object o) {
            DataResult dataResult;
            if (o instanceof Number) {
                Number n = (Number)o;
                dataResult = DataResult.success((Object)n);
            } else {
                dataResult = DataResult.error((String)("Not a number: " + o));
            }
            return dataResult;
        }

        public Object createNumeric(Number n) {
            return n;
        }

        public DataResult<Boolean> getBooleanValue(Object o) {
            DataResult dataResult;
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                dataResult = DataResult.success((Object)b);
            } else {
                dataResult = DataResult.error((String)("Not a boolean: " + o));
            }
            return dataResult;
        }

        public Object createBoolean(boolean b) {
            return b;
        }

        public DataResult<String> getStringValue(Object o) {
            return o instanceof Config || o instanceof Collection ? DataResult.error((String)("Not a string: " + o)) : DataResult.success((Object)String.valueOf(o));
        }

        public Object createString(String s) {
            return s;
        }

        public DataResult<Object> mergeToList(Object list, Object value) {
            if (!(list instanceof Collection) && list != this.empty()) {
                return DataResult.error((String)("mergeToList called with not a list: " + list), (Object)list);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            if (list != this.empty() && list instanceof Collection) {
                Collection collection = (Collection)list;
                result.addAll(collection);
            }
            result.add(value);
            return DataResult.success(result);
        }

        public DataResult<Object> mergeToList(Object list, List<Object> values) {
            return super.mergeToList(list, values).map(e -> e == this.empty() ? new ArrayList() : e);
        }

        public Object createList(Stream<Object> s) {
            return s.toList();
        }

        public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
            if (!(map instanceof Config) && map != this.empty()) {
                return DataResult.error((String)("mergeToMap called with not a map: " + map), (Object)map);
            }
            DataResult<String> dr = this.getStringValue(key);
            return dr.error().isPresent() ? DataResult.error((String)("Key is not a string: " + key), (Object)map) : dr.flatMap(e -> {
                CommentedConfig result = TomlFormat.newConfig();
                if (map != this.empty() && map instanceof Config) {
                    Config config = (Config)map;
                    result.addAll((UnmodifiableConfig)config);
                }
                result.add(e, value);
                return DataResult.success((Object)result);
            });
        }

        public Object createMap(Stream<Pair<Object, Object>> s) {
            CommentedConfig result = TomlFormat.newConfig();
            s.forEach(arg_0 -> this.lambda$createMap$3((Config)result, arg_0));
            return result;
        }

        public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object o) {
            DataResult dataResult;
            if (o instanceof Config) {
                Config config = (Config)o;
                dataResult = DataResult.success(config.entrySet().stream().map(e -> Pair.of((Object)e.getKey(), (Object)e.getValue())));
            } else {
                dataResult = DataResult.error((String)("Not a config: " + o));
            }
            return dataResult;
        }

        public DataResult<Stream<Object>> getStream(Object o) {
            DataResult dataResult;
            if (o instanceof Collection) {
                Collection collection = (Collection)o;
                dataResult = DataResult.success(collection.stream().map(e -> e));
            } else {
                dataResult = DataResult.error((String)("Not a collection: " + o));
            }
            return dataResult;
        }

        public Object remove(Object input, String key) {
            if (!(input instanceof Config)) {
                return input;
            }
            Config config = (Config)input;
            CommentedConfig result = TomlFormat.newConfig();
            config.entrySet().stream().filter(e -> !Objects.equals(e.getKey(), key)).forEach(arg_0 -> TomlConfigOps.lambda$remove$7((Config)result, arg_0));
            return result;
        }

        public boolean compressMaps() {
            return false;
        }

        public String toString() {
            return "TOML";
        }

        private static /* synthetic */ void lambda$remove$7(Config result, Config.Entry e) {
            result.add(e.getKey(), e.getValue());
        }

        private /* synthetic */ void lambda$createMap$3(Config result, Pair e) {
            result.add((String)this.getStringValue(e.getFirst()).getOrThrow(false, p -> {}), e.getSecond());
        }
    }

    public static class ConfigObject<T>
    implements Supplier<T> {
        private final ForgeConfigSpec.ConfigValue<Object> value;
        private final Codec<T> codec;
        private final T defaultValue;
        private Object cached;
        private T parsed;

        private ConfigObject(ForgeConfigSpec.ConfigValue<Object> value, Codec<T> codec, T defaultValue, Object cached) {
            this.value = value;
            this.codec = codec;
            this.parsed = defaultValue;
            this.defaultValue = this.parsed;
            this.cached = cached;
        }

        @Override
        public T get() {
            Object freshValue = this.value.get();
            if (!Objects.equals(this.cached, freshValue)) {
                this.cached = freshValue;
                this.parsed = this.codec.parse((DynamicOps)TomlConfigOps.INSTANCE, freshValue).get().map(e -> e, e -> {
                    Logger.forceError("Using default config value due to parsing error: " + e.message());
                    return this.defaultValue;
                });
            }
            return this.parsed;
        }
    }
}

