/*
 * Decompiled with CFR 0.152.
 */
package ihh.propertymodifier;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ihh.propertymodifier.Config;
import ihh.propertymodifier.Logger;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="propertymodifier")
public final class EventHandler {
    @SubscribeEvent
    static void itemAttributeModifier(ItemAttributeModifierEvent e) {
        if (e.getSlotType() != EquipmentSlot.MAINHAND) {
            return;
        }
        Multimap<Attribute, AttributeModifier> newMap = Config.MODIFIERS.get(e.getItemStack().m_41720_());
        if (newMap != null) {
            Collection collection;
            Multimap oldMap = e.getOriginalModifiers();
            HashMultimap result = HashMultimap.create();
            for (Attribute attribute : newMap.keys()) {
                collection = result.get((Object)attribute);
                collection.addAll(newMap.get((Object)attribute));
                result.putAll((Object)attribute, (Iterable)collection);
            }
            for (Attribute attribute : oldMap.keys()) {
                collection = result.get((Object)attribute);
                if (result.containsKey((Object)attribute)) continue;
                collection.addAll(oldMap.get((Object)attribute));
                result.putAll((Object)attribute, (Iterable)collection);
            }
            e.clearModifiers();
            for (Attribute attribute : result.keys()) {
                for (AttributeModifier modifier : result.get((Object)attribute)) {
                    e.addModifier(attribute, modifier);
                }
            }
        }
    }

    @SubscribeEvent
    static void blockToolModification(BlockEvent.BlockToolModificationEvent e) {
        Block block = e.getContext().m_43725_().m_8055_(e.getPos()).m_60734_();
        if (e.getToolAction() == ToolActions.AXE_STRIP) {
            if (Config.AXE_STRIPPING.containsKey(block)) {
                e.setFinalState(Config.AXE_STRIPPING.get(block));
            } else if (((Boolean)Config.CLEAR_STRIPPING.get()).booleanValue()) {
                e.setFinalState(null);
            }
        }
        if (Config.SHOVEL_FLATTENING.containsKey(block)) {
            e.setFinalState(Config.SHOVEL_FLATTENING.get(block));
        } else if (((Boolean)Config.CLEAR_FLATTENING.get()).booleanValue()) {
            e.setFinalState(null);
        }
        if (Config.HOE_TILLING.containsKey(block)) {
            Config.Triple<BlockState, Boolean, Item> triple = Config.HOE_TILLING.get(block);
            if (triple.b != null && ((Boolean)triple.b).booleanValue() && !e.getLevel().m_8055_(e.getPos().m_7494_()).m_60795_()) {
                return;
            }
            if (triple.a != null) {
                e.setFinalState((BlockState)triple.a);
            }
            if (triple.c != null && !e.getLevel().m_5776_()) {
                Block.m_152435_((Level)e.getContext().m_43725_(), (BlockPos)e.getPos(), (Direction)e.getContext().m_43719_(), (ItemStack)new ItemStack((ItemLike)triple.c));
            }
        } else if (((Boolean)Config.CLEAR_TILLING.get()).booleanValue()) {
            e.setFinalState(null);
        }
    }

    @SubscribeEvent
    static void entityJoinWorld(EntityJoinLevelEvent e) {
        Mob mob;
        Entity entity = e.getEntity();
        if (entity instanceof Mob && Config.ENTITY_ATTRIBUTES.containsKey((mob = (Mob)entity).m_6095_())) {
            for (Attribute attribute : Config.ENTITY_ATTRIBUTES.get(mob.m_6095_()).keySet()) {
                double value = Config.ENTITY_ATTRIBUTES.get(mob.m_6095_()).get(attribute);
                AttributeInstance instance = mob.m_21204_().m_22146_(attribute);
                if (instance == null) {
                    Logger.error("Entity " + ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).toString() + " doesn't have an attribute " + ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString() + " that could be set");
                    continue;
                }
                instance.m_22100_(value);
                if (attribute != Attributes.f_22276_) continue;
                mob.m_21153_(mob.m_21233_());
            }
        }
    }
}

