/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.compost.client.option;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.ArrayUtils;

public class CompostConfig {
    public static File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "compost.json");
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Config config = new Config();

    public static void saveConfig() {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)CompostConfig.getConfig()));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        try {
            config = file.exists() ? (Config)gson.fromJson(Files.readString(file.toPath()), Config.class) : new Config();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CompostConfig.checkBounds();
        CompostConfig.setConfig(config);
    }

    public static void setConfig(Config config) {
        CompostConfig.config = config;
    }

    public static Config getConfig() {
        return config;
    }

    public static void checkBounds() {
        Arrays.stream(CompostConfig.config.items).forEach(group -> {
            int maxCount = CompostConfig.createItemStack(group).m_41720_().m_41459_();
            int min = Math.max(Math.min(Math.min(group.min, maxCount), group.max), 0);
            int max = Math.max(Math.max(Math.min(group.max, maxCount), group.min), 1);
            group.chance = Math.max(0.0, Math.min(group.chance, 1.0));
            group.min = min;
            group.max = max;
        });
        CompostConfig.saveConfig();
    }

    public static ItemStack createItemStack(Config.Group group) {
        Item item;
        int index;
        if (group.item.contains("{")) {
            index = group.item.indexOf("{");
            item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(group.item.substring(0, index)));
        } else {
            index = 0;
            item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(group.item));
        }
        ItemStack itemStack = new ItemStack((ItemLike)item, ThreadLocalRandom.current().nextInt(group.min, group.max + 1));
        if (group.item.contains("{")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)group.item.substring(index));
                itemStack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return itemStack;
    }

    public static Config.Group getGroup(int group) {
        return (Config.Group)ArrayUtils.get((Object[])CompostConfig.config.items, (int)group);
    }

    public static void addGroup(String item, double chance, int min, int max) {
        CompostConfig.config.items = (Config.Group[])ArrayUtils.add((Object[])CompostConfig.config.items, (Object)new Config.Group(item, chance, min, max));
        CompostConfig.saveConfig();
    }

    public static void removeGroup(int group) {
        CompostConfig.config.items = (Config.Group[])ArrayUtils.remove((Object[])CompostConfig.config.items, (int)group);
        CompostConfig.saveConfig();
    }

    public static class Config {
        public Group[] items = new Group[]{new Group("minecraft:dirt", 1.0, 1, 1), new Group("minecraft:bone_meal", 1.0, 1, 1)};

        public static class Group {
            public String item;
            public double chance;
            public int min;
            public int max;

            Group(String item, double chance, int min, int max) {
                this.item = item;
                this.chance = chance;
                this.min = min;
                this.max = max;
            }
        }
    }
}

