/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.compost.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.yurisuika.compost.client.option.CompostConfig;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class CompostCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"compost").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"reload").executes(context -> {
            CompostConfig.loadConfig();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.compost.config.reload"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"reset").executes(context -> {
            int length = CompostConfig.config.items.length;
            for (int i = 0; i < length; ++i) {
                CompostConfig.removeGroup(0);
            }
            CompostConfig.addGroup("minecraft:dirt", 1.0, 1, 1);
            CompostConfig.addGroup("minecraft:bone_meal", 1.0, 1, 1);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.compost.config.reset"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"groups").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"query").executes(context -> {
            for (CompostConfig.Config.Group group : CompostConfig.config.items) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.compost.groups.query", (Object[])new Object[]{ArrayUtils.indexOf((Object[])CompostConfig.config.items, (Object)group) + 1, CompostConfig.createItemStack(group).m_41611_(), new DecimalFormat("0.###############").format(BigDecimal.valueOf(group.chance).multiply(BigDecimal.valueOf(100L))), group.min, group.max}), false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).then(Commands.m_82129_((String)"chance", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).then(Commands.m_82129_((String)"min", (ArgumentType)IntegerArgumentType.integer((int)0, (int)64)).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> {
            ItemInput arg = ItemArgument.m_120963_((CommandContext)context, (String)"item");
            ItemStack itemStack = arg.m_120980_(1, false);
            String item = arg.m_120988_();
            double chance = Math.max(0.0, Math.min(DoubleArgumentType.getDouble((CommandContext)context, (String)"chance"), 1.0));
            int min = Math.min(Math.min(IntegerArgumentType.getInteger((CommandContext)context, (String)"min"), itemStack.m_41741_()), IntegerArgumentType.getInteger((CommandContext)context, (String)"max"));
            int max = Math.max(Math.min(IntegerArgumentType.getInteger((CommandContext)context, (String)"max"), itemStack.m_41741_()), IntegerArgumentType.getInteger((CommandContext)context, (String)"min"));
            CompostConfig.addGroup(item, chance, min, max);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.compost.groups.add", (Object[])new Object[]{itemStack.m_41611_(), new DecimalFormat("0.###############").format(BigDecimal.valueOf(chance).multiply(BigDecimal.valueOf(100L))), min, max}), true);
            return 1;
        }))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"group", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int range = IntegerArgumentType.getInteger((CommandContext)context, (String)"group");
            if (range > CompostConfig.config.items.length) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.compost.groups.remove.failed", (Object[])new Object[]{range, CompostConfig.config.items.length}));
                return 0;
            }
            int number = IntegerArgumentType.getInteger((CommandContext)context, (String)"group") - 1;
            CompostConfig.Config.Group group = CompostConfig.getGroup(number);
            CompostConfig.removeGroup(number);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.compost.groups.remove", (Object[])new Object[]{CompostConfig.createItemStack(group).m_41611_(), new DecimalFormat("0.###############").format(BigDecimal.valueOf(group.chance).multiply(BigDecimal.valueOf(100L))), group.min, group.max}), true);
            return 1;
        })))));
    }
}

