/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic;

import com.google.common.base.Suppliers;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.common.NostalgicConnection;
import mod.adrenix.nostalgic.common.config.DefaultConfig;
import mod.adrenix.nostalgic.network.PacketRegistry;
import mod.adrenix.nostalgic.server.config.ServerConfigCache;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import mod.adrenix.nostalgic.util.common.log.ModLogger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;

public class NostalgicTweaks {
    public static final String MOD_ID = "nostalgic_tweaks";
    public static final String MOD_NAME = "Nostalgic Tweaks";
    public static final ModLogger LOGGER = new ModLogger("Nostalgic Tweaks");
    public static final Supplier<String> VERSION = Suppliers.memoize(() -> ((Mod)Platform.getMod((String)"nostalgic_tweaks")).getVersion());
    private static final boolean isEventTesting = false;
    public static final NetworkChannel NETWORK = NetworkChannel.create((ResourceLocation)new ResourceLocation("nostalgic_tweaks", "network"));
    public static final String PROTOCOL = "1.3";
    private static boolean isNetworkSupported = false;
    private static NostalgicConnection connection = null;
    private static MinecraftServer server;

    public static String getTinyVersion() {
        return TextUtil.extract(VERSION.get(), "(\\d\\.\\d\\.\\d)");
    }

    public static String getBetaVersion() {
        return TextUtil.extract(VERSION.get(), "Beta-\\d+(?:\\.\\d+)?");
    }

    public static String getFullVersion() {
        return String.format("%s-%s-%s", TextUtil.toTitleCase(NostalgicTweaks.getLoader()), Platform.getMinecraftVersion(), VERSION.get());
    }

    public static String getShortVersion() {
        return String.format("%s-%s", Platform.getMinecraftVersion(), VERSION.get());
    }

    public static boolean isDebugging() {
        return LOGGER.isDebugMode();
    }

    public static boolean isEventTesting() {
        if (Platform.isDevelopmentEnvironment()) {
            // empty if block
        }
        return false;
    }

    public static String getProtocol() {
        return PROTOCOL;
    }

    public static void setConnection(@Nullable NostalgicConnection data) {
        connection = data;
    }

    public static Optional<NostalgicConnection> getConnection() {
        return Optional.ofNullable(connection);
    }

    public static void setServer(MinecraftServer server) {
        NostalgicTweaks.server = server;
    }

    @CheckForNull
    public static MinecraftServer getServer() {
        return server;
    }

    public static boolean isClient() {
        return Platform.getEnv() == Dist.CLIENT;
    }

    public static boolean isServer() {
        return Platform.getEnv() == Dist.DEDICATED_SERVER;
    }

    public static boolean isFabric() {
        return Platform.isFabric();
    }

    public static boolean isForge() {
        return Platform.isForge();
    }

    public static String getLoader() {
        return NostalgicTweaks.isForge() ? "FORGE" : "FABRIC";
    }

    public static boolean isNetworkVerified() {
        if (NostalgicTweaks.isServer()) {
            return true;
        }
        return isNetworkSupported;
    }

    public static void setNetworkVerification(boolean verified) {
        LOGGER.debug("Setting network verification to: %s", verified);
        isNetworkSupported = verified;
    }

    public static void initServer() {
        DefaultConfig.initialize();
        ServerConfigCache.initialize();
        PacketRegistry.initialize();
        LOGGER.warn("Nostalgic Tweaks server support is still in-development");
        LOGGER.warn("Please report any problems you encounter");
        LOGGER.info("Loading mod in [%s] server environment", LogColor.apply(LogColor.LIGHT_PURPLE, NostalgicTweaks.getLoader()));
    }

    public static void initClient() {
        DefaultConfig.initialize();
        ClientConfigCache.initialize();
        PacketRegistry.initialize();
        LOGGER.info("Loading mod in [%s] client environment", LogColor.apply(LogColor.LIGHT_PURPLE, NostalgicTweaks.getLoader()));
        if (ModTracker.OPTIFINE.isInstalled()) {
            LOGGER.warn("Optifine is installed - some tweaks may not work as intended");
        }
    }
}

