/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.auto.serializer.GsonConfigSerializer;
import net.minecraft.world.InteractionResult;

public abstract class ClientConfigCache {
    private static boolean initialized = false;
    private static final ClientConfig SERVER_CACHE = new ClientConfig();
    private static ClientConfig cache;

    private static ClientConfig getCache() {
        if (NostalgicTweaks.isServer()) {
            return SERVER_CACHE;
        }
        if (!initialized) {
            ClientConfigCache.preload();
        }
        return cache;
    }

    public static ClientConfig getRoot() {
        return ClientConfigCache.getCache();
    }

    public static ClientConfig.Sound getSound() {
        return ClientConfigCache.getCache().sound;
    }

    public static ClientConfig.EyeCandy getCandy() {
        return ClientConfigCache.getCache().eyeCandy;
    }

    public static ClientConfig.Gameplay getGameplay() {
        return ClientConfigCache.getCache().gameplay;
    }

    public static ClientConfig.Animation getAnimation() {
        return ClientConfigCache.getCache().animation;
    }

    public static ClientConfig.Swing getSwing() {
        return ClientConfigCache.getCache().swing;
    }

    public static ClientConfig.Gui getGui() {
        return ClientConfigCache.getCache().gui;
    }

    private static InteractionResult reload() {
        cache = AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        NostalgicTweaks.LOGGER.info("Config was reloaded");
        return InteractionResult.SUCCESS;
    }

    public static void preload() {
        if (NostalgicTweaks.isServer()) {
            String fail = String.format("[%s] Cannot initialize client config for server.", "Nostalgic Tweaks");
            throw new AssertionError((Object)fail);
        }
        NostalgicTweaks.LOGGER.info("Initializing client config prematurely for mixin compatibility");
        ClientConfigCache.initialize();
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AutoConfig.register(ClientConfig.class, GsonConfigSerializer::new);
        AutoConfig.getConfigHolder(ClientConfig.class).registerLoadListener((manager, update) -> ClientConfigCache.reload());
        AutoConfig.getConfigHolder(ClientConfig.class).registerSaveListener((manager, data) -> ClientConfigCache.reload());
        ClientConfigCache.reload();
        NostalgicTweaks.LOGGER.info("Loaded %d tweaks", TweakClientCache.all().size());
    }

    public static void save() {
        AutoConfig.getConfigHolder(ClientConfig.class).save();
    }
}

