/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config;

import java.util.Map;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.common.config.ModConfig;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.tweak.SwingTweak;
import mod.adrenix.nostalgic.util.client.AnimationUtil;
import mod.adrenix.nostalgic.util.client.SwingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;

public abstract class SwingConfig {
    private static final ClientConfig.Swing SWING = ClientConfigCache.getSwing();

    private static int getSpeedFromItem(Item item) {
        Map.Entry<String, Integer> entry;
        switch (AnimationUtil.swingType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT_CLICK: {
                Map.Entry<String, Integer> entry2 = ConfigList.LEFT_CLICK_SPEEDS.getEntryFromItem(item);
                break;
            }
            case RIGHT_CLICK: {
                Map.Entry<String, Integer> entry2 = entry = ConfigList.RIGHT_CLICK_SPEEDS.getEntryFromItem(item);
            }
        }
        if (SwingConfig.isSpeedGlobal()) {
            return switch (AnimationUtil.swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftGlobalSpeed;
                case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightGlobalSpeed;
            };
        }
        if (entry != null) {
            return entry.getValue();
        }
        if (item instanceof SwordItem) {
            return switch (AnimationUtil.swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftSwordSpeed;
                case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightSwordSpeed;
            };
        }
        if (item instanceof BlockItem) {
            return switch (AnimationUtil.swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftBlockSpeed;
                case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightBlockSpeed;
            };
        }
        if (item instanceof DiggerItem) {
            return switch (AnimationUtil.swingType) {
                default -> throw new IncompatibleClassChangeError();
                case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftToolSpeed;
                case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightToolSpeed;
            };
        }
        return switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftItemSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightItemSpeed;
        };
    }

    public static int getSwingSpeed(AbstractClientPlayer player) {
        if (ModConfig.isModEnabled()) {
            return SwingConfig.getSpeedFromItem(player.m_21205_().m_41720_());
        }
        return 6;
    }

    public static boolean isLeftSpeedOnBlockInteract() {
        return SwingConfig.SWING.leftClickSpeedOnBlockInteract;
    }

    public static boolean isOverridingSpeeds() {
        return !ModConfig.isTweakOn(SwingTweak.OVERRIDE_SPEEDS) || SwingConfig.SWING.overrideSpeeds;
    }

    public static boolean isOverridingFatigue() {
        boolean bl;
        block6: {
            block5: {
                if (!ModConfig.isModEnabled()) break block5;
                switch (AnimationUtil.swingType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT_CLICK: {
                        if (SwingConfig.SWING.leftFatigueSpeed != -1) {
                            break;
                        }
                        break block5;
                    }
                    case RIGHT_CLICK: {
                        if (SwingConfig.SWING.rightFatigueSpeed == -1) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isOverridingHaste() {
        boolean bl;
        block6: {
            block5: {
                if (!ModConfig.isModEnabled()) break block5;
                switch (AnimationUtil.swingType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT_CLICK: {
                        if (SwingConfig.SWING.leftHasteSpeed != -1) {
                            break;
                        }
                        break block5;
                    }
                    case RIGHT_CLICK: {
                        if (SwingConfig.SWING.rightHasteSpeed == -1) break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isSpeedGlobal() {
        return switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> {
                if (SwingConfig.SWING.leftGlobalSpeed != -1) {
                    yield true;
                }
                yield false;
            }
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightGlobalSpeed != -1;
        };
    }

    public static int getGlobalSpeed() {
        return switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftGlobalSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightGlobalSpeed;
        };
    }

    public static int getFatigueSpeed() {
        int global = switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftGlobalSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightGlobalSpeed;
        };
        int fatigue = switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftFatigueSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightFatigueSpeed;
        };
        return SwingConfig.isSpeedGlobal() ? global : fatigue;
    }

    public static int getHasteSpeed() {
        int global = switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftGlobalSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightGlobalSpeed;
        };
        int haste = switch (AnimationUtil.swingType) {
            default -> throw new IncompatibleClassChangeError();
            case SwingType.LEFT_CLICK -> SwingConfig.SWING.leftHasteSpeed;
            case SwingType.RIGHT_CLICK -> SwingConfig.SWING.rightHasteSpeed;
        };
        return SwingConfig.isSpeedGlobal() ? global : haste;
    }

    public static int getSwingSpeed() {
        return SwingConfig.getSwingSpeed((AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
    }
}

