/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.annotation;

import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.tweak.CandyTweak;
import mod.adrenix.nostalgic.common.config.tweak.GameplayTweak;
import mod.adrenix.nostalgic.common.config.tweak.TweakType;
import mod.adrenix.nostalgic.common.config.tweak.TweakVersion;

public abstract class AlertCondition {
    public static boolean isWindowTitleDisabled() {
        return (Boolean)TweakClientCache.get(CandyTweak.ENABLE_WINDOW_TITLE).getValue() == false;
    }

    public static boolean isShieldConflict() {
        boolean isModernShield = TweakClientCache.get(CandyTweak.INVENTORY_SHIELD).getValue() == TweakType.InventoryShield.MODERN;
        boolean isOldInventory = (Boolean)TweakClientCache.get(CandyTweak.OLD_INVENTORY).getValue();
        return isModernShield && isOldInventory;
    }

    public static boolean isLightConflict() {
        boolean isOldColor = (Boolean)TweakClientCache.get(CandyTweak.LIGHT_COLOR).getValue();
        boolean isOldLight = (Boolean)TweakClientCache.get(CandyTweak.LIGHT_RENDERING).getValue();
        return !isOldColor && isOldLight;
    }

    public static boolean isBrightnessConflict() {
        boolean isOldLight = (Boolean)TweakClientCache.get(CandyTweak.LIGHT_RENDERING).getValue();
        boolean isDisabledBrightness = (Boolean)TweakClientCache.get(CandyTweak.DISABLE_BRIGHTNESS).getValue();
        return !isOldLight && isDisabledBrightness;
    }

    public static boolean isVoidConflict() {
        boolean isDarkVoidHeight = (Boolean)TweakClientCache.get(CandyTweak.DARK_VOID_HEIGHT).getValue();
        boolean isBlueVoidOverride = (Boolean)TweakClientCache.get(CandyTweak.BLUE_VOID_OVERRIDE).getValue();
        return isDarkVoidHeight && isBlueVoidOverride;
    }

    public static boolean isUniversalFogConflict() {
        TweakVersion.FogColor fogColor = (TweakVersion.FogColor)TweakClientCache.get(CandyTweak.UNIVERSAL_FOG_COLOR).getValue();
        boolean isFogCustom = (Boolean)TweakClientCache.get(CandyTweak.CUSTOM_TERRAIN_FOG).getValue();
        boolean isFogDynamic = (Boolean)TweakClientCache.get(CandyTweak.DYNAMIC_FOG_COLOR).getValue();
        return fogColor != TweakVersion.FogColor.DISABLED && (isFogCustom || isFogDynamic);
    }

    public static boolean isUniversalSkyConflict() {
        TweakVersion.SkyColor skyColor = (TweakVersion.SkyColor)TweakClientCache.get(CandyTweak.UNIVERSAL_SKY_COLOR).getValue();
        boolean isSkyCustom = (Boolean)TweakClientCache.get(CandyTweak.CUSTOM_WORLD_SKY).getValue();
        boolean isSkyDynamic = (Boolean)TweakClientCache.get(CandyTweak.DYNAMIC_SKY_COLOR).getValue();
        return skyColor != TweakVersion.SkyColor.DISABLED && (isSkyCustom || isSkyDynamic);
    }

    public static boolean isDynamicFogConflict() {
        boolean isFogCustom = (Boolean)TweakClientCache.get(CandyTweak.CUSTOM_TERRAIN_FOG).getValue();
        boolean isFogDynamic = (Boolean)TweakClientCache.get(CandyTweak.DYNAMIC_FOG_COLOR).getValue();
        return isFogCustom && isFogDynamic;
    }

    public static boolean isDynamicSkyConflict() {
        boolean isSkyCustom = (Boolean)TweakClientCache.get(CandyTweak.CUSTOM_WORLD_SKY).getValue();
        boolean isSkyDynamic = (Boolean)TweakClientCache.get(CandyTweak.DYNAMIC_SKY_COLOR).getValue();
        return isSkyCustom && isSkyDynamic;
    }

    public static boolean isCustomFoodHealthConflict() {
        return (Boolean)TweakClientCache.get(GameplayTweak.HUNGER).getValue() == false;
    }

    public static boolean isCustomFoodStackingConflict() {
        return (Boolean)TweakClientCache.get(GameplayTweak.FOOD_STACKING).getValue() == false;
    }
}

