/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.client.config.annotation.AlertCondition;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakCategory;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakEmbed;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakSubcategory;

public abstract class TweakGui {

    public static enum Condition {
        VOID_CONFLICT(AlertCondition::isVoidConflict),
        LIGHT_CONFLICT(AlertCondition::isLightConflict),
        SHIELD_CONFLICT(AlertCondition::isShieldConflict),
        BRIGHTNESS_CONFLICT(AlertCondition::isBrightnessConflict),
        DYNAMIC_FOG_CONFLICT(AlertCondition::isDynamicFogConflict),
        DYNAMIC_SKY_CONFLICT(AlertCondition::isDynamicSkyConflict),
        WINDOW_TITLE_DISABLED(AlertCondition::isWindowTitleDisabled),
        UNIVERSAL_FOG_CONFLICT(AlertCondition::isUniversalFogConflict),
        UNIVERSAL_SKY_CONFLICT(AlertCondition::isUniversalSkyConflict),
        CUSTOM_FOOD_HEALTH_CONFLICT(AlertCondition::isCustomFoodHealthConflict),
        CUSTOM_FOOD_STACKING_CONFLICT(AlertCondition::isCustomFoodStackingConflict);

        private final Supplier<Boolean> condition;

        private Condition(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public boolean active() {
            return this.condition.get();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Alert {
        public Condition condition();

        public String langKey();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Slider {
        public SliderType type() default SliderType.SWING;

        public String langKey() default "";

        public String suffix() default "";
    }

    public static enum SliderType {
        GENERIC,
        HEARTS,
        SWING,
        CLOUD,
        INTENSITY;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Placement {
        public Position pos();

        public int order();
    }

    public static enum Position {
        TOP,
        BOTTOM;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Sodium {
        public boolean incompatible() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optifine {
        public boolean incompatible() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Restart {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Warning {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DisabledString {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DisabledBoolean {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DisabledInteger {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface IgnoreDisable {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NotAutomated {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoTooltip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Embed {
        public TweakEmbed container();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Subcategory {
        public TweakSubcategory container();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Category {
        public TweakCategory container();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface New {
    }
}

