/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.overlay;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayFlag;
import mod.adrenix.nostalgic.client.config.gui.overlay.template.GenericOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerButton;
import mod.adrenix.nostalgic.client.config.gui.widget.list.AbstractRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.mixin.widen.AbstractWidgetAccessor;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CategoryListOverlay
extends GenericOverlay {
    public static final int DEFAULT_WIDTH = 256;
    public static final int DEFAULT_HEIGHT = 220;
    private TextRowList list;
    private ConfigRowList configRowList;
    private ConfigRowList.Row selected = null;
    private static final String TWEAK_STAR = "*";

    public CategoryListOverlay() {
        super((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.list"), 256, 220, new OverlayFlag[0]);
        this.setBackground(-285212672);
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.configRowList = ConfigRowList.getInstance();
        this.list = null;
        this.generateWidgets();
    }

    private int getListEndY() {
        return (int)this.y + this.getOverlayHeight() + 15 - 1;
    }

    private int getListWidth() {
        return (int)this.x + 256 - 9;
    }

    private void refreshRowList() {
        double scrolled = this.list.m_93517_();
        this.list.m_6702_().clear();
        this.generateWidgets();
        this.list.m_93410_(scrolled);
    }

    @CheckForNull
    public ConfigRowList.Row getSelected() {
        return this.selected;
    }

    @Override
    public void generateWidgets() {
        ConfigScreen screen = (ConfigScreen)Minecraft.m_91087_().f_91080_;
        if (screen == null || this.list != null && !this.list.m_6702_().isEmpty()) {
            return;
        }
        if (this.list != null) {
            this.list.resetLastSelection();
        }
        int width = this.getListWidth();
        int height = this.getOverlayHeight();
        int startY = this.getOverlayStartY();
        int endY = this.getListEndY();
        TextRowList.color = 0xFFFFFF;
        Objects.requireNonNull(screen.getFont());
        this.list = new TextRowList(screen, width, height, startY, endY, 9 + 2);
        this.list.m_93507_(this.getOverlayStartX());
        for (ConfigRowList.Row row : this.configRowList.m_6702_()) {
            int indent = 0;
            if (row.getIndent() == 28) {
                indent = 9;
            } else if (row.getIndent() == 48) {
                indent = 18;
            } else if (row.getIndent() == 68) {
                indent = 27;
            }
            Button.OnPress jump = button -> {
                this.configRowList.setScrollOn(row);
                this.configRowList.setSelection = true;
                this.selected = row;
                this.refreshRowList();
            };
            AbstractWidget abstractWidget = row.controller;
            if (abstractWidget instanceof ContainerButton) {
                ContainerButton container = (ContainerButton)abstractWidget;
                this.list.addRow(new TextRowList.EntryRow(this.list, row, container, container.getTitle(), indent, jump).add());
            }
            if (row.tweak == null) continue;
            this.list.addRow(new TextRowList.EntryRow(this.list, row, null, (Component)Component.m_237115_((String)row.tweak.getLangKey()), indent, jump).add());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInvalidWidget(TextRow row, AbstractWidget widget) {
        if (!(widget instanceof TextButton)) return false;
        TextButton text = (TextButton)widget;
        if (!text.title.getString().equals(TWEAK_STAR)) return false;
        return true;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (KeyUtil.isEsc(keyCode) && this.list.unsetFocus()) {
            return true;
        }
        if (KeyUtil.isTab(keyCode) && this.list.setFocus(this::isInvalidWidget)) {
            return true;
        }
        if (this.list.getFocusKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return this.list.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public boolean onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isDragging = super.onDrag(mouseX, mouseY, button, dragX, dragY);
        if (isDragging) {
            this.refreshRowList();
        } else {
            this.list.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return isDragging;
    }

    @Override
    public boolean onClick(double mouseX, double mouseY, int button) {
        int startY;
        int startX = (int)this.x + 16 + this.getDrawWidth() - 10;
        if (MathUtil.isWithinBox(mouseX, mouseY, startX, startY = (int)this.y + 4, 9.0, 9.0)) {
            this.hint = !this.hint;
        }
        this.list.m_6375_(mouseX, mouseY, button);
        return super.onClick(mouseX, mouseY, button);
    }

    @Override
    public void onResize() {
        ContainerButton.collapseAll();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.getRenderer().generateRowsFromAllGroups();
            this.init();
        }
    }

    @Override
    public void onClose() {
        this.list.m_6702_().clear();
        this.configRowList = null;
        super.onClose();
    }

    @Override
    public void onMainRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.list != null) {
            this.list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void onPostRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderHintButton(poseStack, mouseX, mouseY);
        this.renderTooltipHint(poseStack, mouseX, mouseY);
    }

    private static class TextRowList
    extends AbstractRowList<TextRow> {
        public static int color = 0xFFFFFF;
        public final ConfigScreen screen;

        public TextRowList(ConfigScreen screen, int width, int height, int startY, int endY, int rowHeight) {
            super(width, height, startY, endY, rowHeight);
            this.screen = screen;
            this.setAsSemiTransparent();
        }

        public void addRow(TextRow row) {
            this.m_7085_((AbstractSelectionList.Entry)row);
        }

        public record EntryRow(TextRowList list, ConfigRowList.Row row, @Nullable ContainerButton container, Component title, int indent, Button.OnPress onClick) {
            public TextRow add() {
                ArrayList<TextButton> widgets = new ArrayList<TextButton>();
                MutableComponent control = this.container == null ? Component.m_237113_((String)CategoryListOverlay.TWEAK_STAR) : Component.m_237113_((String)(this.container.isExpanded() ? "-" : "+"));
                widgets.add(new TextButton(this.list().screen, this.row, color, this.list.f_93393_ + 2 + this.indent, 0, (Component)control, this::toggle));
                widgets.add(new TextButton(this.list().screen, this.row, color, this.list.f_93393_ + 11 + this.indent, 0, this.title, this.onClick));
                color = color == 0xFFFFFF ? 0xB2B2B2 : 0xFFFFFF;
                return new TextRow((List<AbstractWidget>)ImmutableList.copyOf(widgets));
            }

            private void toggle(Button button) {
                Overlay overlay;
                if (this.container != null && (overlay = Overlay.getVisible()) instanceof CategoryListOverlay) {
                    CategoryListOverlay overlay2 = (CategoryListOverlay)overlay;
                    double scrolled = overlay2.list.m_93517_();
                    int position = 0;
                    this.container.silentPress();
                    button.m_93666_((Component)Component.m_237113_((String)(this.container.isExpanded() ? "-" : "+")));
                    for (int i = 0; i < overlay2.list.m_6702_().size() - 1; ++i) {
                        for (AbstractWidget widget : ((TextRow)((Object)overlay2.list.m_6702_().get((int)i))).children) {
                            if (!widget.m_93696_()) continue;
                            position = i;
                            break;
                        }
                        if (position != 0) break;
                    }
                    overlay2.list.m_6702_().clear();
                    overlay2.generateWidgets();
                    if (scrolled > 0.0) {
                        overlay2.list.m_93410_(scrolled);
                    }
                    if (position < overlay2.list.m_6702_().size()) {
                        AbstractWidget widget = ((TextRow)((Object)overlay2.list.m_6702_().get((int)position))).children.get(0);
                        ((AbstractWidgetAccessor)widget).NT$setFocus(true);
                        overlay2.list.setLastSelection(widget);
                    }
                }
            }
        }
    }

    private static class TextRow
    extends ContainerObjectSelectionList.Entry<TextRow> {
        public final List<AbstractWidget> children;

        public TextRow(List<AbstractWidget> children) {
            this.children = children;
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (this.m_5953_(mouseX, mouseY)) {
                RenderSystem.m_69456_((int)515);
                RenderSystem.m_69465_();
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.m_69472_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                RenderUtil.fill(buffer, matrix, left - 6, left + 256 - 13, top - 1, top + height + 2, 0x32FFFFFF);
                tesselator.m_85914_();
            }
            for (AbstractWidget widget : this.children) {
                widget.f_93621_ = top;
                widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            }
            RenderSystem.m_69461_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    private static class TextButton
    extends Button {
        private final ConfigRowList.Row row;
        private final ConfigScreen screen;
        private final Component title;
        private final int color;

        private static int getTextWidth(Component title) {
            return Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title);
        }

        private static int getTextHeight() {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return 9;
        }

        public TextButton(ConfigScreen screen, ConfigRowList.Row row, int color, int startX, int startY, Component title, Button.OnPress onClick) {
            super(startX, startY, TextButton.getTextWidth(title), TextButton.getTextHeight(), title, onClick);
            this.screen = screen;
            this.title = title;
            this.color = color;
            this.row = row;
            if (this.title.getString().equals(CategoryListOverlay.TWEAK_STAR)) {
                this.f_93623_ = false;
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (Overlay.isOverTitle(mouseX, mouseY)) {
                return;
            }
            super.m_5716_(mouseX, mouseY);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            int highlight;
            CategoryListOverlay overlay = (CategoryListOverlay)Overlay.getVisible();
            if (ClassUtil.isNotInstanceOf(overlay, CategoryListOverlay.class)) {
                return;
            }
            boolean isTweak = this.title.getString().equals(CategoryListOverlay.TWEAK_STAR);
            boolean isControl = this.title.getString().length() == 1;
            boolean isSelected = ((Object)((Object)this.row)).equals((Object)overlay.getSelected()) && isControl;
            boolean isTabbed = this.m_93696_() && !isTweak;
            boolean isHover = MathUtil.isWithinBox(mouseX, mouseY, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_) && !isTweak;
            int n = highlight = isHover ? 16766976 : this.color;
            if (isTabbed) {
                highlight = 3850495;
            }
            if (isSelected && overlay.list.getLastSelection() == null) {
                overlay.list.setLastSelection((AbstractWidget)this);
            }
            TextButton.m_93243_((PoseStack)poseStack, (Font)this.screen.getFont(), (Component)(isSelected ? this.title.m_6881_().m_130940_(ChatFormatting.GOLD) : this.title), (int)this.f_93620_, (int)this.f_93621_, (int)highlight);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

