/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayFlag;
import mod.adrenix.nostalgic.client.config.gui.widget.slider.ColorSlider;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ColorPickerOverlay
extends Overlay {
    public static final int OVERLAY_WIDTH = 176;
    public static final int OVERLAY_HEIGHT = 125;
    private static final int U_CLOSE_OFF = 176;
    private static final int V_CLOSE_OFF = 9;
    private static final int U_CLOSE_ON = 176;
    private static final int V_CLOSE_ON = 0;
    private static final int U_HINT_OFF = 176;
    private static final int V_HINT_OFF = 27;
    private static final int U_HINT_ON = 176;
    private static final int V_HINT_ON = 18;
    private static final int HINT_SQUARE = 9;
    private final TweakClientCache<String> tweak;
    private boolean hint = false;
    private int r;
    private int g;
    private int b;
    private int a;

    public ColorPickerOverlay(TweakClientCache<String> hex) {
        super(176, 125, new OverlayFlag[0]);
        this.tweak = hex;
        this.init();
    }

    @Override
    public void init() {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        this.isJustOpened = true;
        this.hint = false;
        this.x = (double)screen.f_96543_ / 2.0 - (double)this.width / 2.0;
        this.y = (double)screen.f_96544_ / 2.0 - (double)this.height / 2.0;
        int[] rgba = ColorUtil.toHexRGBA(this.tweak.getValue());
        this.r = rgba[0];
        this.g = rgba[1];
        this.b = rgba[2];
        this.a = rgba[3];
        this.generateWidgets();
    }

    private void setRed(int red) {
        this.r = red;
    }

    private void setGreen(int green) {
        this.g = green;
    }

    private void setBlue(int blue) {
        this.b = blue;
    }

    private void setAlpha(int alpha) {
        this.a = alpha;
    }

    private int getRed() {
        return this.r;
    }

    private int getGreen() {
        return this.g;
    }

    private int getBlue() {
        return this.b;
    }

    private int getAlpha() {
        return this.a;
    }

    private int getHintX() {
        return (int)this.x + 150;
    }

    private int getHintY() {
        return (int)this.y + 4;
    }

    @Override
    public void generateWidgets() {
        int x = (int)this.x + 38;
        int y = (int)this.y + 20;
        int w = 125;
        int h = 20;
        int dy = 24;
        this.widgets.clear();
        this.widgets.add(new ColorSlider(this::setRed, this::getRed, ColorSlider.Type.R, x, y, w, h));
        this.widgets.add(new ColorSlider(this::setGreen, this::getGreen, ColorSlider.Type.G, x, y + dy, w, h));
        this.widgets.add(new ColorSlider(this::setBlue, this::getBlue, ColorSlider.Type.B, x, y + dy * 2, w, h));
        this.widgets.add(new ColorSlider(this::setAlpha, this::getAlpha, ColorSlider.Type.A, x, y + dy * 3, w, h));
    }

    @Override
    public boolean onClick(double mouseX, double mouseY, int button) {
        if (MathUtil.isWithinBox(mouseX, mouseY, this.getHintX(), this.getHintY(), 9.0, 9.0)) {
            this.hint = !this.hint;
        }
        return super.onClick(mouseX, mouseY, button);
    }

    private static void drawBorder(BufferBuilder buffer, Matrix4f matrix, int startX, int startY, int color) {
        RenderUtil.fill(buffer, matrix, startX, startX + 1, startY, startY + 19, color);
        RenderUtil.fill(buffer, matrix, startX, startX + 125, startY, startY + 1, color);
        RenderUtil.fill(buffer, matrix, startX + 125, startX + 126, startY, startY + 20, color);
        RenderUtil.fill(buffer, matrix, startX, startX + 125, startY + 19, startY + 20, color);
    }

    @Override
    public void onRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        List<Component> tooltip;
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null || !this.isOpen()) {
            return;
        }
        this.tweak.setValue(ColorUtil.toHexString(new int[]{this.r, this.g, this.b, this.a}));
        int startX = (int)this.x;
        int startY = (int)this.y;
        int closeX = startX + 160;
        int closeY = startY + 4;
        int hintX = this.getHintX();
        int hintY = this.getHintY();
        boolean isOverHint = MathUtil.isWithinBox(mouseX, mouseY, hintX, hintY, 9.0, 9.0);
        this.isOverClose = MathUtil.isWithinBox(mouseX, mouseY, closeX, closeY, 9.0, 9.0);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.COLOR_PICKER);
        this.m_93228_(poseStack, startX, startY, 0, 0, this.width, this.height);
        this.m_93228_(poseStack, closeX, closeY, this.isOverClose ? 176 : 176, this.isOverClose ? 0 : 9, 9, 9);
        this.m_93228_(poseStack, hintX, hintY, isOverHint ? 176 : 176, isOverHint ? 18 : 27, 9, 9);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        int leftX = startX + 14;
        int topY = startY + 21;
        int[] rgba = ColorUtil.toHexRGBA(this.tweak.getValue());
        int r = ColorUtil.toHexInt("#" + (rgba[0] < 16 ? "0" : "") + Integer.toHexString(rgba[0]) + "0000FF");
        int g = ColorUtil.toHexInt("#00" + (rgba[1] < 16 ? "0" : "") + Integer.toHexString(rgba[1]) + "00FF");
        int b = ColorUtil.toHexInt("#0000" + (rgba[2] < 16 ? "0" : "") + Integer.toHexString(rgba[2]) + "FF");
        int a = ColorUtil.toHexInt(this.tweak.getValue());
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.fill(buffer, matrix, leftX, leftX + 18, topY, topY + 18, r);
        RenderUtil.fill(buffer, matrix, leftX, leftX + 18, topY + 24, topY + 24 + 18, g);
        RenderUtil.fill(buffer, matrix, leftX, leftX + 18, topY + 48, topY + 48 + 18, b);
        RenderUtil.fill(buffer, matrix, leftX, leftX + 18, topY + 72, topY + 72 + 18, a);
        tesselator.m_85914_();
        PoseStack sliders = new PoseStack();
        sliders.m_85850_().m_85861_().m_27648_(new Vector3f(0.0f, 0.0f, 1.0f));
        for (AbstractWidget widget : this.widgets) {
            widget.m_6305_(sliders, mouseX, mouseY, partialTick);
        }
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        leftX = startX + 38;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        ColorPickerOverlay.drawBorder(buffer, matrix, leftX, --topY, r);
        ColorPickerOverlay.drawBorder(buffer, matrix, leftX, topY + 24, g);
        ColorPickerOverlay.drawBorder(buffer, matrix, leftX, topY + 48, b);
        ColorPickerOverlay.drawBorder(buffer, matrix, leftX, topY + 72, a);
        tesselator.m_85914_();
        int color = this.isMouseOverTitle(mouseX, mouseY) && !this.isOverClose && !isOverHint ? 16774747 : 0xFFFFFF;
        ColorPickerOverlay.drawString((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.color"), startX + 19, startY + 5, color);
        boolean isOverIcon = MathUtil.isWithinBox(mouseX, mouseY, this.x + 7.0, this.y + 3.0, 8.0, 9.0);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 500.0);
        if (isOverIcon) {
            tooltip = TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.drag.@Tooltip"), 36);
            screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
        }
        if (isOverHint && this.hint) {
            tooltip = TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.color.hint"), 36);
            screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
        }
        poseStack.m_85849_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

