/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayFlag;
import mod.adrenix.nostalgic.client.config.gui.overlay.template.AbstractWidgetProvider;
import mod.adrenix.nostalgic.client.config.gui.overlay.template.ListScreenOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ItemButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ManageItemOverlay
extends ListScreenOverlay<WidgetProvider> {
    public static final int OVERLAY_WIDTH = 155;
    public static final int OVERLAY_HEIGHT = 118;
    private final ItemStack itemStack;

    public ManageItemOverlay(ItemStack itemStack) {
        super((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.item"), 155, 118, new OverlayFlag[0]);
        this.itemStack = itemStack;
        this.setBackground(-1610612736);
        this.setHeightPadding(38);
        this.init();
    }

    @Override
    protected void createWidgetProvider() {
        this.widgetProvider = new WidgetProvider();
    }

    public int getCenteredX() {
        return (int)(this.x + (double)(this.width / 2)) - 11;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public void onMainRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean isSaved = this.listScreen.isItemSaved(this.itemStack);
        ((WidgetProvider)this.widgetProvider).itemButton.f_93620_ = this.getCenteredX();
        ((WidgetProvider)this.widgetProvider).editButton.f_93623_ = isSaved;
        ((WidgetProvider)this.widgetProvider).removeButton.f_93623_ = isSaved;
        boolean bl = ((WidgetProvider)this.widgetProvider).addButton.f_93623_ = !this.listScreen.isItemSaved(this.itemStack);
        if (this.listScreen.isItemDeleted(this.itemStack)) {
            ((WidgetProvider)this.widgetProvider).removeButton.f_93623_ = false;
        }
        super.onMainRender(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void onPostRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (((WidgetProvider)this.widgetProvider).itemButton.m_5953_(mouseX, mouseY)) {
            ((WidgetProvider)this.widgetProvider).itemButton.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    protected class WidgetProvider
    extends AbstractWidgetProvider {
        public ItemButton itemButton;
        public Button addButton;
        public Button editButton;
        public Button removeButton;

        protected WidgetProvider() {
        }

        @Override
        public void generate() {
            this.itemButton = this.createItemButton();
            this.addButton = this.createAddButton();
            this.editButton = this.createEditButton();
            this.removeButton = this.createRemoveButton();
            ManageItemOverlay.this.widgets.add(this.itemButton);
            ManageItemOverlay.this.widgets.add(this.addButton);
            ManageItemOverlay.this.widgets.add(this.editButton);
            ManageItemOverlay.this.widgets.add(this.removeButton);
            this.children = Set.of(this.itemButton, this.addButton, this.editButton, this.removeButton);
        }

        public int getButtonWidth() {
            return ManageItemOverlay.this.getDrawWidth() + 12;
        }

        public ItemButton createItemButton() {
            ListScreen screen = ManageItemOverlay.this.listScreen;
            ItemStack itemStack = ManageItemOverlay.this.itemStack;
            int startX = ManageItemOverlay.this.getCenteredX();
            return new ItemButton(screen, itemStack, startX).forOverlay();
        }

        public Button createAddButton() {
            return new Button(ManageItemOverlay.this.getOverlayStartX(), ManageItemOverlay.this.getOverlayStartY() + 22, this.getButtonWidth(), 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.item.add"), button -> {
                Overlay.close();
                ManageItemOverlay.this.listScreen.addItem(ManageItemOverlay.this.itemStack);
                ManageItemOverlay.this.listScreen.highlightItem(ManageItemOverlay.this.itemStack);
                ManageItemOverlay.this.listScreen.getSearchBox().m_94144_("");
                ManageItemOverlay.this.listScreen.refreshSearchResults();
            });
        }

        public Button createEditButton() {
            return new Button(ManageItemOverlay.this.getOverlayStartX(), ManageItemOverlay.this.getOverlayStartY() + 44, this.getButtonWidth(), 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.item.edit"), button -> {
                Overlay.close();
                ManageItemOverlay.this.listScreen.jumpToEntry(ManageItemOverlay.this.itemStack);
            });
        }

        public Button createRemoveButton() {
            return new Button(ManageItemOverlay.this.getOverlayStartX(), ManageItemOverlay.this.getOverlayStartY() + 66, this.getButtonWidth(), 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.item.remove"), button -> {
                Overlay.close();
                ManageItemOverlay.this.listScreen.deleteItem(ManageItemOverlay.this.itemStack);
                ManageItemOverlay.this.listScreen.jumpToEntry(ManageItemOverlay.this.itemStack);
            });
        }
    }
}

