/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayEvents;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayFlag;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class Overlay
extends GuiComponent
implements OverlayEvents {
    @Nullable
    private static Overlay visible = null;
    protected final ArrayList<AbstractWidget> widgets = new ArrayList();
    protected final Screen screen;
    protected boolean isOverlayOpen;
    protected boolean isJustOpened;
    protected boolean isOverClose;
    protected double x;
    protected double y;
    protected int width;
    protected int height;
    protected boolean locked;
    protected boolean hint;
    public static final float Z_OFFSET = 400.0f;
    protected static final int LEFT_CLICK = 0;
    protected static final int CLOSE_WIDTH = 9;
    protected static final int CLOSE_HEIGHT = 9;

    public static Overlay getVisible() {
        return visible;
    }

    public static void close() {
        if (visible != null) {
            visible.onClose();
        }
    }

    public static boolean isOpened() {
        return visible != null;
    }

    public static boolean isOverTitle(double mouseX, double mouseY) {
        if (visible != null) {
            return visible.isMouseOverTitle(mouseX, mouseY);
        }
        return false;
    }

    public static void resize() {
        if (visible != null) {
            visible.onResize();
        }
    }

    public static void onRelease(double mouseX, double mouseY, int button) {
        if (visible != null) {
            visible.onMouseReleased(mouseX, mouseY, button);
        }
    }

    public static boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (visible != null && !Overlay.visible.locked && keyCode == 256) {
            visible.onClose();
            return true;
        }
        return visible != null && visible.onKeyPressed(keyCode, scanCode, modifiers);
    }

    public static boolean mouseClicked(double mouseX, double mouseY, int button) {
        return visible != null && visible.onClick(mouseX, mouseY, button);
    }

    public static boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return visible != null && visible.onDrag(mouseX, mouseY, button, dragX, dragY);
    }

    public static boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return visible != null && visible.onMouseScrolled(mouseX, mouseY, delta);
    }

    public static void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (visible != null) {
            visible.onRender(poseStack, mouseX, mouseY, partialTick);
        }
    }

    protected static void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    protected static void drawString(Component component, int x, int y, int color) {
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_85850_().m_85861_().m_27648_(new Vector3f(0.0f, 0.0f, 401.0f));
        Overlay.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)component, (int)x, (int)y, (int)color);
        poseStack.m_85849_();
    }

    protected static void drawString(Component component, int x, int y) {
        Overlay.drawString(component, x, y, 0xFFFFFF);
    }

    protected Overlay(int width, int height, OverlayFlag ... flags) {
        this.screen = Minecraft.m_91087_().f_91080_;
        this.isOverlayOpen = false;
        this.isJustOpened = false;
        this.isOverClose = false;
        this.locked = false;
        this.hint = false;
        this.width = width;
        this.height = height;
        if (visible != null && visible.isOpen()) {
            visible.onClose();
        }
        visible = this;
        Overlay.visible.isOverlayOpen = true;
        Overlay.visible.isJustOpened = true;
        for (OverlayFlag flag : flags) {
            switch (flag) {
                case LOCKED: {
                    this.locked = true;
                }
            }
        }
    }

    protected boolean isMouseOverTitle(double mouseX, double mouseY) {
        return MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, 15.0);
    }

    @Override
    public void generateWidgets() {
    }

    @Override
    public void onResize() {
        this.init();
    }

    @Override
    public void onClose() {
        this.widgets.clear();
        this.isOverlayOpen = false;
        visible = null;
    }

    @Override
    public boolean isOpen() {
        return this.isOverlayOpen;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.isOverlayOpen) {
            return false;
        }
        this.widgets.forEach(widget -> {
            if (MathUtil.isWithinBox(mouseX, mouseY, widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_())) {
                widget.m_6050_(mouseX, mouseY, delta);
            }
        });
        return true;
    }

    @Override
    public boolean onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isOverlayOpen) {
            return false;
        }
        this.widgets.forEach(widget -> {
            if (MathUtil.isWithinBox(mouseX, mouseY, widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_())) {
                widget.m_7979_(mouseX, mouseY, button, dragX, dragY);
            }
        });
        if (button == 0 && this.isMouseOverTitle(mouseX, mouseY)) {
            this.x += dragX;
            this.y += dragY;
            this.generateWidgets();
            return true;
        }
        return false;
    }

    @Override
    public boolean onClick(double mouseX, double mouseY, int button) {
        boolean isClosing;
        if (!this.isOverlayOpen) {
            return false;
        }
        for (AbstractWidget widget : this.widgets) {
            widget.m_6375_(mouseX, mouseY, button);
            if (this.widgets.size() != 0) continue;
            break;
        }
        if (button != 0) {
            return false;
        }
        boolean isOutOfBounds = !MathUtil.isWithinBox(mouseX, mouseY, this.x, this.y, this.width, this.height);
        boolean bl = isClosing = isOutOfBounds || this.isOverClose;
        if (isClosing && !this.locked) {
            this.onClose();
        }
        if (!(!this.isMouseOverTitle(mouseX, mouseY) || this.locked && isClosing)) {
            Overlay.playClickSound();
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isOverlayOpen) {
            return false;
        }
        this.widgets.forEach(widget -> widget.m_7933_(keyCode, scanCode, modifiers));
        return false;
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isJustOpened) {
            this.isJustOpened = false;
            return;
        }
        if (!this.isOverlayOpen) {
            return;
        }
        double lastX = this.x;
        double lastY = this.y;
        if (this.x + (double)this.width <= 0.0) {
            this.x = 0.0;
        }
        if (this.x > (double)Minecraft.m_91087_().m_91268_().m_85445_() - 5.0) {
            this.x = (double)Minecraft.m_91087_().m_91268_().m_85445_() - 25.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.y > (double)Minecraft.m_91087_().m_91268_().m_85446_()) {
            this.y = (double)Minecraft.m_91087_().m_91268_().m_85446_() - 15.0;
        }
        if (lastY != this.y || lastX != this.x) {
            this.generateWidgets();
        }
        this.widgets.forEach(widget -> {
            if (MathUtil.isWithinBox(mouseX, mouseY, widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_())) {
                widget.m_6348_(mouseX, mouseY, button);
            }
        });
    }
}

