/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.overlay.template;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.OverlayFlag;
import mod.adrenix.nostalgic.client.config.gui.overlay.template.GenericRendering;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class GenericOverlay
extends Overlay
implements GenericRendering {
    public static final int U_TOP_LEFT_CORNER = 0;
    public static final int V_TOP_LEFT_CORNER = 0;
    public static final int W_TOP_LEFT_CORNER = 16;
    public static final int H_TOP_LEFT_CORNER = 15;
    public static final int U_TOP_RIGHT_CORNER = 19;
    public static final int V_TOP_RIGHT_CORNER = 0;
    public static final int W_TOP_RIGHT_CORNER = 16;
    public static final int H_TOP_RIGHT_CORNER = 15;
    public static final int U_TOP_BAR = 17;
    public static final int V_TOP_BAR = 0;
    public static final int H_TOP_BAR = 15;
    public static final int U_LEFT_BAR = 0;
    public static final int V_LEFT_BAR = 16;
    public static final int W_LEFT_BAR = 8;
    public static final int U_RIGHT_BAR = 27;
    public static final int V_RIGHT_BAR = 16;
    public static final int W_RIGHT_BAR = 8;
    public static final int U_BOTTOM_LEFT_CORNER = 0;
    public static final int V_BOTTOM_LEFT_CORNER = 18;
    public static final int W_BOTTOM_LEFT_CORNER = 16;
    public static final int H_BOTTOM_LEFT_CORNER = 8;
    public static final int U_BOTTOM_BAR = 17;
    public static final int V_BOTTOM_BAR = 18;
    public static final int H_BOTTOM_BAR = 8;
    public static final int U_BOTTOM_RIGHT_CORNER = 19;
    public static final int V_BOTTOM_RIGHT_CORNER = 18;
    public static final int W_BOTTOM_RIGHT_CORNER = 16;
    public static final int H_BOTTOM_RIGHT_CORNER = 8;
    public static final int U_CLOSE_DISABLED = 35;
    public static final int V_CLOSE_DISABLED = 18;
    public static final int U_CLOSE_OFF = 35;
    public static final int V_CLOSE_OFF = 9;
    public static final int U_CLOSE_ON = 35;
    public static final int V_CLOSE_ON = 0;
    public static final int U_HINT_OFF = 44;
    public static final int V_HINT_OFF = 9;
    public static final int U_HINT_ON = 44;
    public static final int V_HINT_ON = 0;
    public static final int HINT_SQUARE = 9;
    public final Component title;
    public int background = -973078528;

    public int getOverlayStartX() {
        return (int)this.x + 10;
    }

    public int getOverlayStartY() {
        return (int)this.y + 15;
    }

    public int getOverlayHeight() {
        return this.height - 15 - 15;
    }

    public int getDrawWidth() {
        return this.width - 16 - 16;
    }

    public GenericOverlay(Component title, int width, int height, OverlayFlag ... flags) {
        super(width, height, flags);
        this.title = title;
    }

    public void setBackground(int color) {
        this.background = color;
    }

    public void renderTooltipIcon(PoseStack poseStack, int mouseX, int mouseY) {
        boolean isOverIcon = MathUtil.isWithinBox(mouseX, mouseY, this.x + 7.0, this.y + 3.0, 8.0, 9.0);
        if (isOverIcon) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 450.0);
            List<Component> tooltip = TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.drag.@Tooltip"), 36);
            this.screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }

    public void renderTooltipHint(PoseStack poseStack, int mouseX, int mouseY) {
        int startY;
        int startX = (int)this.x + 16 + this.getDrawWidth() - 10;
        boolean isOverHint = MathUtil.isWithinBox(mouseX, mouseY, startX, startY = (int)this.y + 4, 9.0, 9.0);
        if (isOverHint && this.hint) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 450.0);
            List<Component> tooltip = TextUtil.Wrap.tooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.overlay.list.hint"), 36);
            this.screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }

    @Override
    public void init() {
        this.x = (double)this.screen.f_96543_ / 2.0 - (double)this.width / 2.0;
        this.y = (double)this.screen.f_96544_ / 2.0 - (double)this.height / 2.0;
    }

    @Override
    public void onRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.isOpen()) {
            return;
        }
        this.onPreRender(poseStack, mouseX, mouseY, partialTick);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 400.0);
        this.renderBackground(poseStack);
        this.onMainRender(poseStack, mouseX, mouseY, partialTick);
        this.renderBorder(poseStack);
        this.renderCloseButton(poseStack, mouseX, mouseY);
        poseStack.m_85849_();
        int color = this.isMouseOverTitle(mouseX, mouseY) && !this.isOverClose ? 16774747 : 0xFFFFFF;
        GenericOverlay.drawString(this.title, (int)this.x + 19, (int)this.y + 5, color);
        this.renderTooltipIcon(poseStack, mouseX, mouseY);
        this.onPostRender(poseStack, mouseX, mouseY, partialTick);
    }

    public void renderCloseButton(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_69493_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.CATEGORY_LIST);
        int closeX = (int)this.x + 16 + this.getDrawWidth();
        int closeY = (int)this.y + 4;
        this.isOverClose = MathUtil.isWithinBox(mouseX, mouseY, closeX, closeY, 9.0, 9.0);
        this.m_93228_(poseStack, closeX, closeY, this.locked ? 35 : (this.isOverClose ? 35 : 35), this.locked ? 18 : (this.isOverClose ? 0 : 9), 9, 9);
        RenderSystem.m_69472_();
    }

    public void renderHintButton(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_69493_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.CATEGORY_LIST);
        int hintX = (int)this.x + 16 + this.getDrawWidth() - 10;
        int hintY = (int)this.y + 4;
        boolean isOverHint = MathUtil.isWithinBox(mouseX, mouseY, hintX, hintY, 9.0, 9.0);
        this.m_93228_(poseStack, hintX, hintY, isOverHint ? 44 : 44, isOverHint ? 0 : 9, 9, 9);
        RenderSystem.m_69472_();
    }

    public void renderBorder(PoseStack poseStack) {
        int i;
        RenderSystem.m_69493_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.CATEGORY_LIST);
        int startX = (int)this.x;
        int startY = (int)this.y;
        int drawWidth = this.getDrawWidth();
        int drawHeight = this.getOverlayHeight();
        this.m_93228_(poseStack, startX, startY, 0, 0, 16, 15);
        for (i = 0; i < drawWidth; ++i) {
            this.m_93228_(poseStack, i + startX + 16, startY, 17, 0, 1, 15);
        }
        this.m_93228_(poseStack, startX + 16 + drawWidth, startY, 19, 0, 16, 15);
        for (i = 0; i < drawHeight; ++i) {
            this.m_93228_(poseStack, startX, i + startY + 15, 0, 16, 8, 1);
            this.m_93228_(poseStack, startX + 16 + drawWidth + 8, i + startY + 15, 27, 16, 8, 1);
        }
        this.m_93228_(poseStack, startX, startY + 15 + drawHeight, 0, 18, 16, 8);
        for (i = 0; i < drawWidth; ++i) {
            this.m_93228_(poseStack, i + startX + 16, startY + 15 + drawHeight, 17, 18, 1, 8);
        }
        this.m_93228_(poseStack, startX + 16 + drawWidth, startY + 15 + drawHeight, 19, 18, 16, 8);
        RenderSystem.m_69472_();
    }

    public void renderBackground(PoseStack poseStack) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        float leftX = (float)this.x + 6.0f;
        float rightX = (float)this.x + (float)this.width - 4.0f;
        float topY = (float)this.y + 14.0f;
        float bottomY = (float)this.y + (float)this.height - 10.0f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.fill(buffer, matrix, leftX, rightX, topY, bottomY, this.background);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }
}

