/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen;

import com.google.gson.Gson;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.ColorUtil;
import mod.adrenix.nostalgic.util.common.ComponentUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import mod.adrenix.nostalgic.util.common.TimeWatcher;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class DonatorBanner {
    @CheckForNull
    private static JsonSupporters cache = null;
    private static boolean downloaded = false;
    private static boolean opened = ClientConfigCache.getGui().displayDonatorBanner;
    private static int height = 0;
    private static final String NAME_SPACER = "    ";
    private static final TimeWatcher CACHE_TIMER = new TimeWatcher(10000L, 3);
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    private static final MutableComponent THANKS_MESSAGE = Component.m_237115_((String)"gui.nostalgic_tweaks.settings.supporters");
    private static final MutableComponent CONNECTING_MESSAGE = Component.m_237115_((String)"gui.nostalgic_tweaks.settings.connecting");
    private static final MutableComponent DISCONNECT_MESSAGE = Component.m_237115_((String)"gui.nostalgic_tweaks.settings.disconnected");
    private static final ArrayList<MutableComponent> SUPPORTERS = new ArrayList();
    private final Font font;
    private float messageX;
    private int messageWidth;
    private boolean isRunning;

    public static int getHeight() {
        return height;
    }

    public static boolean isOpen() {
        return opened;
    }

    public static void toggle() {
        opened = !opened;
    }

    private static int getWidth() {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return Minecraft.m_91087_().f_91080_.f_96543_;
        }
        return 0;
    }

    public DonatorBanner() {
        this.font = Minecraft.m_91087_().f_91062_;
        this.messageX = 0.0f;
        this.messageWidth = 0;
        this.isRunning = false;
        if (cache == null && opened) {
            if (CACHE_TIMER.isMaxReached()) {
                CACHE_TIMER.reset();
            }
            this.connect();
        }
        this.build();
    }

    private void connect() {
        if (!CACHE_TIMER.isReady()) {
            return;
        }
        NostalgicTweaks.LOGGER.info("Connecting to %s", "https://raw.githubusercontent.com/Adrenix/Nostalgic-Tweaks/data/supporters.json");
        Thread thread = new Thread("GitHub Supporter Connector #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    URL url = new URL("https://raw.githubusercontent.com/Adrenix/Nostalgic-Tweaks/data/supporters.json");
                    InputStreamReader reader = new InputStreamReader(url.openStream());
                    cache = (JsonSupporters)new Gson().fromJson((Reader)reader, JsonSupporters.class);
                    NostalgicTweaks.LOGGER.info("Successfully downloaded supporter data from GitHub");
                }
                catch (Exception exception) {
                    NostalgicTweaks.LOGGER.error("Could not get supporter data from GitHub\n%s", exception);
                }
            }
        };
        thread.start();
    }

    private void build() {
        if (cache == null) {
            return;
        }
        SUPPORTERS.clear();
        Map<String, String> fromJson = DonatorBanner.cache.supporters;
        for (Map.Entry<String, String> entry : fromJson.entrySet()) {
            SUPPORTERS.add(ComponentUtil.color(entry.getKey(), ColorUtil.toHexInt(entry.getValue())));
        }
        Collections.shuffle(SUPPORTERS);
        this.messageWidth = 0;
        for (MutableComponent mutableComponent : SUPPORTERS) {
            this.messageWidth += this.font.m_92852_((FormattedText)mutableComponent) + this.font.m_92895_(NAME_SPACER);
        }
    }

    private float getCenterX(MutableComponent message) {
        return (float)DonatorBanner.getWidth() / 2.0f - (float)this.font.m_92852_((FormattedText)message) / 2.0f;
    }

    public void render(PoseStack poseStack, float partialTick) {
        float offset;
        float headerY = 3.0f;
        Objects.requireNonNull(this.font);
        float messageY = headerY + 9.0f + 4.0f;
        Objects.requireNonNull(this.font);
        int endY = 9 * 2 + 10;
        if (!opened) {
            height = 0;
            return;
        }
        height = endY + 2;
        RenderUtil.fill(poseStack, 0.0f, (float)DonatorBanner.getWidth(), 0.0f, (float)endY, 0x7F000000);
        this.font.m_92763_(poseStack, (Component)THANKS_MESSAGE, this.getCenterX(THANKS_MESSAGE), headerY, 0xFFFF00);
        if (cache == null && opened) {
            MutableComponent message = CACHE_TIMER.isMaxReached() ? DISCONNECT_MESSAGE : CONNECTING_MESSAGE;
            ChatFormatting color = CACHE_TIMER.isMaxReached() ? ChatFormatting.RED : ChatFormatting.GOLD;
            float centerX = this.getCenterX(message);
            this.font.m_92763_(poseStack, (Component)message.m_130940_(color), centerX, messageY, 0xFFFFFF);
            this.connect();
            return;
        }
        if (cache != null && !downloaded) {
            downloaded = true;
            this.build();
        }
        float startX = (float)DonatorBanner.getWidth() + 15.0f;
        float f = offset = MathUtil.isOdd(DonatorBanner.getWidth()) ? 0.0f : 0.1f;
        if (!this.isRunning) {
            this.messageX = startX;
            this.isRunning = true;
        }
        if (this.messageX <= (float)(-this.messageWidth)) {
            this.isRunning = false;
            this.build();
        }
        this.messageX -= 1.5333334f * partialTick;
        float currentX = this.messageX;
        for (MutableComponent supporter : SUPPORTERS) {
            if (currentX > startX) break;
            int width = this.font.m_92852_((FormattedText)supporter) + this.font.m_92895_(NAME_SPACER);
            if (currentX + (float)width < 0.0f) {
                currentX += (float)width;
                continue;
            }
            RenderUtil.blit256(TextureLocation.WIDGETS, poseStack, currentX - 12.5f + offset, messageY, 0, 32, 9, 9);
            this.font.m_92763_(poseStack, (Component)supporter, currentX, messageY, 0xFFFFFF);
            currentX += (float)width;
        }
    }

    private static class JsonSupporters {
        Map<String, String> supporters;

        private JsonSupporters() {
        }
    }
}

