/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Objects;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.client.config.gui.screen.DonatorBanner;
import mod.adrenix.nostalgic.client.config.gui.screen.GearSpinner;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.toast.NostalgicToast;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastId;
import mod.adrenix.nostalgic.common.NostalgicConnection;
import mod.adrenix.nostalgic.common.config.tweak.TweakType;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.GuiUtil;
import mod.adrenix.nostalgic.util.client.LinkUtil;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class SettingsScreen
extends Screen {
    public static final int BUTTON_HEIGHT = 20;
    public static final int DONE_BUTTON_TOP_OFFSET = 26;
    public static final int LARGE_WIDTH = 204;
    public static final int SMALL_WIDTH = 98;
    protected final Minecraft minecraft;
    private final Screen parent;
    private final ArrayList<Button> buttons = new ArrayList();
    private DonatorBanner banner;
    private boolean isRedirected;
    private boolean isMouseOverSupportToggle = false;

    public SettingsScreen(Screen parent, Component title, boolean isRedirected) {
        super(title);
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.isRedirected = isRedirected;
        this.banner = new DonatorBanner();
        if (!ClientConfigCache.getGui().interactedWithConfig) {
            ClientConfigCache.getGui().interactedWithConfig = true;
            ClientConfigCache.save();
            NostalgicToast.getInstance(ToastId.WELCOME).close();
        }
    }

    public SettingsScreen(Screen parent, boolean isRedirected) {
        this(parent, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.title"), isRedirected);
    }

    private void addButton(Component title, Button.OnPress onPress) {
        this.buttons.add(new Button(0, 0, 98, 20, title, onPress));
    }

    private void setupButtons() {
        int i = 1;
        int row = 0;
        int startX = this.f_96543_ / 2 - 102;
        int startY = this.f_96544_ / 4 + 54 - 8;
        int lastX = this.f_96543_ / 2 + 4;
        boolean isNextLarge = false;
        Button prevButton = this.buttons.get(0);
        for (Button button : this.buttons) {
            button.f_93620_ = i % 2 == 0 ? lastX : startX;
            boolean isFontWide = this.minecraft.f_91062_.m_92852_((FormattedText)button.m_6035_()) > 98;
            boolean isLastButton = button.equals(this.buttons.get(this.buttons.size() - 1));
            if (isNextLarge || isFontWide || isLastButton) {
                if (isNextLarge) {
                    isNextLarge = false;
                    if (i % 2 == 0) {
                        --row;
                    }
                }
                if (i % 2 == 0) {
                    ++row;
                    button.f_93620_ = startX;
                    prevButton.f_93620_ = startX;
                    prevButton.m_93674_(204);
                } else {
                    isNextLarge = true;
                }
                button.m_93674_(204);
            }
            button.f_93621_ = startY + row * 24;
            prevButton = button;
            if (i % 2 == 0 || button.m_5711_() == 204) {
                ++row;
            }
            ++i;
        }
    }

    protected void m_7856_() {
        this.buttons.clear();
        this.addButton((Component)Component.m_237115_((String)"text.autoconfig.nostalgic_tweaks.title"), button -> this.minecraft.m_91152_((Screen)new ConfigScreen(this)));
        Button preset = new Button(0, 0, 98, 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.presets"), button -> {});
        preset.f_93623_ = false;
        this.buttons.add(preset);
        this.addButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.support"), LinkUtil.onPress("https://ko-fi.com/adrenix"));
        this.addButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.discord"), LinkUtil.onPress("https://discord.gg/jWdfVh3"));
        this.addButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.golden_days"), LinkUtil.onPress("https://github.com/PoeticRainbow/golden-days/releases"));
        this.addButton((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_());
        this.setupButtons();
        for (Button button2 : this.buttons) {
            this.m_142416_((GuiEventListener)button2);
        }
        if (this.isRedirected) {
            this.isRedirected = false;
            switch (ClientConfigCache.getGui().defaultScreen) {
                case SETTINGS_MENU: {
                    this.minecraft.m_91152_((Screen)new ConfigScreen(this));
                    break;
                }
                case PRESETS_MENU: {
                    this.minecraft.m_91152_((Screen)this);
                }
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 68) {
            NostalgicTweaks.LOGGER.setDebug(!NostalgicTweaks.isDebugging());
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean isClicked = super.m_6375_(mouseX, mouseY, button);
        if (this.isMouseOverSupportToggle) {
            DonatorBanner.toggle();
            ClientConfigCache.getGui().displayDonatorBanner = DonatorBanner.isOpen();
            ClientConfigCache.save();
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return isClicked;
    }

    public void m_7379_() {
        this.minecraft.m_91152_(this.parent);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.banner = new DonatorBanner();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.f_91073_ != null) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            this.m_96626_(0);
        }
        this.renderLogo(poseStack);
        if (NostalgicTweaks.isDebugging()) {
            this.renderDebug(poseStack);
        } else {
            this.banner.render(poseStack, partialTick);
            if (DonatorBanner.isOpen()) {
                int height = DonatorBanner.getHeight();
                this.m_93179_(poseStack, 0, height - 5, this.f_96543_, height - 2, 0, -1895825408);
                this.m_93179_(poseStack, 0, 0, this.f_96543_, 3, -1895825408, 0);
            }
            this.renderSupportToggle(poseStack, mouseX, mouseY);
            MutableComponent hint = Component.m_237113_((String)"Debug (Ctrl + Shift + D)").m_130940_(ChatFormatting.DARK_GRAY);
            SettingsScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)hint, (int)2, (int)(this.f_96544_ - 10), (int)0xFFFFFF);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderSupportToggle(PoseStack poseStack, int mouseX, int mouseY) {
        MutableComponent button = DonatorBanner.isOpen() ? Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"\u2764").m_130940_(ChatFormatting.RED);
        boolean isOpen = DonatorBanner.isOpen();
        Objects.requireNonNull(this.f_96547_);
        float textHeight = 9.0f;
        float textWidth = this.f_96547_.m_92852_((FormattedText)button);
        float startX = (float)this.f_96543_ - textWidth - 2.0f;
        float startY = isOpen ? (float)DonatorBanner.getHeight() : 2.0f;
        boolean isOver = MathUtil.isWithinBox(mouseX, mouseY, startX, startY, textWidth, textHeight);
        int color = isOver ? 0xFFFFA0 : 0xFFFFFF;
        this.isMouseOverSupportToggle = isOver;
        if (isOver) {
            button.m_130940_(ChatFormatting.DARK_RED);
        }
        this.f_96547_.m_92763_(poseStack, (Component)button, startX, startY, color);
    }

    private String getColored(Object value) {
        if (value instanceof Boolean) {
            return String.format("%s%s", (Boolean)value != false ? "\u00a72" : "\u00a74", value);
        }
        return String.format("\u00a7f%s", value);
    }

    private void renderDebug(PoseStack poseStack) {
        GuiUtil.CornerManager manager = new GuiUtil.CornerManager();
        NostalgicConnection connection = NostalgicTweaks.getConnection().orElseGet(NostalgicConnection::disconnected);
        SettingsScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Debug Mode (Ctrl + Shift + D)", (int)(this.f_96543_ / 2), (int)2, (int)0xFFFF00);
        GuiUtil.drawText(poseStack, String.format("Loader: \u00a7d%s", NostalgicTweaks.isForge() ? "Forge" : "Fabric"), TweakType.Corner.TOP_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Version: \u00a7e%s", NostalgicTweaks.getShortVersion()), TweakType.Corner.TOP_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Protocol: \u00a7b%s", "1.3"), TweakType.Corner.TOP_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Singleplayer: %s", this.getColored(NetUtil.isSingleplayer())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Multiplayer: %s", this.getColored(NetUtil.isMultiplayer())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Connected: %s", this.getColored(NetUtil.isConnected())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Operator: %s", this.getColored(NetUtil.isPlayerOp())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Verified: %s", this.getColored(NostalgicTweaks.isNetworkVerified())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("LAN: %s", this.getColored(NetUtil.isLocalHost())), TweakType.Corner.BOTTOM_LEFT, manager);
        GuiUtil.drawText(poseStack, String.format("Server Protocol: \u00a7b%s", connection.getProtocol()), TweakType.Corner.BOTTOM_RIGHT, manager);
        GuiUtil.drawText(poseStack, String.format("Server Version: \u00a7e%s", connection.getVersion()), TweakType.Corner.BOTTOM_RIGHT, manager);
        GuiUtil.drawText(poseStack, String.format("Server Loader: \u00a7d%s", connection.getLoader()), TweakType.Corner.BOTTOM_RIGHT, manager);
        GuiUtil.drawText(poseStack, String.format("Server: %s", this.getColored(NostalgicTweaks.getConnection().isPresent())), TweakType.Corner.BOTTOM_RIGHT, manager);
        GuiUtil.drawText(poseStack, String.format("Flywheel: %s", this.getColored(ModTracker.FLYWHEEL.isInstalled())), TweakType.Corner.TOP_RIGHT, manager);
        GuiUtil.drawText(poseStack, String.format("Optifine: %s", this.getColored(ModTracker.OPTIFINE.isInstalled())), TweakType.Corner.TOP_RIGHT, manager);
        if (NostalgicTweaks.isFabric()) {
            GuiUtil.drawText(poseStack, String.format("Sodium: %s", this.getColored(ModTracker.SODIUM.isInstalled())), TweakType.Corner.TOP_RIGHT, manager);
        }
        if (NostalgicTweaks.isForge()) {
            GuiUtil.drawText(poseStack, String.format("Rubidium: %s", this.getColored(ModTracker.RUBIDIUM.isInstalled())), TweakType.Corner.TOP_RIGHT, manager);
        }
    }

    private void renderLogo(PoseStack poseStack) {
        RenderSystem.m_69478_();
        int gearX = this.f_96543_ / 2 - 23;
        int gearY = this.f_96544_ / 4 + 1;
        int titleX = this.f_96543_ / 2 - 129;
        int titleY = this.f_96544_ / 4 - 25;
        GearSpinner.getInstance().render(poseStack, 44.279f, gearX, gearY);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.NOSTALGIC_TWEAKS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float titleScale = 0.03325f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)titleX, (double)titleY, 1.0);
        poseStack.m_85841_(titleScale, titleScale, titleScale);
        SettingsScreen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)7808, (int)742, (int)7808, (int)742);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f + 10.0f), (double)((float)this.f_96544_ / 4.0f + 35.0f), 1.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
        String splash = "v" + NostalgicTweaks.getTinyVersion();
        float scale = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        scale = scale * 17.0f / (float)this.f_96547_.m_92895_(splash);
        poseStack.m_85841_(scale, scale, scale);
        SettingsScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)splash, (int)1, (int)-6, (int)0xFFFF00);
        poseStack.m_85849_();
        String beta = NostalgicTweaks.getBetaVersion();
        if (beta.isEmpty()) {
            return;
        }
        float betaScale = (int)this.minecraft.m_91268_().m_85449_() % 2 == 0 ? 0.5f : 0.6f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)(gearX + 46), (double)(gearY + 34), 1.0);
        poseStack.m_85841_(betaScale, betaScale, betaScale);
        this.f_96547_.m_92750_(poseStack, beta, 0.0f, 0.0f, 0xFFFF00);
        poseStack.m_85849_();
        RenderSystem.m_69461_();
    }
}

