/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.config;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakCategory;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakEmbed;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakSubcategory;
import mod.adrenix.nostalgic.client.config.gui.overlay.ServerSideModeOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.MenuOption;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListMapScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.SearchCrumbs;
import mod.adrenix.nostalgic.client.config.gui.widget.ToggleCheckbox;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerId;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ControlButton;
import mod.adrenix.nostalgic.client.config.gui.widget.group.RadioGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.group.TextGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowBuild;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowTweak;
import mod.adrenix.nostalgic.client.config.reflect.ClientReflect;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.DefaultConfig;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.list.ConfigList;
import mod.adrenix.nostalgic.common.config.reflect.CommonReflect;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.tweak.DisabledTweak;
import mod.adrenix.nostalgic.common.config.tweak.GuiTweak;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.ArrayUtil;
import mod.adrenix.nostalgic.util.common.PathUtil;
import mod.adrenix.nostalgic.util.common.TextUtil;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record ConfigRenderer(ConfigScreen parent) {
    private static void sort(TweakClientCache<?> tweak, TweakGui.Placement placement, HashMap<String, TweakClientCache<?>> translated, HashMap<Integer, TweakClientCache<?>> top, HashMap<Integer, TweakClientCache<?>> bottom) {
        if (placement == null) {
            translated.put(tweak.getTranslation(), tweak);
        } else if (tweak.getPosition() == TweakGui.Position.TOP) {
            top.put(tweak.getOrder(), tweak);
        } else if (tweak.getPosition() == TweakGui.Position.BOTTOM) {
            bottom.put(tweak.getOrder(), tweak);
        }
    }

    private static ArrayList<ConfigRowList.Row> generateContainerRows(ConfigRowList list, @Nullable TweakCategory tweakCategory, @Nullable TweakSubcategory tweakSubcategory, @Nullable TweakEmbed tweakEmbed) {
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        HashMap translated = new HashMap();
        HashMap bottom = new HashMap();
        HashMap top = new HashMap();
        HashSet subcategories = new HashSet();
        HashSet embeds = new HashSet();
        TweakClientCache.all().forEach((id, tweak) -> {
            TweakGui.Placement placement = tweak.getPlacement();
            TweakGui.Category category = tweak.getCategory();
            TweakGui.Subcategory subcategory = tweak.getSubcategory();
            TweakGui.Embed embed = tweak.getEmbed();
            if (tweakCategory != null) {
                boolean isTweakInEmptySubcategory;
                boolean isTweakInCategory = category != null && category.container() == tweakCategory && tweak.getGroup() == tweakCategory.getGroup();
                boolean isTweakInSubcategory = subcategory != null && !subcategories.contains((Object)subcategory.container()) && subcategory.container().getCategory() == tweakCategory && tweak.getGroup() == tweakCategory.getGroup();
                boolean bl = isTweakInEmptySubcategory = embed != null && !subcategories.contains((Object)embed.container().getSubcategory()) && embed.container().getSubcategory().getCategory() == tweakCategory;
                if (isTweakInCategory) {
                    ConfigRenderer.sort(tweak, placement, translated, top, bottom);
                } else if (isTweakInSubcategory) {
                    subcategories.add(subcategory.container());
                } else if (isTweakInEmptySubcategory) {
                    subcategories.add(embed.container().getSubcategory());
                }
            } else if (tweakSubcategory != null) {
                boolean isTweakInEmbed;
                boolean isTweakInSubcategory = subcategory != null && subcategory.container() == tweakSubcategory && tweak.getGroup() == tweakSubcategory.getCategory().getGroup();
                boolean bl = isTweakInEmbed = embed != null && !embeds.contains((Object)embed.container()) && embed.container().getSubcategory() == tweakSubcategory && tweak.getGroup() == tweakSubcategory.getCategory().getGroup();
                if (isTweakInSubcategory) {
                    ConfigRenderer.sort(tweak, placement, translated, top, bottom);
                } else if (isTweakInEmbed) {
                    embeds.add(embed.container());
                }
            } else if (tweakEmbed != null && embed != null && embed.container() == tweakEmbed && tweak.getGroup() == tweakEmbed.getSubcategory().getCategory().getGroup()) {
                ConfigRenderer.sort(tweak, placement, translated, top, bottom);
            }
        });
        EnumSet<TweakSubcategory> allSubs = EnumSet.allOf(TweakSubcategory.class);
        EnumSet<TweakEmbed> allEmbeds = EnumSet.allOf(TweakEmbed.class);
        allSubs.forEach(sub -> {
            if (subcategories.contains(sub)) {
                rows.add(ConfigRenderer.getSubcategory(sub, list).generate());
            }
        });
        allEmbeds.forEach(embed -> {
            if (embeds.contains(embed)) {
                rows.add(ConfigRenderer.getEmbedded(embed, list).generate());
            }
        });
        TreeMap<Integer, TweakClientCache> sortTop = new TreeMap<Integer, TweakClientCache>(top);
        TreeMap<String, TweakClientCache> sortMiddle = new TreeMap<String, TweakClientCache>(translated);
        TreeMap<Integer, TweakClientCache> sortBottom = new TreeMap<Integer, TweakClientCache>(bottom);
        sortTop.forEach((key, tweak) -> ConfigRenderer.addRowFromTweak(rows, list, tweak));
        sortMiddle.forEach((key, tweak) -> ConfigRenderer.addRowFromTweak(rows, list, tweak));
        sortBottom.forEach((key, tweak) -> ConfigRenderer.addRowFromTweak(rows, list, tweak));
        return rows;
    }

    private static void addRowFromTweak(ArrayList<ConfigRowList.Row> rows, ConfigRowList list, TweakClientCache<?> tweak) {
        ConfigRowList.Row row = list.rowFromTweak(tweak);
        if (row != null) {
            rows.add(row);
        }
    }

    private static Supplier<ArrayList<ConfigRowList.Row>> getContainerRowSupplier(ConfigRowList list, @Nullable TweakCategory category, @Nullable TweakSubcategory subcategory, @Nullable TweakEmbed embedded) {
        return () -> ConfigRenderer.generateContainerRows(list, category, subcategory, embedded);
    }

    private static ConfigRowGroup.ContainerRow getEmbedded(TweakEmbed embedded, ConfigRowList list) {
        return new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)embedded.getLangKey()), ConfigRenderer.getContainerRowSupplier(list, null, null, embedded), embedded, ConfigRowGroup.ContainerType.EMBEDDED);
    }

    private static ConfigRowGroup.ContainerRow getSubcategory(TweakSubcategory subcategory, ConfigRowList list) {
        return new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)subcategory.getLangKey()), ConfigRenderer.getContainerRowSupplier(list, null, subcategory, null), subcategory, ConfigRowGroup.ContainerType.SUBCATEGORY);
    }

    private static ConfigRowGroup.ContainerRow getCategory(TweakCategory category, ConfigRowList list) {
        return new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)category.getLangKey()), ConfigRenderer.getContainerRowSupplier(list, category, null, null), category);
    }

    private static List<ConfigRowList.Row> getCategories(ConfigRowList list, TweakGroup group) {
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        EnumSet<TweakCategory> categories = EnumSet.allOf(TweakCategory.class);
        categories.forEach(category -> {
            if (category.getGroup() == group) {
                rows.add(ConfigRenderer.getCategory(category, list).generate());
            }
        });
        return rows;
    }

    private void addRows(TweakGroup group) {
        ConfigRowList list = this.parent.getWidgets().getConfigRowList();
        ConfigRenderer.getCategories(list, group).forEach(list::addRow);
        Comparator<String> translationComparator = Comparator.comparing(key -> TweakClientCache.get(group, key).getTranslation());
        Comparator<String> orderComparator = Comparator.comparing(key -> TweakClientCache.get(group, key).getOrder());
        HashMap top = new HashMap();
        HashMap middle = new HashMap();
        HashMap bottom = new HashMap();
        HashMap<String, Object> all = new HashMap<String, Object>(ClientReflect.getGroup(group));
        all.forEach((key, value) -> {
            TweakGui.Placement placement = CommonReflect.getAnnotation(group, key, TweakGui.Placement.class);
            TweakGui.Category category = CommonReflect.getAnnotation(group, key, TweakGui.Category.class);
            TweakGui.Subcategory subcategory = CommonReflect.getAnnotation(group, key, TweakGui.Subcategory.class);
            TweakGui.Embed embed = CommonReflect.getAnnotation(group, key, TweakGui.Embed.class);
            if (category == null && subcategory == null && embed == null) {
                if (placement == null) {
                    middle.put(key, value);
                } else if (placement.pos() == TweakGui.Position.TOP) {
                    top.put(key, value);
                } else if (placement.pos() == TweakGui.Position.BOTTOM) {
                    bottom.put(key, value);
                }
            }
        });
        TreeMap<String, Object> sortTop = new TreeMap<String, Object>(orderComparator);
        TreeMap<String, Object> sortMiddle = new TreeMap<String, Object>(translationComparator);
        TreeMap<String, Object> sortBottom = new TreeMap<String, Object>(orderComparator);
        sortTop.putAll(top);
        sortMiddle.putAll(middle);
        sortBottom.putAll(bottom);
        sortTop.forEach((key, value) -> list.addRow(group, (String)key, value));
        sortMiddle.forEach((key, value) -> list.addRow(group, (String)key, value));
        sortBottom.forEach((key, value) -> list.addRow(group, (String)key, value));
    }

    private void addSearchRow(TweakClientCache<?> tweak) {
        ConfigRowList list = this.parent.getWidgets().getConfigRowList();
        ConfigRowList.Row row = list.rowFromTweak(tweak);
        if (row == null) {
            return;
        }
        row.children.add(new SearchCrumbs(tweak));
        list.addRow(row);
    }

    private void addFound() {
        if (this.parent.search.isEmpty()) {
            return;
        }
        String[] words = this.parent.getWidgets().getSearchInput().m_94155_().split(" ");
        String first = ArrayUtil.get(words, 0);
        boolean isTagOnly = first != null && first.startsWith("#") && words.length == 1;
        Map<String, TweakClientCache<?>> found = this.parent.search;
        TreeMap<String, TweakClientCache> sorted = isTagOnly ? new TreeMap<String, TweakClientCache>(Comparator.comparing(key -> ((TweakClientCache)found.get(key)).getTranslation())) : new TreeMap((firstKey, secondKey) -> TweakClientCache.compareWeights(((TweakClientCache)found.get(secondKey)).getWeight(), ((TweakClientCache)found.get(firstKey)).getWeight()));
        sorted.putAll(found);
        sorted.forEach((id, tweak) -> this.addSearchRow((TweakClientCache<?>)tweak));
    }

    private ArrayList<ConfigRowList.Row> getGeneralOverrideList() {
        TextGroup help = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.help"));
        AtomicBoolean serverOnly = new AtomicBoolean(false);
        AtomicBoolean clientOnly = new AtomicBoolean(false);
        Button.OnPress onDisable = button -> Arrays.stream(TweakGroup.values()).forEach(group -> {
            if (!TweakGroup.isManual(group)) {
                ClientReflect.getGroup(group).forEach((key, value) -> {
                    TweakGui.DisabledString disabledString;
                    TweakGui.DisabledInteger disabledInteger;
                    boolean isChangeable;
                    TweakClientCache<Boolean> tweak = TweakClientCache.get(group, key);
                    boolean isDisableIgnored = tweak.isMetadataPresent(TweakGui.IgnoreDisable.class);
                    boolean isClientIgnored = serverOnly.get() && tweak.isClient() && !tweak.isDynamic();
                    boolean isServerIgnored = clientOnly.get() && (tweak.isServer() || tweak.isDynamic());
                    boolean isLocked = tweak.isLocked();
                    boolean bl = isChangeable = !isDisableIgnored && !isLocked && !isClientIgnored && !isServerIgnored;
                    if (!(isClientIgnored || isServerIgnored || isLocked)) {
                        tweak.reset();
                    }
                    if (value instanceof Boolean && isChangeable) {
                        TweakGui.DisabledBoolean disabledBoolean = tweak.getMetadata(TweakGui.DisabledBoolean.class);
                        if (disabledBoolean == null && ((Boolean)tweak.getDefault()).booleanValue()) {
                            tweak.reset();
                            tweak.setValue((Boolean)tweak.getValue() == false);
                        } else if (disabledBoolean != null) {
                            tweak.setValue(disabledBoolean.value());
                        }
                    }
                    if (value instanceof Integer && isChangeable && (disabledInteger = tweak.getMetadata(TweakGui.DisabledInteger.class)) != null) {
                        TweakClientCache<Integer> intTweak = TweakClientCache.get(group, key);
                        intTweak.setValue(disabledInteger.value());
                    }
                    if (value instanceof String && isChangeable && (disabledString = tweak.getMetadata(TweakGui.DisabledString.class)) != null) {
                        TweakClientCache<String> stringTweak = TweakClientCache.get(group, key);
                        stringTweak.setValue(disabledString.value());
                    }
                    if (value instanceof DisabledTweak && isChangeable) {
                        TweakClientCache enumTweak = TweakClientCache.get(group, key);
                        enumTweak.setValue(((DisabledTweak)value).getDisabledValue());
                    }
                });
            }
        });
        Button.OnPress onEnable = button -> Arrays.stream(TweakGroup.values()).forEach(group -> {
            if (!TweakGroup.isManual(group)) {
                ClientReflect.getGroup(group).forEach((key, value) -> {
                    boolean isChangeable;
                    TweakClientCache tweak = TweakClientCache.get(group, key);
                    boolean isClientIgnored = serverOnly.get() && tweak.isClient() && !tweak.isDynamic();
                    boolean isServerIgnored = clientOnly.get() && (tweak.isServer() || tweak.isDynamic());
                    boolean isLocked = tweak.isLocked();
                    boolean bl = isChangeable = !isLocked && !isClientIgnored && !isServerIgnored;
                    if (isChangeable) {
                        tweak.reset();
                    }
                });
            }
        });
        Button.OnPress onReview = button -> {
            this.parent.setConfigTab(ConfigScreen.ConfigTab.SEARCH);
            this.parent.getWidgets().getSearchInput().m_94144_(String.format("#%s ", new Object[]{ConfigWidgets.SearchTag.SAVE}));
        };
        ControlButton disableAll = new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.disable"), onDisable);
        ControlButton enableAll = new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.enable"), onEnable);
        ControlButton reviewAll = new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.review"), onReview);
        ToggleCheckbox toggleClientOnly = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.client"), clientOnly::get, clientOnly::set);
        ToggleCheckbox toggleServerOnly = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.server"), serverOnly::get, serverOnly::set);
        toggleClientOnly.setTooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.client.@Tooltip"));
        toggleServerOnly.setTooltip((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.server.@Tooltip"));
        ConfigRowBuild.BlankRow blank = new ConfigRowBuild.BlankRow();
        ConfigRowBuild.SingleLeftRow client = new ConfigRowBuild.SingleLeftRow((AbstractWidget)toggleClientOnly, 28);
        ConfigRowBuild.SingleLeftRow server = new ConfigRowBuild.SingleLeftRow((AbstractWidget)toggleServerOnly, 28);
        ConfigRowBuild.SingleLeftRow disable = new ConfigRowBuild.SingleLeftRow((AbstractWidget)disableAll, 28);
        ConfigRowBuild.SingleLeftRow enable = new ConfigRowBuild.SingleLeftRow((AbstractWidget)enableAll, 28);
        ConfigRowBuild.SingleLeftRow review = new ConfigRowBuild.SingleLeftRow((AbstractWidget)reviewAll, 28);
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(help.generate());
        rows.add(client.generate());
        rows.add(server.generate());
        rows.add(blank.generate());
        rows.add(disable.generate());
        rows.add(enable.generate());
        rows.add(review.generate());
        return rows;
    }

    private ArrayList<ConfigRowList.Row> getConfigManagementList() {
        Button.OnPress onBackup = button -> {
            AutoConfig.getConfigHolder(ClientConfig.class).backup();
            Util.m_137581_().m_137644_(PathUtil.getBackupPath().toFile());
        };
        Button.OnPress onOpen = button -> Util.m_137581_().m_137644_(PathUtil.getConfigPath().toFile());
        ControlButton backup = new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.management.backup"), onBackup);
        ControlButton open = new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.management.open"), onOpen);
        TextGroup groupHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.management.help"));
        TextGroup maxHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.management.maxBackupHelp"));
        ConfigRowBuild.BlankRow blank = new ConfigRowBuild.BlankRow();
        ConfigRowBuild.SingleCenteredRow backupRow = new ConfigRowBuild.SingleCenteredRow((AbstractWidget)backup);
        ConfigRowBuild.SingleCenteredRow openRow = new ConfigRowBuild.SingleCenteredRow((AbstractWidget)open);
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(groupHelp.generate());
        ConfigRowList list = this.parent.getWidgets().getConfigRowList();
        rows.add(openRow.generate());
        rows.add(backupRow.generate());
        rows.add(blank.generate());
        rows.addAll(maxHelp.generate());
        rows.add(list.rowFromTweak(TweakClientCache.get(GuiTweak.MAXIMUM_BACKUPS)));
        return rows;
    }

    private ArrayList<ConfigRowList.Row> getGeneralBindingsList() {
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        KeyUtil.find("key.nostalgic_tweaks.open_config").ifPresent(mapping -> rows.add(new ConfigRowBuild.BindingRow((KeyMapping)mapping).generate()));
        KeyUtil.find("key.nostalgic_tweaks.toggle_fog").ifPresent(mapping -> rows.add(new ConfigRowBuild.BindingRow((KeyMapping)mapping).generate()));
        return rows;
    }

    private ArrayList<ConfigRowList.Row> getGeneralSettingsList() {
        ArrayList<ConfigRowList.Row> subcategories = new ArrayList<ConfigRowList.Row>();
        Supplier<ArrayList<ConfigRowList.Row>> getScreenOptions = () -> {
            TweakClientCache defaultScreen = TweakClientCache.get(GuiTweak.DEFAULT_SCREEN);
            RadioGroup<MenuOption> radioGroup = new RadioGroup<MenuOption>(MenuOption.class, DefaultConfig.Gui.DEFAULT_SCREEN, defaultScreen::getValue, defaultScreen::setValue, MenuOption::getTranslation);
            TextGroup radioHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.screen.info"));
            ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(radioHelp.generate());
            rows.addAll(radioGroup.getRows());
            return rows;
        };
        ConfigRowGroup.ContainerRow screenConfig = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.screen.title"), getScreenOptions, ContainerId.DEFAULT_SCREEN_CONFIG, ConfigRowGroup.ContainerType.SUBCATEGORY);
        subcategories.add(screenConfig.generate());
        Supplier<ArrayList<ConfigRowList.Row>> getTreeOptions = () -> {
            TextGroup treeHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tree.info"));
            ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(treeHelp.generate());
            TweakClientCache tree = TweakClientCache.get(GuiTweak.DISPLAY_CATEGORY_TREE);
            rows.add(new ConfigRowTweak.BooleanRow(TweakGroup.GUI, tree.getKey(), (Boolean)tree.getValue()).generate());
            TweakClientCache color = TweakClientCache.get(GuiTweak.CATEGORY_TREE_COLOR);
            rows.add(new ConfigRowTweak.ColorRow(TweakGroup.GUI, color.getKey(), (String)color.getValue()).generate());
            return rows;
        };
        ConfigRowGroup.ContainerRow treeConfig = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tree.title"), getTreeOptions, ContainerId.TREE_CONFIG, ConfigRowGroup.ContainerType.SUBCATEGORY);
        subcategories.add(treeConfig.generate());
        Supplier<ArrayList<ConfigRowList.Row>> getHighlightOptions = () -> {
            TextGroup rowHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.row.info"));
            ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(rowHelp.generate());
            TweakClientCache highlight = TweakClientCache.get(GuiTweak.DISPLAY_ROW_HIGHLIGHT);
            rows.add(new ConfigRowTweak.BooleanRow(TweakGroup.GUI, highlight.getKey(), (Boolean)highlight.getValue()).generate());
            TweakClientCache fade = TweakClientCache.get(GuiTweak.ROW_HIGHLIGHT_FADE);
            rows.add(new ConfigRowTweak.BooleanRow(TweakGroup.GUI, fade.getKey(), (Boolean)fade.getValue()).generate());
            TweakClientCache color = TweakClientCache.get(GuiTweak.ROW_HIGHLIGHT_COLOR);
            rows.add(new ConfigRowTweak.ColorRow(TweakGroup.GUI, color.getKey(), (String)color.getValue()).generate());
            return rows;
        };
        ConfigRowGroup.ContainerRow highlightConfig = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.row.title"), getHighlightOptions, ContainerId.ROW_CONFIG, ConfigRowGroup.ContainerType.SUBCATEGORY);
        subcategories.add(highlightConfig.generate());
        Supplier<ArrayList<ConfigRowList.Row>> getTaggingOptions = () -> {
            TextGroup tagHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tags.info"));
            ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>(tagHelp.generate());
            TweakClientCache displayNewTags = TweakClientCache.get(GuiTweak.DISPLAY_NEW_TAGS);
            ToggleCheckbox newTagsCheckbox = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.newTags.label"), displayNewTags::getValue, displayNewTags::setValue);
            ConfigRowBuild.ManualRow newTagsRow = new ConfigRowBuild.ManualRow(List.of(newTagsCheckbox));
            rows.add(newTagsRow.generate());
            TweakClientCache displaySidedTags = TweakClientCache.get(GuiTweak.DISPLAY_SIDED_TAGS);
            ToggleCheckbox sidedTagsCheckbox = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.sidedTags.label"), displaySidedTags::getValue, displaySidedTags::setValue);
            ConfigRowBuild.ManualRow sidedTagsRow = new ConfigRowBuild.ManualRow(List.of(sidedTagsCheckbox));
            rows.add(sidedTagsRow.generate());
            TweakClientCache displayTagTooltips = TweakClientCache.get(GuiTweak.DISPLAY_TAG_TOOLTIPS);
            ToggleCheckbox tagTooltipsCheckbox = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tagTooltips.label"), displayTagTooltips::getValue, displayTagTooltips::setValue);
            ConfigRowBuild.ManualRow tagTooltipsRow = new ConfigRowBuild.ManualRow(List.of(tagTooltipsCheckbox));
            rows.add(tagTooltipsRow.generate());
            rows.add(new ConfigRowBuild.BlankRow().generate());
            TextGroup statusHelp = new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tweakStatus.help"));
            rows.addAll(statusHelp.generate());
            TweakClientCache displayFeatureStatus = TweakClientCache.get(GuiTweak.DISPLAY_FEATURE_STATUS);
            ToggleCheckbox featureStatusCheckbox = new ToggleCheckbox((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tweakStatus.label"), displayFeatureStatus::getValue, displayFeatureStatus::setValue);
            ConfigRowBuild.ManualRow featureStatusRow = new ConfigRowBuild.ManualRow(List.of(featureStatusCheckbox));
            rows.add(featureStatusRow.generate());
            return rows;
        };
        ConfigRowGroup.ContainerRow taggingConfig = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.tags.title"), getTaggingOptions, ContainerId.TITLE_TAGS_CONFIG, ConfigRowGroup.ContainerType.SUBCATEGORY);
        subcategories.add(taggingConfig.generate());
        return subcategories;
    }

    private ArrayList<ConfigRowList.Row> getGeneralSearchTags() {
        MutableComponent help = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.help");
        MutableComponent newTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.new");
        MutableComponent conflictTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.conflict");
        MutableComponent resetTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.reset");
        MutableComponent clientTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.client");
        MutableComponent serverTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.server");
        MutableComponent saveTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.save");
        MutableComponent allTag = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.all");
        Component[] tags = new Component[]{help, newTag, conflictTag, resetTag, clientTag, serverTag, saveTag, allTag};
        return new TextGroup(TextUtil.combine(tags)).generate();
    }

    private ArrayList<ConfigRowList.Row> getGeneralShortcuts() {
        MutableComponent help = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.help");
        MutableComponent find = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.find");
        MutableComponent save = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.save");
        MutableComponent exit = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.exit");
        MutableComponent jump = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.jump");
        MutableComponent all = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.all");
        MutableComponent group = Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.group");
        return new TextGroup(TextUtil.combine(new Component[]{help, find, save, exit, jump, all, group})).generate();
    }

    private void addGeneral() {
        ConfigRowList list = this.parent.getWidgets().getConfigRowList();
        TweakClientCache isModEnabled = TweakClientCache.get(TweakGroup.ROOT, "isModEnabled");
        list.addRow(new ConfigRowTweak.BooleanRow(TweakGroup.ROOT, isModEnabled.getKey(), (Boolean)isModEnabled.getValue()).generate());
        if (NostalgicTweaks.getConnection().isPresent() && NetUtil.isPlayerOp() && !NetUtil.isSingleplayer()) {
            list.addRow(new ConfigRowBuild.SingleCenteredRow((AbstractWidget)new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.sso.button"), button -> new ServerSideModeOverlay())).generate());
        }
        ConfigRowGroup.ContainerRow configManagement = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.management.title"), this::getConfigManagementList, ContainerId.CONFIG_MANAGEMENT);
        list.addRow(configManagement.generate());
        ConfigRowGroup.ContainerRow changeAllTweaks = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.override.title"), this::getGeneralOverrideList, ContainerId.OVERRIDE_CONFIG);
        list.addRow(changeAllTweaks.generate());
        ConfigRowGroup.ContainerRow changeKeyBinds = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.bindings.title"), this::getGeneralBindingsList, ContainerId.BINDINGS_CONFIG);
        list.addRow(changeKeyBinds.generate());
        ConfigRowGroup.ContainerRow changeSettings = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.config.title"), this::getGeneralSettingsList, ContainerId.GENERAL_CONFIG);
        list.addRow(changeSettings.generate());
        ConfigRowGroup.ContainerRow searchTags = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.search.title"), this::getGeneralSearchTags, ContainerId.SEARCH_TAGS_CONFIG);
        list.addRow(searchTags.generate());
        ConfigRowGroup.ContainerRow shortcuts = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.general.shortcut.title"), this::getGeneralShortcuts, ContainerId.SHORTCUTS_CONFIG);
        list.addRow(shortcuts.generate());
    }

    public void generateRowsFromAllGroups() {
        this.addRows(TweakGroup.SOUND);
        this.addRows(TweakGroup.CANDY);
        this.addRows(TweakGroup.GAMEPLAY);
        this.addRows(TweakGroup.ANIMATION);
        this.addRows(TweakGroup.SWING);
    }

    public void generateAndRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.parent.getConfigTab() == ConfigScreen.ConfigTab.SWING) {
            this.parent.getWidgets().getSwingSpeedPrefix().m_6305_(poseStack, mouseX, mouseY, partialTick);
            ListMapScreen<Integer> leftSpeedsScreen = new ListMapScreen<Integer>((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.left_speeds"), ConfigList.LEFT_CLICK_SPEEDS);
            ConfigRowBuild.SingleCenteredRow leftSpeedsButton = new ConfigRowBuild.SingleCenteredRow((AbstractWidget)new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.left_speeds"), button -> this.parent.getMinecraft().m_91152_((Screen)leftSpeedsScreen)));
            this.parent.getWidgets().getConfigRowList().addRow(leftSpeedsButton.generate());
            ListMapScreen<Integer> rightSpeedsScreen = new ListMapScreen<Integer>((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.right_speeds"), ConfigList.RIGHT_CLICK_SPEEDS);
            ConfigRowBuild.SingleCenteredRow rightSpeedsButton = new ConfigRowBuild.SingleCenteredRow((AbstractWidget)new ControlButton((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.settings.right_speeds"), button -> this.parent.getMinecraft().m_91152_((Screen)rightSpeedsScreen)));
            this.parent.getWidgets().getConfigRowList().addRow(rightSpeedsButton.generate());
        } else if (this.parent.getConfigTab() == ConfigScreen.ConfigTab.SEARCH && this.parent.search.isEmpty()) {
            String[] words = this.parent.getWidgets().getSearchInput().m_94155_().split(" ");
            String first = ArrayUtil.get(words, 0);
            boolean isInvalidTag = this.parent.getWidgets().getSearchInput().m_94155_().startsWith("#");
            if (first != null) {
                for (ConfigWidgets.SearchTag tag : ConfigWidgets.SearchTag.values()) {
                    if (!tag.toString().equals(first.replaceAll("#", ""))) continue;
                    isInvalidTag = false;
                }
            }
            if (isInvalidTag) {
                this.parent.renderLast.add(() -> Screen.m_93215_((PoseStack)poseStack, (Font)this.parent.getFont(), (Component)Component.m_237110_((String)"gui.nostalgic_tweaks.config.search.invalidTag", (Object[])new Object[]{this.parent.getWidgets().getSearchInput().m_94155_()}), (int)(this.parent.f_96543_ / 2), (int)(this.parent.f_96544_ / 2), (int)0xFFFFFF));
            } else {
                this.parent.renderLast.add(() -> Screen.m_93215_((PoseStack)poseStack, (Font)this.parent.getFont(), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.search.empty"), (int)(this.parent.f_96543_ / 2), (int)(this.parent.f_96544_ / 2), (int)0xFFFFFF));
            }
        }
        switch (this.parent.getConfigTab()) {
            case ALL: {
                this.generateRowsFromAllGroups();
                break;
            }
            case GENERAL: {
                this.addGeneral();
                break;
            }
            case SOUND: {
                this.addRows(TweakGroup.SOUND);
                break;
            }
            case CANDY: {
                this.addRows(TweakGroup.CANDY);
                break;
            }
            case GAMEPLAY: {
                this.addRows(TweakGroup.GAMEPLAY);
                break;
            }
            case ANIMATION: {
                this.addRows(TweakGroup.ANIMATION);
                break;
            }
            case SWING: {
                this.addRows(TweakGroup.SWING);
                break;
            }
            case SEARCH: {
                this.addFound();
            }
        }
    }
}

