/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakCategory;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakEmbed;
import mod.adrenix.nostalgic.client.config.annotation.container.TweakSubcategory;
import mod.adrenix.nostalgic.client.config.gui.overlay.CategoryListOverlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigRenderer;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.gui.widget.SearchCrumbs;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.KeyBindButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.OverlapButton;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.client.RunUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ConfigScreen
extends Screen {
    public final ArrayList<Runnable> renderLast = new ArrayList();
    protected final Map<String, TweakClientCache<?>> search = new TreeMap();
    private final Minecraft minecraft;
    private final Screen parentScreen;
    private ConfigWidgets widgetProvider;
    private ConfigRenderer rendererProvider;
    private ConfigTab configTab = ConfigTab.GENERAL;
    private String searchCache = "";
    private int rowHeightCache = 0;
    private double scrollAmountCache = 0.0;
    private static boolean isCacheReflected = false;

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public ConfigWidgets getWidgets() {
        return this.widgetProvider;
    }

    public ConfigRenderer getRenderer() {
        return this.rendererProvider;
    }

    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    public ConfigTab getConfigTab() {
        return this.configTab;
    }

    public ConfigScreen(Screen parentScreen, Component title) {
        super(title);
        this.minecraft = Minecraft.m_91087_();
        this.parentScreen = parentScreen;
        if (Minecraft.m_91087_().f_91073_ != null && !isCacheReflected) {
            isCacheReflected = true;
            TweakClientCache.all().forEach((key, tweak) -> {
                TweakData.EntryStatus entryStatus = tweak.getMetadata(TweakData.EntryStatus.class);
                if (entryStatus != null && tweak.getStatus() == TweakStatus.WAIT) {
                    tweak.setStatus(TweakStatus.FAIL);
                }
            });
            TweakServerCache.all().forEach((key, tweak) -> {
                TweakData.EntryStatus entryStatus = tweak.getMetadata(TweakData.EntryStatus.class);
                if (entryStatus != null && tweak.getStatus() == TweakStatus.WAIT) {
                    tweak.setStatus(TweakStatus.FAIL);
                }
            });
        }
        NostalgicTweaks.LOGGER.debug("Found %s possibly conflicted tweaks", TweakClientCache.getConflicts());
    }

    public ConfigScreen(Screen parentScreen) {
        this(parentScreen, (Component)Component.m_237115_((String)"text.autoconfig.nostalgic_tweaks.title"));
    }

    public void setupCache() {
        this.searchCache = this.getWidgets().getSearchInput().m_94155_();
        this.rowHeightCache = this.getWidgets().getConfigRowList().getRowHeight();
        this.scrollAmountCache = this.getWidgets().getConfigRowList().m_93517_();
    }

    public void restoreCache() {
        this.getWidgets().getSearchInput().m_94144_(this.searchCache);
        this.getWidgets().getConfigRowList().setRowHeight(this.rowHeightCache);
        if (this.configTab == ConfigTab.SEARCH) {
            this.getWidgets().getSearchInput().m_94194_(true);
        }
    }

    protected void m_7856_() {
        this.widgetProvider = new ConfigWidgets(this);
        this.rendererProvider = new ConfigRenderer(this);
        this.getWidgets().generate();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.setupCache();
        super.m_6574_(minecraft, width, height);
        this.restoreCache();
        if (this.configTab == ConfigTab.SEARCH) {
            this.getWidgets().focusInput = true;
        }
        Overlay.resize();
    }

    public void m_86600_() {
        this.getWidgets().getSearchInput().m_94120_();
    }

    public void m_7379_() {
        this.save();
        AutoConfig.getConfigHolder(ClientConfig.class).save();
        ContainerButton.collapseAll();
        this.minecraft.m_91152_(this.parentScreen);
    }

    public <T extends GuiEventListener & Widget> T m_142416_(T widget) {
        return (T)super.m_142416_(widget);
    }

    public void resetRowList() {
        this.getWidgets().getConfigRowList().m_6702_().clear();
        this.getWidgets().getConfigRowList().resetScrollbar();
        this.getWidgets().getConfigRowList().resetLastSelection();
    }

    public void setConfigTab(ConfigTab configTab) {
        if (this.configTab == configTab) {
            return;
        }
        if (this.configTab == ConfigTab.ALL || configTab == ConfigTab.ALL) {
            ContainerButton.collapseAll();
        }
        if (configTab == ConfigTab.SEARCH) {
            this.getWidgets().getConfigRowList().setRowHeight(36);
        } else {
            this.getWidgets().getConfigRowList().resetRowHeight();
        }
        this.configTab = configTab;
        this.resetRowList();
        if (configTab == ConfigTab.ALL) {
            if (!Overlay.isOpened()) {
                this.getRenderer().generateRowsFromAllGroups();
                new CategoryListOverlay();
            }
        } else if (configTab == ConfigTab.SEARCH) {
            this.getWidgets().getSearchInput().m_94194_(true);
            this.getWidgets().runSearch(this.getWidgets().getSearchInput().m_94155_());
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.configTab == ConfigTab.SEARCH && this.getWidgets().getSearchInput().m_93696_()) {
            boolean isCharTyped = this.getWidgets().getSearchInput().m_5534_(codePoint, modifiers);
            if (isCharTyped && !KeyUtil.isModifierDown()) {
                this.getWidgets().getConfigRowList().m_6702_().clear();
            }
            return isCharTyped;
        }
        ConfigRowList.Row focused = (ConfigRowList.Row)this.getWidgets().getConfigRowList().m_7222_();
        if (focused != null) {
            for (AbstractWidget widget : focused.children) {
                if (!(widget instanceof EditBox)) continue;
                widget.m_5534_(codePoint, modifiers);
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (Overlay.isOpened()) {
            return Overlay.mouseScrolled(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (Overlay.isOpened()) {
            return Overlay.mouseClicked(mouseX, mouseY, button);
        }
        if (this.getWidgets().getSearchInput().m_93696_()) {
            this.getWidgets().getSearchInput().m_6375_(mouseX, mouseY, button);
        }
        if (this.configTab == ConfigTab.SEARCH) {
            if (ConfigRowList.overTweakId != null && ConfigWidgets.isInsideRowList(mouseY)) {
                ContainerButton.collapseAll();
                ConfigRowList.jumpToTweakId = ConfigRowList.overTweakId;
            }
            for (ConfigRowList.Row row : this.getWidgets().getConfigRowList().m_6702_()) {
                for (AbstractWidget widget : row.children) {
                    SearchCrumbs crumb;
                    boolean isClicked;
                    if (!(widget instanceof SearchCrumbs) || !(isClicked = (crumb = (SearchCrumbs)widget).m_6375_(mouseX, mouseY, button))) continue;
                    ContainerButton.collapseAll();
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (Overlay.isOpened()) {
            return Overlay.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (Overlay.isOpened()) {
            Overlay.onRelease(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private EditBox getEditBox() {
        ConfigRowList.Row focused = (ConfigRowList.Row)this.getWidgets().getConfigRowList().m_7222_();
        if (focused != null) {
            for (AbstractWidget widget : focused.children) {
                if (!(widget instanceof EditBox) || !((EditBox)widget).m_94204_()) continue;
                return (EditBox)widget;
            }
        }
        return null;
    }

    private KeyBindButton getMappingInput() {
        ConfigRowList.Row focused = (ConfigRowList.Row)this.getWidgets().getConfigRowList().m_7222_();
        if (focused != null) {
            for (AbstractWidget widget : focused.children) {
                if (!(widget instanceof KeyBindButton) || !((KeyBindButton)widget).isModifying()) continue;
                return (KeyBindButton)widget;
            }
        }
        return null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Screen.m_96638_() && Screen.m_96637_() && keyCode == 68) {
            this.parentScreen.m_7933_(keyCode, scanCode, modifiers);
        }
        if (Overlay.isOpened()) {
            return Overlay.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.getWidgets().getConfigRowList().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        KeyBindButton mappingInput = this.getMappingInput();
        EditBox editBox = this.getEditBox();
        if (KeyUtil.isEsc(keyCode) && this.m_6913_() && mappingInput == null) {
            if (this.getWidgets().getSearchInput().m_93696_()) {
                this.getWidgets().getSearchInput().m_94178_(false);
            } else if (editBox != null && editBox.m_93696_()) {
                editBox.m_94178_(false);
            } else {
                this.onCancel();
            }
            return true;
        }
        if (editBox != null) {
            return editBox.m_7933_(keyCode, scanCode, modifiers);
        }
        if (mappingInput != null) {
            mappingInput.setKey(keyCode, scanCode);
            return true;
        }
        if (KeyUtil.isSaving(keyCode)) {
            this.m_7379_();
            return true;
        }
        if ((KeyUtil.isGoingLeft(keyCode) || KeyUtil.isGoingRight(keyCode)) && !this.getWidgets().getSearchInput().m_93696_()) {
            ConfigTab[] tabs = ConfigTab.values();
            ConfigTab last = ConfigTab.GENERAL;
            for (int i = 0; i < tabs.length; ++i) {
                ConfigTab tab = tabs[i];
                if (tab == ConfigTab.ALL && this.configTab != ConfigTab.ALL) continue;
                if (this.configTab == ConfigTab.ALL) {
                    last = ConfigTab.ALL;
                }
                if (KeyUtil.isGoingLeft(keyCode) && this.configTab == tab) {
                    this.setConfigTab(this.configTab != last ? last : tabs[tabs.length - 2]);
                    break;
                }
                if (KeyUtil.isGoingRight(keyCode) && this.configTab == tab) {
                    this.setConfigTab(i + 1 < tabs.length - 1 ? tabs[i + 1] : tabs[1]);
                    break;
                }
                last = tab;
            }
        }
        if (this.configTab == ConfigTab.SEARCH && this.getWidgets().getSearchInput().m_93696_() && !KeyUtil.isEsc(keyCode)) {
            boolean isInputChanged = this.getWidgets().getSearchInput().m_7933_(keyCode, scanCode, modifiers);
            if (!KeyUtil.isLeftOrRight(keyCode)) {
                if (KeyUtil.isSearching(keyCode)) {
                    this.getWidgets().getSearchInput().m_94144_("");
                } else if (KeyUtil.isModifierDown() || isInputChanged) {
                    if (isInputChanged) {
                        this.getWidgets().runSearch(this.getWidgets().getSearchInput().m_94155_());
                    }
                    return true;
                }
            }
            return isInputChanged;
        }
        if (KeyUtil.isSearching(keyCode)) {
            this.setConfigTab(ConfigTab.SEARCH);
            this.getWidgets().focusInput = true;
            return true;
        }
        if (KeyUtil.isSelectAll(keyCode)) {
            this.setConfigTab(ConfigTab.ALL);
            if (!Overlay.isOpened()) {
                new CategoryListOverlay();
            }
            return true;
        }
        if (!KeyUtil.isTab(keyCode) && super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return keyCode == 257 || keyCode == 335;
    }

    private ConfigTab getTabFromGroupKey(String groupLangKey) {
        for (TweakGroup group : TweakGroup.values()) {
            if (!group.getLangKey().equals(groupLangKey)) continue;
            return switch (group) {
                case TweakGroup.CANDY -> ConfigTab.CANDY;
                case TweakGroup.SOUND -> ConfigTab.SOUND;
                case TweakGroup.SWING -> ConfigTab.SWING;
                case TweakGroup.GAMEPLAY -> ConfigTab.GAMEPLAY;
                case TweakGroup.ANIMATION -> ConfigTab.ANIMATION;
                default -> ConfigTab.GENERAL;
            };
        }
        return ConfigTab.GENERAL;
    }

    public void setTabFromGroupKey(String groupLangKey) {
        this.setConfigTab(this.getTabFromGroupKey(groupLangKey));
    }

    public void setScrollOnContainer(Object containerId) {
        ConfigRowList.jumpToContainerId = containerId;
    }

    private void jumpToTweak(TweakClientCache<?> tweak) {
        ConfigRowList list = this.getWidgets().getConfigRowList();
        for (ConfigRowList.Row row : list.m_6702_()) {
            if (row.tweak != tweak) continue;
            list.setFocusOn(row.controller);
            list.setScrollOn(row);
        }
    }

    private void jumpToContainerFromTweak(TweakClientCache<?> tweak) {
        if (tweak.getEmbed() != null) {
            this.jumpToContainer((Object)tweak.getEmbed().container().getSubcategory().getCategory());
            this.jumpToContainer((Object)tweak.getEmbed().container().getSubcategory());
            this.jumpToContainer((Object)tweak.getEmbed().container());
        } else if (tweak.getSubcategory() != null) {
            this.jumpToContainer((Object)tweak.getSubcategory().container().getCategory());
            this.jumpToContainer((Object)tweak.getSubcategory().container());
        } else if (tweak.getCategory() != null) {
            this.jumpToContainer((Object)tweak.getCategory().container());
        }
    }

    private void jumpToContainer(Object tweakContainer) {
        ConfigRowList list = this.getWidgets().getConfigRowList();
        for (ConfigRowList.Row row : list.m_6702_()) {
            for (AbstractWidget widget : row.children) {
                ContainerButton container;
                if (!(widget instanceof ContainerButton) || (container = (ContainerButton)widget).getId() != tweakContainer) continue;
                if (!container.isExpanded()) {
                    container.silentPress();
                }
                list.setFocusOn((AbstractWidget)container);
                list.setScrollOn(row);
            }
        }
    }

    protected void onCancel() {
        if (!this.isSavable()) {
            this.onClose(true);
            return;
        }
        this.setupCache();
        this.minecraft.m_91152_((Screen)new ConfirmScreen((BooleanConsumer)new CancelConsumer(), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_title"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_body"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_discard"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_cancel")));
    }

    protected void onClose(boolean isCancelled) {
        if (isCancelled) {
            for (TweakClientCache<?> cache : TweakClientCache.all().values()) {
                if (!cache.isSavable()) continue;
                cache.undo();
            }
        }
        this.m_7379_();
    }

    public boolean isSavable() {
        boolean isCacheDifferent = false;
        for (TweakClientCache<?> cache : TweakClientCache.all().values()) {
            if (isCacheDifferent) break;
            if (!cache.isSavable()) continue;
            isCacheDifferent = true;
        }
        return isCacheDifferent;
    }

    private void save() {
        for (TweakClientCache<?> cache : TweakClientCache.all().values()) {
            if (!cache.isSavable()) continue;
            cache.save();
        }
        RunUtil.onSave.forEach(Runnable::run);
        NostalgicTweaks.LOGGER.debug("Ran (%s) onSave functions", RunUtil.onSave.size());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ConfigRowList list = this.getWidgets().getConfigRowList();
        String tabKey = this.configTab.getLangKey();
        String configKey = "text.autoconfig.nostalgic_tweaks.title";
        String title = Component.m_237115_((String)tabKey).getString() + " " + Component.m_237115_((String)configKey).getString();
        if (list.m_6702_().isEmpty()) {
            this.getRenderer().generateAndRender(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.scrollAmountCache > 0.0) {
            list.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.getWidgets().getConfigRowList().m_93410_(this.scrollAmountCache);
            this.scrollAmountCache = 0.0;
        }
        if (this.minecraft.f_91073_ != null) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, 839913488, 0x1000000);
        } else {
            this.m_96626_(0);
        }
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, 0x68000000, 0x68000000);
        list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        for (Button button2 : this.getWidgets().getCategories()) {
            button2.f_93623_ = !Overlay.isOpened();
        }
        switch (this.configTab) {
            case ALL: {
                this.getWidgets().getList().f_93623_ = !Overlay.isOpened();
                break;
            }
            case GENERAL: {
                this.getWidgets().getGeneral().f_93623_ = false;
                break;
            }
            case SOUND: {
                this.getWidgets().getSound().f_93623_ = false;
                break;
            }
            case CANDY: {
                this.getWidgets().getCandy().f_93623_ = false;
                break;
            }
            case GAMEPLAY: {
                this.getWidgets().getGameplay().f_93623_ = false;
                break;
            }
            case ANIMATION: {
                this.getWidgets().getAnimation().f_93623_ = false;
                break;
            }
            case SWING: {
                this.getWidgets().getSwing().f_93623_ = false;
                break;
            }
            case SEARCH: {
                this.getWidgets().getSearch().f_93623_ = false;
            }
        }
        this.getWidgets().getSave().f_93623_ = this.isSavable() && !Overlay.isOpened();
        this.getWidgets().getCancel().f_93623_ = !Overlay.isOpened();
        for (Widget widget : this.getWidgets().children) {
            if (widget instanceof ConfigRowList) continue;
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.configTab != ConfigTab.SEARCH) {
            this.getWidgets().getSearchInput().m_94194_(false);
            ConfigScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)title, (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        } else if (this.getWidgets().focusInput) {
            this.getWidgets().focusSearch();
            this.getWidgets().focusInput = false;
        }
        this.getWidgets().getClear().f_93623_ = this.getWidgets().getSearchInput().m_94155_().length() > 0;
        this.getWidgets().getSearchControls().forEach(button -> {
            button.f_93624_ = this.configTab == ConfigTab.SEARCH;
        });
        this.getWidgets().getSearchInput().m_6305_(poseStack, mouseX, mouseY, partialTick);
        for (Widget widget : this.getWidgets().children) {
            OverlapButton button3;
            if (!(widget instanceof OverlapButton) || !(button3 = (OverlapButton)widget).m_5953_(mouseX, mouseY)) continue;
            button3.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
        this.m_93228_(poseStack, this.getWidgets().getSearch().f_93620_ + 5, this.getWidgets().getSearch().f_93621_ + 4, 0, 15, 12, 12);
        if (!Overlay.isOpened()) {
            this.renderLast.forEach(Runnable::run);
        }
        this.renderLast.clear();
        Overlay.render(poseStack, mouseX, mouseY, partialTick);
        if (ConfigRowList.jumpToContainerId != null) {
            Object object = ConfigRowList.jumpToContainerId;
            if (object instanceof TweakEmbed) {
                TweakEmbed embed = (TweakEmbed)((Object)object);
                this.jumpToContainer((Object)embed.getSubcategory().getCategory());
                this.jumpToContainer((Object)embed.getSubcategory());
                this.jumpToContainer((Object)embed);
            } else {
                object = ConfigRowList.jumpToContainerId;
                if (object instanceof TweakSubcategory) {
                    TweakSubcategory subcategory = (TweakSubcategory)((Object)object);
                    this.jumpToContainer((Object)subcategory.getCategory());
                    this.jumpToContainer((Object)subcategory);
                } else {
                    object = ConfigRowList.jumpToContainerId;
                    if (object instanceof TweakCategory) {
                        TweakCategory category = (TweakCategory)((Object)object);
                        this.jumpToContainer((Object)category);
                    }
                }
            }
            ConfigRowList.jumpToContainerId = null;
        }
        if (ConfigRowList.jumpToTweakId != null && this.configTab == ConfigTab.SEARCH) {
            tweak = TweakClientCache.all().get(ConfigRowList.jumpToTweakId);
            this.getWidgets().getList().m_7435_(Minecraft.m_91087_().m_91106_());
            this.setTabFromGroupKey(tweak.getGroup().getLangKey());
        } else if (ConfigRowList.jumpToTweakId != null) {
            tweak = TweakClientCache.all().get(ConfigRowList.jumpToTweakId);
            this.jumpToContainerFromTweak(tweak);
            this.jumpToTweak(tweak);
            ConfigRowList.jumpToTweakId = null;
            ConfigRowList.overTweakId = null;
        }
        if (NostalgicTweaks.isDebugging()) {
            ConfigScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Debug: \u00a72ON", (int)2, (int)(this.f_96544_ - 10), (int)0xFFFF00);
        }
    }

    public static enum ConfigTab {
        ALL("gui.nostalgic_tweaks.config.all"),
        GENERAL("stat.generalButton"),
        SOUND("text.autoconfig.nostalgic_tweaks.option.sound"),
        CANDY("text.autoconfig.nostalgic_tweaks.option.eyeCandy"),
        GAMEPLAY("text.autoconfig.nostalgic_tweaks.option.gameplay"),
        ANIMATION("text.autoconfig.nostalgic_tweaks.option.animation"),
        SWING("text.autoconfig.nostalgic_tweaks.option.swing"),
        SEARCH("gui.socialInteractions.search_hint");

        private final String langKey;

        private ConfigTab(String langKey) {
            this.langKey = langKey;
        }

        public String getLangKey() {
            return this.langKey;
        }
    }

    private class CancelConsumer
    implements BooleanConsumer {
        private CancelConsumer() {
        }

        public void accept(boolean understood) {
            if (understood) {
                ConfigScreen.this.onClose(true);
                ConfigScreen.this.minecraft.m_91152_(ConfigScreen.this.parentScreen);
            } else {
                ConfigScreen.this.minecraft.m_91152_((Screen)ConfigScreen.this);
                ConfigScreen.this.restoreCache();
            }
        }
    }
}

