/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.gui.overlay.CategoryListOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.button.OverlapButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StateButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StateWidget;
import mod.adrenix.nostalgic.client.config.gui.widget.group.TextGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.reflect.TweakGroup;
import mod.adrenix.nostalgic.common.config.reflect.TweakStatus;
import mod.adrenix.nostalgic.util.common.ArrayUtil;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.relocated.xdrop.fuzzywuzzy.FuzzySearch;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigWidgets {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BOTTOM_OFFSET = 26;
    public static final int WIDTH_PADDING = 8;
    public static final int ROW_LIST_TOP = 46;
    public static final int ROW_LIST_BOTTOM_OFFSET = 32;
    public static final int ROW_ITEM_HEIGHT = 25;
    public static final int INPUT_HEIGHT = 18;
    public static final int INPUT_WIDTH = 196;
    public static final int TOP_ROW = 24;
    public final Set<Widget> children = new HashSet<Widget>();
    public boolean focusInput = false;
    private String lastSearch = "";
    private Button[] categories;
    private EditBox input;
    private Button list;
    private Button general;
    private Button sound;
    private Button candy;
    private Button gameplay;
    private Button animation;
    private Button swing;
    private Button search;
    private Button cancel;
    private Button save;
    private Button clear;
    private StateButton fuzzy;
    private StateButton bubble;
    private StateButton tag;
    private ConfigRowList configRowList;
    private TextGroup swingSpeedPrefix;
    private final ConfigScreen parent;

    public static boolean isOutsideRowList(double mouseY) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return false;
        }
        return mouseY <= 46.0 || mouseY >= (double)(screen.f_96544_ - 32);
    }

    public static boolean isInsideRowList(double mouseY) {
        return !ConfigWidgets.isOutsideRowList(mouseY);
    }

    public Button[] getCategories() {
        return this.categories;
    }

    public Button getList() {
        return this.list;
    }

    public Button getGeneral() {
        return this.general;
    }

    public Button getSound() {
        return this.sound;
    }

    public Button getCandy() {
        return this.candy;
    }

    public Button getGameplay() {
        return this.gameplay;
    }

    public Button getAnimation() {
        return this.animation;
    }

    public Button getSwing() {
        return this.swing;
    }

    public Button getSearch() {
        return this.search;
    }

    public Button getSave() {
        return this.save;
    }

    public Button getCancel() {
        return this.cancel;
    }

    public Button getClear() {
        return this.clear;
    }

    public EditBox getSearchInput() {
        return this.input;
    }

    public TextGroup getSwingSpeedPrefix() {
        return this.swingSpeedPrefix;
    }

    public StateButton getFuzzy() {
        return this.fuzzy;
    }

    public StateButton getBubble() {
        return this.bubble;
    }

    public ConfigRowList getConfigRowList() {
        return this.configRowList;
    }

    public ConfigWidgets(ConfigScreen parent) {
        this.parent = parent;
    }

    public void generate() {
        this.configRowList = this.generateConfigRowList();
        this.swingSpeedPrefix = this.generateSwingSpeedPrefix();
        this.list = this.generateListButton();
        this.general = this.generateGeneralButton();
        this.sound = this.generateSoundButton();
        this.candy = this.generateCandyButton();
        this.gameplay = this.generateGameplayButton();
        this.animation = this.generateAnimationButton();
        this.swing = this.generateSwingButton();
        this.search = this.generateSearchButton();
        this.cancel = this.generateCancelButton();
        this.save = this.generateSaveButton();
        this.input = this.generateInputBox();
        this.input.m_94199_(35);
        this.input.m_94182_(true);
        this.input.m_94194_(false);
        this.input.m_94202_(0xFFFFFF);
        this.input.m_94144_(this.input.m_94155_());
        this.input.m_94151_(this::runSearch);
        this.clear = this.generateClearButton();
        this.tag = this.generateTagButton();
        this.fuzzy = this.generateFuzzyState();
        this.bubble = this.generateBubbleState();
        this.children.add((Widget)this.input);
        this.children.add((Widget)this.configRowList);
        int gap = 0;
        int width = 0;
        this.categories = new Button[]{this.list, this.general, this.sound, this.candy, this.gameplay, this.animation, this.swing, this.search};
        Button[] exits = new Button[]{this.cancel, this.save};
        List<Button> search = this.getSearchControls();
        this.children.addAll(List.of(this.categories));
        this.children.addAll(List.of(exits));
        this.children.addAll(search);
        for (Widget widget : this.children) {
            this.parent.m_142416_((GuiEventListener)((NarratableEntry)widget));
        }
        for (Button button : this.categories) {
            width += button.m_5711_() + gap;
        }
        for (Button button : search) {
            button.f_93624_ = false;
        }
        int prevX = this.parent.f_96543_ / 2 - (width - gap) / 2;
        for (Button button : this.categories) {
            button.f_93620_ = prevX;
            prevX = button.f_93620_ + button.m_5711_() - 1;
        }
        boolean isOddChecked = this.general.f_93620_ % 2 != 0;
        for (int i = 0; i < this.categories.length; ++i) {
            Button first = ArrayUtil.get(this.categories, i);
            Button second = ArrayUtil.get(this.categories, i + 1);
            boolean adjust = false;
            if (first == null || second == null) break;
            if (isOddChecked ? first.f_93620_ % 2 != 0 && second.f_93620_ % 2 != 0 : first.f_93620_ % 2 == 0 && second.f_93620_ % 2 == 0) {
                adjust = true;
                boolean bl = isOddChecked = !isOddChecked;
            }
            if (!adjust) continue;
            --second.f_93620_;
            if (ArrayUtil.get(this.categories, i + 2) == null) continue;
            for (int j = i + 2; j < this.categories.length; ++j) {
                --this.categories[j].f_93620_;
            }
        }
    }

    public List<Button> getSearchControls() {
        return List.of(this.fuzzy, this.bubble, this.tag, this.clear);
    }

    private ConfigRowList generateConfigRowList() {
        return new ConfigRowList(this.parent, this.parent.f_96543_, this.parent.f_96544_, 46, this.parent.f_96544_ - 32, 25);
    }

    private Button generateListButton() {
        Button.OnPress action = button -> {
            this.parent.setConfigTab(ConfigScreen.ConfigTab.ALL);
            new CategoryListOverlay();
        };
        return new OverlapButton((Component)Component.m_237119_(), action).setAsList();
    }

    private Button generateGeneralButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.GENERAL.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.GENERAL));
    }

    private Button generateSoundButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.SOUND.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.SOUND));
    }

    private Button generateCandyButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.CANDY.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.CANDY));
    }

    private Button generateGameplayButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.GAMEPLAY.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.GAMEPLAY));
    }

    private Button generateAnimationButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.ANIMATION.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.ANIMATION));
    }

    private Button generateSwingButton() {
        return new OverlapButton((Component)Component.m_237115_((String)ConfigScreen.ConfigTab.SWING.getLangKey()), button -> this.parent.setConfigTab(ConfigScreen.ConfigTab.SWING));
    }

    private Button generateSearchButton() {
        MutableComponent translation = Component.m_237115_((String)ConfigScreen.ConfigTab.SEARCH.getLangKey());
        MutableComponent title = Component.m_237113_((String)("    " + translation.getString()));
        Button.OnPress action = button -> {
            this.parent.setConfigTab(ConfigScreen.ConfigTab.SEARCH);
            this.focusInput = true;
        };
        return new OverlapButton((Component)title, action);
    }

    private Button generateCancelButton() {
        return new Button(this.parent.f_96543_ / 2 - this.getSmallWidth() - 3, this.parent.f_96544_ - 26, this.getSmallWidth(), 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> this.parent.onCancel());
    }

    private Button generateSaveButton() {
        return new Button(this.parent.f_96543_ / 2 + 3, this.parent.f_96544_ - 26, this.getSmallWidth(), 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.button.save_and_done"), button -> this.parent.onClose(false));
    }

    private int getSmallWidth() {
        return Math.min(200, (this.parent.f_96543_ - 50 - 12) / 3);
    }

    private EditBox generateInputBox() {
        int startX = this.parent.f_96543_ / 2 - 98;
        MutableComponent title = Component.m_237115_((String)"gui.socialInteractions.search_hint").m_130940_(ChatFormatting.ITALIC);
        return new EditBox(this.parent.getFont(), startX, 3, 196, 18, (Component)title);
    }

    private TextGroup generateSwingSpeedPrefix() {
        return new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.config.speed.@PrefixText"));
    }

    private StateButton generateBubbleState() {
        EditBox search = this.getSearchInput();
        return new StateButton(StateWidget.BUBBLE, search.f_93620_ - 61, search.f_93621_ - 1, false, button -> {
            this.runSearch(search.m_94155_());
            this.focusSearch();
            this.configRowList.resetScrollbar();
        });
    }

    private StateButton generateFuzzyState() {
        EditBox search = this.getSearchInput();
        return new StateButton(StateWidget.FUZZY, search.f_93620_ - 42, search.f_93621_ - 1, button -> {
            this.runSearch(search.m_94155_());
            this.focusSearch();
            this.configRowList.resetScrollbar();
        });
    }

    private StateButton generateTagButton() {
        EditBox search = this.getSearchInput();
        return new StateButton(StateWidget.TAG, search.f_93620_ - 23, search.f_93621_ - 1, button -> {
            ConfigWidgets.setTagCycle(search);
            this.focusSearch();
            this.configRowList.resetScrollbar();
        });
    }

    private StateButton generateClearButton() {
        EditBox search = this.getSearchInput();
        return new StateButton(StateWidget.CLEAR, search.f_93620_ + search.m_5711_() + 3, search.f_93621_ - 1, button -> {
            search.m_94144_("");
            this.focusSearch();
            this.configRowList.resetScrollbar();
        });
    }

    private static void setTagCycle(EditBox search) {
        StringBuilder query = new StringBuilder();
        String[] words = search.m_94155_().split(" ");
        String atTag = ArrayUtil.get(words, 0);
        for (String word : words) {
            if (word.contains("#")) continue;
            query.append(" ").append(word);
        }
        if (atTag == null || !atTag.startsWith("#")) {
            search.m_94144_(String.format("#%s %s", new Object[]{SearchTag.CLIENT, query}).replaceAll(" +", " "));
        } else {
            SearchTag[] searchTags = SearchTag.values();
            SearchTag found = null;
            SearchTag next = null;
            for (int i = 0; i < searchTags.length; ++i) {
                SearchTag tag = searchTags[i];
                if (atTag.replace("#", "").equals(tag.toString())) {
                    found = tag;
                }
                if (found == null) continue;
                if (Screen.m_96638_()) {
                    if (ArrayUtil.get(searchTags, i - 1) != null) {
                        next = searchTags[i - 1];
                        break;
                    }
                    next = searchTags[searchTags.length - 1];
                    break;
                }
                if (ArrayUtil.get(searchTags, i + 1) != null) {
                    next = searchTags[i + 1];
                    break;
                }
                next = searchTags[0];
                break;
            }
            if (next == null) {
                next = SearchTag.CLIENT;
            }
            search.m_94144_(("#" + next + " " + query).replaceAll(" +", " "));
        }
    }

    private String[] getRelatedWords(TweakClientCache<?> tweak) {
        return Component.m_237115_((String)tweak.getRelatedKey()).getString().toLowerCase().trim().split(" *, *");
    }

    private boolean areWordsUnrelated(String[] words) {
        return words.length == 0 || words[0].contains(".@Related".toLowerCase());
    }

    private boolean isRelatedExact(TweakClientCache<?> tweak, String query) {
        String[] words = this.getRelatedWords(tweak);
        if (this.areWordsUnrelated(words)) {
            return false;
        }
        for (String word : words) {
            if (!query.contains(word)) continue;
            return true;
        }
        return false;
    }

    private int isRelatedFuzzy(TweakClientCache<?> tweak, String query) {
        String[] words = this.getRelatedWords(tweak);
        int largestWeight = 0;
        if (this.areWordsUnrelated(words)) {
            return 0;
        }
        for (String word : words) {
            int weight = FuzzySearch.weightedRatio(word, query);
            if (weight <= largestWeight) continue;
            largestWeight = weight;
        }
        return largestWeight;
    }

    public void focusSearch() {
        this.getSearchInput().m_94194_(true);
        this.getSearchInput().m_94178_(true);
        this.getSearchInput().m_94186_(true);
    }

    public void runSearch(String search) {
        if (this.lastSearch.equals(search)) {
            return;
        }
        this.lastSearch = search;
        this.getConfigRowList().resetScrollbar();
        this.getConfigRowList().m_6702_().clear();
        this.parent.search.clear();
        if (search.isBlank() || search.equals("#")) {
            return;
        }
        search = search.toLowerCase();
        HashMap<String, TweakClientCache<?>> entries = TweakClientCache.all();
        StringBuilder searchBuilder = new StringBuilder();
        String[] words = search.split(" ");
        String atTag = ArrayUtil.get(words, 0);
        String requestedTag = atTag != null ? atTag.replace("#", "").toLowerCase() : "";
        String tag = null;
        for (String string : words) {
            if (string.contains("#")) continue;
            searchBuilder.append(" ").append(string);
        }
        for (String string : SearchTag.values()) {
            if (!requestedTag.equals(((SearchTag)((Object)string)).toString())) continue;
            tag = string;
        }
        for (TweakClientCache tweakClientCache : entries.values()) {
            boolean isValidResult;
            tweakClientCache.setWeight(0);
            if (TweakGroup.isManual(tweakClientCache.getGroup())) continue;
            boolean isTagged = false;
            if (tag != null) {
                switch (1.$SwitchMap$mod$adrenix$nostalgic$client$config$gui$screen$config$ConfigWidgets$SearchTag[((Enum)((Object)tag)).ordinal()]) {
                    case 1: {
                        isTagged = true;
                        break;
                    }
                    case 2: {
                        isTagged = tweakClientCache.isNew();
                        break;
                    }
                    case 3: {
                        isTagged = tweakClientCache.isClient();
                        break;
                    }
                    case 4: {
                        isTagged = tweakClientCache.isServer() || tweakClientCache.isDynamic();
                        break;
                    }
                    case 5: {
                        isTagged = tweakClientCache.getStatus() != TweakStatus.LOADED;
                        break;
                    }
                    case 6: {
                        isTagged = tweakClientCache.isResettable() && tweakClientCache.getList() == null;
                        break;
                    }
                    case 7: {
                        isTagged = tweakClientCache.isSavable();
                    }
                }
            }
            if (isTagged && searchBuilder.isEmpty()) {
                this.parent.search.put(tweakClientCache.getId(), tweakClientCache);
            }
            if (!isTagged && tag != null || !isTagged && search.contains("#")) continue;
            String string = searchBuilder.toString().replaceAll(" +", " ").trim().toLowerCase();
            if (this.getFuzzy().getState()) {
                int title = FuzzySearch.weightedRatio(tweakClientCache.getTranslation().toLowerCase(), string);
                int bubble = FuzzySearch.weightedRatio(tweakClientCache.getTooltipTranslation().toLowerCase(), string);
                int container = FuzzySearch.weightedRatio(tweakClientCache.getContainerTranslation().toLowerCase(), string);
                int related = this.isRelatedFuzzy(tweakClientCache, string);
                if (!this.getBubble().getState()) {
                    bubble = 0;
                }
                tweakClientCache.setWeight(MathUtil.getLargest(title, bubble, container, related));
                if (tweakClientCache.getWeight() <= 0) continue;
                this.parent.search.put(tweakClientCache.getId(), tweakClientCache);
                continue;
            }
            boolean isInBubble = tweakClientCache.getTooltipTranslation().toLowerCase().contains(string);
            boolean isBubbleOn = this.getBubble().getState();
            boolean isRelatedWord = this.isRelatedExact(tweakClientCache, string);
            boolean isInContainer = tweakClientCache.getContainerTranslation().toLowerCase().contains(string);
            boolean bl = isValidResult = isInContainer || isRelatedWord || isBubbleOn && isInBubble;
            if (!tweakClientCache.getTranslation().toLowerCase().contains(string) && !isValidResult) continue;
            this.parent.search.put(tweakClientCache.getId(), tweakClientCache);
        }
    }

    public static enum SearchTag {
        CLIENT,
        SERVER,
        CONFLICT,
        RESET,
        NEW,
        SAVE,
        ALL;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

