/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.list;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowKey;
import mod.adrenix.nostalgic.common.config.list.ListMap;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class ListMapScreen<V>
extends ListScreen {
    private final ArrayList<Map.Entry<String, V>> deletedEntries = new ArrayList();
    private final ListMap<V> listMap;
    private final Map<String, V> defaultMap;
    private final Map<String, V> configMap;
    private final Map<String, V> cacheMap;
    private final Map<String, V> undoMap;
    private final V resetValue;

    public ListMapScreen(Component title, ListMap<V> listMap) {
        super(title, listMap);
        this.listMap = listMap;
        this.resetValue = listMap.getResetValue();
        this.defaultMap = listMap.getDefaultMap();
        this.configMap = listMap.getConfigMap();
        this.cacheMap = Maps.newHashMap(this.configMap);
        this.undoMap = Maps.newHashMap(this.configMap);
        this.sortConfig();
    }

    private void sortConfig() {
        this.sortEntries(this.configMap.entrySet(), this::getResourceKey, this::configPutAll, this.configMap::clear);
        this.sortEntries(this.defaultMap.entrySet(), this::getResourceKey, this::defaultPutAll, this.defaultMap::clear);
    }

    private void configPutAll(Set<Map.Entry<String, V>> sorted) {
        for (Map.Entry<String, V> entry : sorted) {
            this.configMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void defaultPutAll(Set<Map.Entry<String, V>> sorted) {
        for (Map.Entry<String, V> entry : sorted) {
            this.defaultMap.put(entry.getKey(), entry.getValue());
        }
    }

    public ListMap<V> getListMap() {
        return this.listMap;
    }

    public ArrayList<Map.Entry<String, V>> getDeletedEntries() {
        return this.deletedEntries;
    }

    public V getCachedValue(Map.Entry<String, V> entry) {
        return this.cacheMap.get(entry.getKey());
    }

    public void delete(Map.Entry<String, V> entry) {
        this.deletedEntries.add(entry);
    }

    public void undo(Map.Entry<String, V> entry) {
        this.deletedEntries.remove(entry);
    }

    public boolean isDeleted(Map.Entry<String, V> entry) {
        return this.deletedEntries.contains(entry);
    }

    @Override
    public void deleteItem(Item item) {
        for (Map.Entry<String, V> entry : this.configMap.entrySet()) {
            if (!entry.getKey().equals(ItemCommonUtil.getResourceKey(item))) continue;
            this.delete(entry);
            break;
        }
    }

    @Override
    public void clearAllSaved() {
        for (Map.Entry<String, V> entry : this.configMap.entrySet()) {
            if (this.deletedEntries.contains(entry)) continue;
            this.delete(entry);
        }
    }

    @Override
    public boolean isItemDeleted(Item item) {
        for (Map.Entry<String, V> entry : this.deletedEntries) {
            if (!ItemCommonUtil.getResourceKey(item).equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addItem(Item item) {
        if (this.isItemSaved(item) || !this.isItemEligible(item)) {
            return;
        }
        this.configMap.put(ItemCommonUtil.getResourceKey(item), this.resetValue);
        this.cacheMap.put(ItemCommonUtil.getResourceKey(item), this.resetValue);
        this.sortConfig();
    }

    @Override
    public boolean isItemAdded(Item item) {
        return !this.undoMap.containsKey(ItemCommonUtil.getResourceKey(item));
    }

    @Override
    public boolean isItemSaved(Item item) {
        for (Map.Entry<String, V> entry : this.configMap.entrySet()) {
            if (!entry.getKey().equals(ItemCommonUtil.getResourceKey(item))) continue;
            return true;
        }
        return false;
    }

    private String getResourceKey(Map.Entry<String, V> entry) {
        return entry.getKey();
    }

    private void addSavedRow(ArrayList<ConfigRowList.Row> rows, Map.Entry<String, V> entry) {
        rows.add(this.getConfigRowList().rowFromEntry(this.listMap, entry, this.resetValue));
    }

    private void addDefaultRow(ArrayList<ConfigRowList.Row> rows, Map.Entry<String, V> entry) {
        rows.add(new ConfigRowKey.DefaultRow(entry.getKey()).generate());
    }

    @Override
    protected ArrayList<ConfigRowList.Row> getSavedRows() {
        String langKey = "gui.nostalgic_tweaks.list.no_saved_items";
        return this.getSearchedItems(langKey, this.configMap.entrySet(), this::getResourceKey, this::addSavedRow);
    }

    @Override
    protected ArrayList<ConfigRowList.Row> getDefaultRows() {
        String langKey = "gui.nostalgic_tweaks.list.no_default_items";
        return this.getSearchedItems(langKey, this.defaultMap.entrySet(), this::getResourceKey, this::addDefaultRow);
    }

    @Override
    protected int getDefaultCount() {
        return this.defaultMap.size();
    }

    @Override
    public void disableAllDefaults() {
        for (Map.Entry<String, V> entry : this.defaultMap.entrySet()) {
            this.disabledDefaults.add(entry.getKey());
        }
    }

    @Override
    public void enableAllDefaults() {
        for (Map.Entry<String, V> entry : this.defaultMap.entrySet()) {
            this.disabledDefaults.remove(entry.getKey());
        }
    }

    @Override
    protected boolean isListSavable() {
        if (this.undoMap.size() != this.configMap.size()) {
            return true;
        }
        if (this.undoDisabledDefaults.size() != this.disabledDefaults.size()) {
            return true;
        }
        if (this.deletedEntries.size() > 0) {
            return true;
        }
        for (Map.Entry<String, V> entry : this.configMap.entrySet()) {
            if (this.undoMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void closeList(boolean isCancelled) {
        if (!isCancelled) {
            for (Map.Entry<String, V> entry : this.deletedEntries) {
                this.configMap.remove(entry.getKey());
            }
        } else {
            this.configMap.clear();
            this.configMap.putAll(this.undoMap);
            this.disabledDefaults.clear();
            this.disabledDefaults.addAll(this.undoDisabledDefaults);
        }
        this.cacheMap.clear();
        this.deletedEntries.clear();
        this.getMinecraft().m_91152_(this.parentScreen);
        Screen screen = this.parentScreen;
        if (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.restoreCache();
        }
    }
}

