/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.list;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfig;
import mod.adrenix.nostalgic.client.config.gui.overlay.DefaultEntriesOverlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.FilterListOverlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.NukeListOverlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.PermissionLostOverlay;
import mod.adrenix.nostalgic.client.config.gui.overlay.SpeedOverlay;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ContainerId;
import mod.adrenix.nostalgic.client.config.gui.widget.button.ControlButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.OverlapButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StateButton;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StateWidget;
import mod.adrenix.nostalgic.client.config.gui.widget.group.ItemGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.group.TextGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowBuild;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowGroup;
import mod.adrenix.nostalgic.client.config.gui.widget.text.TextAlign;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.auto.AutoConfig;
import mod.adrenix.nostalgic.common.config.list.AbstractList;
import mod.adrenix.nostalgic.common.config.list.ListFilter;
import mod.adrenix.nostalgic.common.config.list.ListId;
import mod.adrenix.nostalgic.common.config.list.ListInclude;
import mod.adrenix.nostalgic.mixin.duck.MaxSizeChanger;
import mod.adrenix.nostalgic.network.packet.PacketC2SChangeTweak;
import mod.adrenix.nostalgic.server.config.reflect.TweakServerCache;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.client.NetUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import mod.adrenix.nostalgic.util.common.PacketUtil;
import mod.adrenix.nostalgic.util.common.function.TriConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public abstract class ListScreen
extends ConfigScreen {
    public final ArrayList<TriConsumer<PoseStack, Integer, Integer>> renderOverlayTooltips = new ArrayList();
    protected final Set<ListFilter> filters = new HashSet<ListFilter>();
    protected final ListInclude onlyInclude;
    protected final ListId listId;
    protected final AbstractList list;
    protected final Screen parentScreen;
    protected final Set<String> disabledDefaults;
    protected final Set<String> undoDisabledDefaults;
    private final Minecraft minecraft;
    private final NonNullList<ItemStack> allItems;
    private final NonNullList<ItemStack> selectableItems;
    private final Set<Widget> listWidgets;
    private WidgetProvider widgetProvider;
    private ItemStack highlightItem;
    private double scrollAmountCache;
    private boolean permissionWatch = false;

    public ListScreen(Component title, AbstractList list) {
        super(Minecraft.m_91087_().f_91080_, title);
        this.list = list;
        this.listId = list.getId();
        this.onlyInclude = list.getInclude();
        this.disabledDefaults = list.getDisabledDefaults();
        this.undoDisabledDefaults = Sets.newHashSet(list.getDisabledDefaults());
        this.parentScreen = Minecraft.m_91087_().f_91080_;
        this.minecraft = Minecraft.m_91087_();
        this.allItems = NonNullList.m_122779_();
        this.selectableItems = NonNullList.m_122779_();
        this.listWidgets = new HashSet<Widget>();
        this.highlightItem = null;
        this.scrollAmountCache = 0.0;
        this.updateItemTags();
        if (TweakClientCache.get(list.getTweak()).isServer()) {
            this.watchPermissions();
        }
    }

    public void watchPermissions() {
        this.permissionWatch = true;
    }

    public boolean isPermissionWatched() {
        return this.permissionWatch;
    }

    private void updateItemTags() {
        for (Item item : Registry.f_122827_) {
            item.m_6787_(CreativeModeTab.f_40754_, this.allItems);
        }
        if (this.minecraft.f_91073_ == null) {
            this.minecraft.m_231374_(SearchRegistry.f_119941_, this.allItems);
            this.minecraft.m_231374_(SearchRegistry.f_119942_, this.allItems);
        }
        switch (this.onlyInclude) {
            case ALL: {
                this.filters.add(ListFilter.NONE);
                break;
            }
            case NO_TOOLS: {
                this.filters.add(ListFilter.TOOLS);
                break;
            }
            case NO_ITEMS: {
                this.filters.add(ListFilter.ITEMS);
                break;
            }
            case NO_BLOCKS: {
                this.filters.add(ListFilter.BLOCKS);
                break;
            }
            case ONLY_TOOLS: {
                this.filters.addAll(Set.of(ListFilter.BLOCKS, ListFilter.ITEMS));
                break;
            }
            case ONLY_ITEMS: {
                this.filters.addAll(Set.of(ListFilter.BLOCKS, ListFilter.TOOLS));
                break;
            }
            case ONLY_BLOCKS: {
                this.filters.addAll(Set.of(ListFilter.ITEMS, ListFilter.TOOLS));
                break;
            }
            case ONLY_EDIBLE: {
                this.filters.addAll(Set.of(ListFilter.ITEMS, ListFilter.TOOLS, ListFilter.BLOCKS));
            }
        }
        this.filterItems(this.allItems);
    }

    protected abstract void closeList(boolean var1);

    protected abstract boolean isListSavable();

    protected abstract ArrayList<ConfigRowList.Row> getSavedRows();

    protected abstract ArrayList<ConfigRowList.Row> getDefaultRows();

    protected abstract int getDefaultCount();

    public abstract void disableAllDefaults();

    public abstract void enableAllDefaults();

    public abstract void addItem(Item var1);

    public abstract void deleteItem(Item var1);

    public abstract void clearAllSaved();

    public abstract boolean isItemSaved(Item var1);

    public abstract boolean isItemAdded(Item var1);

    public abstract boolean isItemDeleted(Item var1);

    public void addItem(ItemStack item) {
        this.addItem(item.m_41720_());
    }

    public void deleteItem(ItemStack itemStack) {
        this.deleteItem(itemStack.m_41720_());
    }

    public boolean isItemSaved(ItemStack itemStack) {
        return this.isItemSaved(itemStack.m_41720_());
    }

    public boolean isItemAdded(ItemStack itemStack) {
        return this.isItemAdded(itemStack.m_41720_());
    }

    public boolean isItemDeleted(ItemStack itemStack) {
        return this.isItemDeleted(itemStack.m_41720_());
    }

    public EditBox getSearchBox() {
        return this.widgetProvider.searchBox;
    }

    public ConfigRowList getConfigRowList() {
        return this.getWidgets().getConfigRowList();
    }

    public NonNullList<ItemStack> getSelectableItems() {
        return this.selectableItems;
    }

    public Set<Widget> getListWidgets() {
        return this.listWidgets;
    }

    public Set<ListFilter> getFilters() {
        return this.filters;
    }

    public ListId getListId() {
        return this.listId;
    }

    public void disableDefaultItem(String resourceKey) {
        this.disabledDefaults.add(resourceKey);
    }

    public void enableDefaultItem(String resourceKey) {
        this.disabledDefaults.remove(resourceKey);
    }

    public boolean isDefaultItemDisabled(String resourceKey) {
        return this.disabledDefaults.contains(resourceKey);
    }

    public boolean isItemEligible(Item item) {
        String resourceKey = ItemCommonUtil.getResourceKey(item);
        for (ItemStack compareItem : this.allItems) {
            if (!ItemCommonUtil.getResourceKey(compareItem.m_41720_()).equals(resourceKey)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemEligible(ItemStack itemStack) {
        return this.isItemEligible(itemStack.m_41720_());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Screen screen = this.parentScreen;
        if (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.setupCache();
        }
        this.m_169413_();
        this.listWidgets.clear();
        this.m_142416_(this.getConfigRowList());
        this.widgetProvider = new WidgetProvider();
        this.getSearchBox().m_94199_(50);
        this.getSearchBox().m_94182_(true);
        this.getSearchBox().m_94194_(true);
        this.getSearchBox().m_94202_(0xFFFFFF);
        this.m_94718_((GuiEventListener)this.getSearchBox());
        this.refreshSearchResults();
        ContainerButton.expand(ContainerId.LIST_HELP);
        ContainerButton.expand(ContainerId.DEFAULT_ITEMS);
        ContainerButton.expand(ContainerId.SAVED_ITEMS);
        ContainerButton.expand(ContainerId.SELECTABLE_ITEMS);
        this.listWidgets.forEach(child -> {
            if (child instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)child;
                this.m_142416_(widget);
            }
        });
    }

    public void highlightItem(ItemStack itemStack) {
        this.refreshSearchResults();
        ContainerButton.expand(ContainerId.SAVED_ITEMS);
        ContainerButton.expand(ContainerId.SELECTABLE_ITEMS);
        this.highlightItem = itemStack;
    }

    private int getLocalizedItem(String firstKey, String secondKey) {
        String firstItem = ItemCommonUtil.getLocalizedItem(firstKey);
        String secondItem = ItemCommonUtil.getLocalizedItem(secondKey);
        return firstItem.compareToIgnoreCase(secondItem);
    }

    protected <T> void sortEntries(Set<T> entrySet, Function<T, String> resourceKey, Consumer<Set<T>> sortedConsumer, Runnable listClear) {
        ArrayList<T> list = new ArrayList<T>(entrySet);
        LinkedHashSet unknowns = new LinkedHashSet();
        for (Object entry : list) {
            if (ItemCommonUtil.isValidKey(resourceKey.apply(entry))) continue;
            unknowns.add(entry);
        }
        for (Object entry : unknowns) {
            list.remove(entry);
        }
        list.sort((firstKey, secondKey) -> this.getLocalizedItem((String)resourceKey.apply(firstKey), (String)resourceKey.apply(secondKey)));
        listClear.run();
        sortedConsumer.accept(unknowns);
        sortedConsumer.accept(new LinkedHashSet<T>(list));
    }

    protected <T> ArrayList<ConfigRowList.Row> getSearchedItems(String langKey, Set<T> entrySet, Function<T, String> resourceKey, BiConsumer<ArrayList<ConfigRowList.Row>, T> addRow) {
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        String query = this.getSearchBox().m_94155_();
        if (query.isEmpty()) {
            for (Iterator<T> entry : entrySet) {
                addRow.accept(rows, (ArrayList<ConfigRowList.Row>)((Object)entry));
            }
        } else {
            NonNullList allItems = NonNullList.m_122779_();
            for (T entry : entrySet) {
                if (!ItemCommonUtil.isValidKey(resourceKey.apply(entry))) continue;
                allItems.add((Object)ItemCommonUtil.getItemStack(resourceKey.apply(entry)));
            }
            this.addSearchedItems((NonNullList<ItemStack>)allItems);
            block2: for (T entry : entrySet) {
                for (ItemStack itemStack : allItems) {
                    if (!ItemCommonUtil.getResourceKey(itemStack.m_41720_()).equals(resourceKey.apply(entry))) continue;
                    addRow.accept(rows, (ArrayList<ConfigRowList.Row>)entry);
                    continue block2;
                }
            }
        }
        if (rows.size() == 0) {
            MutableComponent translate = Component.m_237115_((String)langKey);
            MutableComponent text = Component.m_237113_((String)(ChatFormatting.RED + translate.getString()));
            rows.addAll(new TextGroup((Component)text, TextAlign.CENTER).generate());
        }
        return rows;
    }

    protected void addSearchedItems(NonNullList<ItemStack> itemList) {
        itemList.clear();
        String query = this.getSearchBox().m_94155_();
        if (query.isEmpty()) {
            for (Item item : Registry.f_122827_) {
                item.m_6787_(CreativeModeTab.f_40754_, itemList);
            }
        } else {
            SearchTree searchTree;
            if (query.startsWith("#")) {
                query = query.substring(1);
                searchTree = this.minecraft.m_231372_(SearchRegistry.f_119942_);
            } else {
                searchTree = this.minecraft.m_231372_(SearchRegistry.f_119941_);
            }
            itemList.addAll((Collection)searchTree.m_6293_(query.toLowerCase(Locale.ROOT)));
        }
        this.filterItems(itemList);
    }

    public void refreshSearchResults() {
        this.resetRowList();
        this.addSearchedItems(this.selectableItems);
        this.generateContainers();
    }

    public void manageFilter(ListFilter filter, boolean state) {
        this.filters.remove((Object)ListFilter.NONE);
        if (state) {
            this.filters.add(filter);
        } else {
            this.filters.remove((Object)filter);
        }
        if (this.filters.size() == 0) {
            this.filters.add(ListFilter.NONE);
        }
    }

    private void filterItems(NonNullList<ItemStack> allItems) {
        ArrayList<ItemStack> filteredItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : allItems) {
            boolean isBlocksFiltered;
            boolean isSizeExceeded;
            MaxSizeChanger injector = (MaxSizeChanger)itemStack.m_41720_();
            ItemStack copyStack = ItemCommonUtil.getItemStack(ItemCommonUtil.getResourceKey(itemStack.m_41720_()));
            boolean isUniqueItem = itemStack.m_41783_() != null && !itemStack.m_41783_().equals((Object)copyStack.m_41783_());
            boolean bl = isSizeExceeded = injector.NT$getOriginalSize() == 1.0f && this.listId == ListId.CUSTOM_ITEM_STACKING;
            if (isUniqueItem || isSizeExceeded) {
                filteredItems.add(itemStack);
                continue;
            }
            if (this.filters.contains((Object)ListFilter.NONE)) continue;
            Item item = itemStack.m_41720_();
            boolean isEdible = item.m_41472_();
            boolean isTool = item instanceof DiggerItem || item instanceof SwordItem;
            boolean isBlock = item instanceof BlockItem;
            boolean isItem = !isTool && !isBlock;
            boolean isItemsFiltered = isItem && this.filters.contains((Object)ListFilter.ITEMS);
            boolean isToolsFiltered = isTool && this.filters.contains((Object)ListFilter.TOOLS);
            boolean bl2 = isBlocksFiltered = isBlock && this.filters.contains((Object)ListFilter.BLOCKS);
            if (this.onlyInclude == ListInclude.ONLY_EDIBLE) {
                if (isEdible) continue;
                filteredItems.add(itemStack);
                continue;
            }
            if (!isItemsFiltered && !isToolsFiltered && !isBlocksFiltered) continue;
            filteredItems.add(itemStack);
        }
        for (ItemStack itemStack : filteredItems) {
            allItems.remove((Object)itemStack);
        }
    }

    private void generateContainers() {
        ConfigRowGroup.ContainerRow tutorial = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.list.help_title"), this::getTutorialRows, ContainerId.LIST_HELP);
        ConfigRowGroup.ContainerRow savedItems = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.list.saved_items"), this::getSavedRows, ContainerId.SAVED_ITEMS);
        ConfigRowGroup.ContainerRow defaultItems = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.list.default_items"), this::getRowsForDefaultItems, ContainerId.DEFAULT_ITEMS);
        ConfigRowGroup.ContainerRow selectableItems = new ConfigRowGroup.ContainerRow((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.list.selectable_items"), this::getRowsFromSelectableItems, ContainerId.SELECTABLE_ITEMS);
        this.getConfigRowList().addRow(tutorial.generate());
        this.getConfigRowList().addRow(savedItems.generate());
        if (this.getDefaultCount() > 0) {
            this.getConfigRowList().addRow(defaultItems.generate());
        }
        this.getConfigRowList().addRow(selectableItems.generate());
    }

    private ArrayList<ConfigRowList.Row> getTutorialRows() {
        return new TextGroup((Component)Component.m_237115_((String)"gui.nostalgic_tweaks.list.tutorial")).generate();
    }

    private ArrayList<ConfigRowList.Row> getRowsForDefaultItems() {
        MutableComponent title = Component.m_237115_((String)"gui.nostalgic_tweaks.button.manage_defaults");
        ControlButton button = new ControlButton((Component)title, this::manageDefaults);
        ConfigRowList.Row manager = new ConfigRowBuild.SingleCenteredRow((AbstractWidget)button).generate();
        ArrayList<ConfigRowList.Row> rows = new ArrayList<ConfigRowList.Row>();
        if (this.getSearchBox().m_94155_().isEmpty()) {
            rows.add(manager);
        }
        rows.addAll(this.getDefaultRows());
        return rows;
    }

    private ArrayList<ConfigRowList.Row> getRowsFromSelectableItems() {
        return new ItemGroup(this).generate();
    }

    private void manageDefaults(Button button) {
        new DefaultEntriesOverlay();
    }

    public void jumpToEntry(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        for (ConfigRowList.Row row : this.getConfigRowList().m_6702_()) {
            if (!row.getResourceKey().equals(ItemCommonUtil.getResourceKey(itemStack.m_41720_()))) continue;
            this.getConfigRowList().setScrollOn(row);
            break;
        }
        if (this.highlightItem == itemStack) {
            this.highlightItem = null;
        }
    }

    @Override
    public void m_86600_() {
        this.getSearchBox().m_94120_();
    }

    @Override
    public void m_6574_(Minecraft minecraft, int width, int height) {
        String query = this.getSearchBox().m_94155_();
        this.scrollAmountCache = this.getConfigRowList().m_93517_();
        this.m_6575_(minecraft, width, height);
        this.getSearchBox().m_94144_(query);
        if (!query.isEmpty()) {
            this.refreshSearchResults();
            ContainerButton.collapse(ContainerId.LIST_HELP);
        }
        if (Overlay.isOpened()) {
            this.getSearchBox().m_94178_(false);
        }
        Overlay.resize();
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        String query = this.getSearchBox().m_94155_();
        if (this.getSearchBox().m_5534_(codePoint, modifiers)) {
            if (!this.getSearchBox().m_94155_().equals(query)) {
                this.refreshSearchResults();
                ContainerButton.collapse(ContainerId.LIST_HELP);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean isEsc;
        String query = this.getSearchBox().m_94155_();
        boolean bl = isEsc = keyCode == 256;
        if (Overlay.getVisible() instanceof PermissionLostOverlay) {
            return false;
        }
        if (Overlay.getVisible() != null) {
            if (isEsc) {
                Overlay.close();
            }
            return true;
        }
        if (KeyUtil.isSearching(keyCode)) {
            if (this.getSearchBox().m_93696_()) {
                this.getSearchBox().m_94144_("");
                this.refreshSearchResults();
            }
            this.getSearchBox().m_94178_(true);
            return true;
        }
        if (this.getSearchBox().m_7933_(keyCode, scanCode, modifiers)) {
            if (!this.getSearchBox().m_94155_().equals(query)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.getSearchBox().m_93696_() && this.getSearchBox().m_94213_()) {
            if (isEsc) {
                this.getSearchBox().m_94178_(false);
            }
            return true;
        }
        if (isEsc && this.getConfigRowList().unsetFocus()) {
            return true;
        }
        if (isEsc && this.m_6913_()) {
            this.exitList();
            return true;
        }
        return false;
    }

    private void renderWidget(Widget widget, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (widget instanceof AbstractWidget) {
            AbstractWidget button = (AbstractWidget)widget;
            if (Overlay.isOpened()) {
                button.f_93623_ = false;
            } else {
                button.f_93623_ = true;
                boolean isLevelAbsent = this.minecraft.f_91073_ == null;
                boolean isItemIneligible = false;
                boolean isItemListed = false;
                if (this.minecraft.f_91074_ != null) {
                    ItemStack itemStack = this.minecraft.f_91074_.m_21205_();
                    isItemIneligible = !this.isItemEligible(itemStack);
                    isItemListed = this.isItemSaved(itemStack);
                }
                if (isLevelAbsent || isItemIneligible || isItemListed) {
                    this.widgetProvider.autoButton.f_93623_ = false;
                }
                if (this.onlyInclude != ListInclude.ALL) {
                    this.widgetProvider.filterButton.f_93623_ = false;
                }
            }
        }
        Button save = this.widgetProvider.saveButton;
        if (widget instanceof Button) {
            Button button = (Button)widget;
            if (button.f_93620_ == save.f_93620_ && button.f_93621_ == save.f_93621_) {
                button.f_93623_ = !Overlay.isOpened() && this.isListSavable();
            }
        }
        widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft.f_91073_ != null) {
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, 839913488, 0x1000000);
        } else {
            this.m_96626_(0);
        }
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, 0x68000000, 0x68000000);
        if (this.scrollAmountCache > 0.0) {
            this.getConfigRowList().m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.getConfigRowList().m_93410_(this.scrollAmountCache);
            this.scrollAmountCache = 0.0;
        }
        this.getConfigRowList().m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.jumpToEntry(this.highlightItem);
        for (Widget widget : this.listWidgets) {
            this.renderWidget(widget, poseStack, mouseX, mouseY, partialTick);
        }
        for (Widget widget : this.listWidgets) {
            OverlapButton button;
            if (!(widget instanceof OverlapButton) || !(button = (OverlapButton)widget).m_5953_(mouseX, mouseY)) continue;
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        ListScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        Overlay overlay = Overlay.getVisible();
        if (this.isPermissionWatched() && !NetUtil.isPlayerOp()) {
            if (ClassUtil.isNotInstanceOf(overlay, PermissionLostOverlay.class)) {
                new PermissionLostOverlay();
            }
        } else if (this.isPermissionWatched() && NetUtil.isPlayerOp() && overlay instanceof PermissionLostOverlay) {
            Overlay.close();
        }
        Overlay.render(poseStack, mouseX, mouseY, partialTick);
        if (!Overlay.isOpened()) {
            this.renderLast.forEach(Runnable::run);
        } else {
            this.widgetProvider.searchBox.m_94178_(false);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 400.0);
            this.renderOverlayTooltips.forEach((Consumer<TriConsumer<PoseStack, Integer, Integer>>)((Consumer<TriConsumer>)tooltip -> tooltip.accept(poseStack, mouseX, mouseY)));
            poseStack.m_85849_();
        }
        this.renderLast.clear();
        this.renderOverlayTooltips.clear();
    }

    private void exitList() {
        if (!this.isListSavable()) {
            this.closeList(true);
            return;
        }
        this.minecraft.m_91152_((Screen)new ConfirmScreen((BooleanConsumer)new CancelConsumer(), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_title"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_body"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_discard"), (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.confirm.quit_cancel")));
    }

    public void closeWithoutSaving() {
        this.closeList(true);
    }

    private class WidgetProvider {
        public static final int SEARCH_TOP_Y = 25;
        public static final int SEARCH_BOX_W = 226;
        public static final int SEARCH_BOX_H = 18;
        public final EditBox searchBox = this.createSearchBox();
        public final Button cancelButton = this.createCancelButton();
        public final Button saveButton = this.createSaveButton();
        public final StateButton nukeButton = this.createNukeButton();
        public final StateButton autoButton = this.createAutoButton();
        public final StateButton filterButton = this.createFilterButton();
        public final StateButton clearButton = this.createClearButton();
        public final StateButton swingButton = this.createSwingButton();

        private int getSmallWidth() {
            return Math.min(200, (ListScreen.this.f_96543_ - 50 - 12) / 3);
        }

        public WidgetProvider() {
            HashSet<StateButton> children = new HashSet<StateButton>(Set.of(this.searchBox, this.cancelButton, this.saveButton, this.nukeButton, this.autoButton, this.filterButton, this.clearButton));
            ListId listId = ListScreen.this.getListId();
            if (listId == ListId.LEFT_CLICK_SPEEDS || listId == ListId.RIGHT_CLICK_SPEEDS) {
                children.add(this.swingButton);
            }
            ListScreen.this.listWidgets.addAll(children);
        }

        private EditBox createSearchBox() {
            return new EditBox(ListScreen.this.f_96547_, ListScreen.this.f_96543_ / 2 - 112, 25, 226, 18, (Component)Component.m_237119_());
        }

        private Button createSaveButton() {
            return new Button(ListScreen.this.f_96543_ / 2 + 3, ListScreen.this.f_96544_ - 26, this.getSmallWidth(), 20, (Component)Component.m_237115_((String)"gui.nostalgic_tweaks.button.save_and_done"), button -> {
                boolean isMultiplayer;
                ListScreen.this.closeList(false);
                TweakServerCache<?> serverTweak = ListScreen.this.list.getTweak().getServerCache();
                boolean isServerTweak = serverTweak != null;
                boolean bl = isMultiplayer = NostalgicTweaks.isNetworkVerified() && NetUtil.isMultiplayer();
                if (isServerTweak && isMultiplayer) {
                    PacketUtil.sendToServer(new PacketC2SChangeTweak(serverTweak));
                    ToastNotification.sentChanges();
                } else {
                    AutoConfig.getConfigHolder(ClientConfig.class).save();
                }
            });
        }

        private Button createCancelButton() {
            return new Button(ListScreen.this.f_96543_ / 2 - this.getSmallWidth() - 3, ListScreen.this.f_96544_ - 26, this.getSmallWidth(), 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> ListScreen.this.exitList());
        }

        private StateButton createNukeButton() {
            return new StateButton(StateWidget.NUKE, this.searchBox.f_93620_ - 61, this.searchBox.f_93621_ - 1, button -> new NukeListOverlay());
        }

        private StateButton createFilterButton() {
            return new StateButton(StateWidget.FILTER, this.searchBox.f_93620_ - 42, this.searchBox.f_93621_ - 1, button -> new FilterListOverlay());
        }

        private StateButton createAutoButton() {
            return new StateButton(StateWidget.LIGHTNING, this.searchBox.f_93620_ - 23, this.searchBox.f_93621_ - 1, button -> {
                if (ListScreen.this.minecraft.f_91074_ != null) {
                    this.searchBox.m_94144_("");
                    this.searchBox.m_94178_(false);
                    ItemStack itemStack = ListScreen.this.minecraft.f_91074_.m_21205_();
                    ListScreen.this.addItem(itemStack);
                    ListScreen.this.refreshSearchResults();
                    ListScreen.this.highlightItem(itemStack);
                }
            });
        }

        private StateButton createClearButton() {
            EditBox search = this.searchBox;
            return new StateButton(StateWidget.CLEAR, search.f_93620_ + search.m_5711_() + 3, search.f_93621_ - 1, button -> {
                search.m_94144_("");
                search.m_94178_(true);
                ListScreen.this.refreshSearchResults();
            });
        }

        private StateButton createSwingButton() {
            EditBox search = this.searchBox;
            return new StateButton(StateWidget.SWING, search.f_93620_ + search.m_5711_() + 22, search.f_93621_ - 1, button -> {
                ListId listId = ListScreen.this.getListId();
                if (listId == ListId.LEFT_CLICK_SPEEDS || listId == ListId.RIGHT_CLICK_SPEEDS) {
                    new SpeedOverlay();
                }
            });
        }
    }

    private class CancelConsumer
    implements BooleanConsumer {
        private CancelConsumer() {
        }

        public void accept(boolean understood) {
            if (understood) {
                ListScreen.this.closeList(true);
            } else {
                ListScreen.this.minecraft.m_91152_((Screen)ListScreen.this);
            }
        }
    }
}

