/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.screen.list;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowKey;
import mod.adrenix.nostalgic.common.config.list.ListSet;
import mod.adrenix.nostalgic.util.common.ItemCommonUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class ListSetScreen
extends ListScreen {
    private final ArrayList<String> deletedKeys = new ArrayList();
    private final Set<String> defaultSet;
    private final Set<String> configSet;
    private final Set<String> undoSet;

    public ListSetScreen(Component title, ListSet listSet) {
        super(title, listSet);
        this.defaultSet = listSet.getDefaultSet();
        this.configSet = listSet.getConfigSet();
        this.undoSet = Sets.newHashSet(this.configSet);
        this.sortConfig();
    }

    private void sortConfig() {
        this.sortEntries(this.configSet, this::getResourceKey, this.configSet::addAll, this.configSet::clear);
        this.sortEntries(this.defaultSet, this::getResourceKey, this.defaultSet::addAll, this.defaultSet::clear);
    }

    public ArrayList<String> getDeletedKeys() {
        return this.deletedKeys;
    }

    public void delete(String resourceKey) {
        this.deletedKeys.add(resourceKey);
    }

    public void undo(String resourceKey) {
        this.deletedKeys.remove(resourceKey);
    }

    public boolean isKeyDeleted(String resourceKey) {
        return this.deletedKeys.contains(resourceKey);
    }

    @Override
    public boolean isItemAdded(Item item) {
        return !this.undoSet.contains(ItemCommonUtil.getResourceKey(item));
    }

    @Override
    public void addItem(Item item) {
        if (this.isItemEligible(item)) {
            this.configSet.add(ItemCommonUtil.getResourceKey(item));
            this.sortConfig();
        }
    }

    @Override
    public void deleteItem(Item item) {
        for (String key : this.configSet) {
            if (!key.equals(ItemCommonUtil.getResourceKey(item))) continue;
            this.delete(key);
            break;
        }
    }

    @Override
    public void clearAllSaved() {
        for (String key : this.configSet) {
            if (this.deletedKeys.contains(key)) continue;
            this.delete(key);
        }
    }

    @Override
    public boolean isItemDeleted(Item item) {
        for (String key : this.deletedKeys) {
            if (!ItemCommonUtil.getResourceKey(item).equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemSaved(Item item) {
        for (String key : this.configSet) {
            if (!key.equals(ItemCommonUtil.getResourceKey(item))) continue;
            return true;
        }
        return false;
    }

    private String getResourceKey(String resourceKey) {
        return resourceKey;
    }

    private void addSavedRow(ArrayList<ConfigRowList.Row> rows, String resourceKey) {
        rows.add(new ConfigRowKey.SavedRow(resourceKey).generate());
    }

    private void addDefaultRow(ArrayList<ConfigRowList.Row> rows, String resourceKey) {
        rows.add(new ConfigRowKey.DefaultRow(resourceKey).generate());
    }

    @Override
    protected ArrayList<ConfigRowList.Row> getSavedRows() {
        String langKey = "gui.nostalgic_tweaks.list.no_saved_items";
        return this.getSearchedItems(langKey, this.configSet, this::getResourceKey, this::addSavedRow);
    }

    @Override
    protected ArrayList<ConfigRowList.Row> getDefaultRows() {
        String langKey = "gui.nostalgic_tweaks.list.no_default_items";
        return this.getSearchedItems(langKey, this.defaultSet, this::getResourceKey, this::addDefaultRow);
    }

    @Override
    public void disableAllDefaults() {
        this.disabledDefaults.addAll(this.defaultSet);
    }

    @Override
    public void enableAllDefaults() {
        this.disabledDefaults.removeAll(this.defaultSet);
    }

    @Override
    protected int getDefaultCount() {
        return this.defaultSet.size();
    }

    @Override
    protected boolean isListSavable() {
        return this.undoSet.size() != this.configSet.size() || this.undoDisabledDefaults.size() != this.disabledDefaults.size() || this.deletedKeys.size() > 0;
    }

    @Override
    protected void closeList(boolean isCancelled) {
        if (!isCancelled) {
            for (String entry : this.deletedKeys) {
                this.configSet.remove(entry);
            }
        } else {
            this.configSet.clear();
            this.configSet.addAll(this.undoSet);
            this.disabledDefaults.clear();
            this.disabledDefaults.addAll(this.undoDisabledDefaults);
        }
        this.deletedKeys.clear();
        this.getMinecraft().m_91152_(this.parentScreen);
        Screen screen = this.parentScreen;
        if (screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.restoreCache();
        }
    }
}

