/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.CheckForNull;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.config.ClientConfigCache;
import mod.adrenix.nostalgic.client.config.gui.screen.GearSpinner;
import mod.adrenix.nostalgic.client.config.gui.toast.ToastId;
import mod.adrenix.nostalgic.common.NostalgicConnection;
import mod.adrenix.nostalgic.util.client.RenderUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import mod.adrenix.nostalgic.util.common.TimeWatcher;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class NostalgicToast
implements Toast {
    private static final NostalgicToast WELCOME = new NostalgicToast(ToastId.WELCOME);
    private static final NostalgicToast HANDSHAKE = new NostalgicToast(ToastId.HANDSHAKE);
    private static final NostalgicToast TWEAK_C2S = new NostalgicToast(ToastId.TWEAK_C2S);
    private static final NostalgicToast TWEAK_S2C = new NostalgicToast(ToastId.TWEAK_S2C);
    @CheckForNull
    private TimeWatcher timer = null;
    private final Font font;
    private final ToastId id;
    private int width;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private boolean isVisible;

    public static NostalgicToast getInstance(ToastId id) {
        return switch (id) {
            default -> throw new IncompatibleClassChangeError();
            case ToastId.WELCOME -> WELCOME;
            case ToastId.HANDSHAKE -> HANDSHAKE;
            case ToastId.TWEAK_C2S -> TWEAK_C2S;
            case ToastId.TWEAK_S2C -> TWEAK_S2C;
        };
    }

    public static void onPostRender(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (WELCOME.isClosed() && screen instanceof TitleScreen && !ClientConfigCache.getGui().interactedWithConfig) {
            WELCOME.open();
        }
        if (WELCOME.isOpened() && ClassUtil.isNotInstanceOf(screen, TitleScreen.class)) {
            WELCOME.close();
        }
    }

    private NostalgicToast(ToastId id) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.isVisible = false;
        this.id = id;
        this.setup();
    }

    private void setup() {
        this.title = switch (this.id) {
            default -> throw new IncompatibleClassChangeError();
            case ToastId.WELCOME -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.welcome_title");
            case ToastId.HANDSHAKE -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.handshake_title");
            case ToastId.TWEAK_C2S -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.tweak_c2s_title");
            case ToastId.TWEAK_S2C -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.tweak_s2c_title");
        };
        NostalgicConnection connection = NostalgicTweaks.getConnection().orElseGet(NostalgicConnection::disconnected);
        String client = ChatFormatting.GOLD + NostalgicTweaks.getTinyVersion();
        String server = ChatFormatting.GOLD + connection.getVersion();
        String loader = ChatFormatting.LIGHT_PURPLE + connection.getLoader();
        MutableComponent message = switch (this.id) {
            default -> throw new IncompatibleClassChangeError();
            case ToastId.WELCOME -> Component.m_237110_((String)"gui.nostalgic_tweaks.toast.welcome_message", (Object[])new Object[]{client});
            case ToastId.HANDSHAKE -> Component.m_237110_((String)"gui.nostalgic_tweaks.toast.handshake_message", (Object[])new Object[]{server, loader});
            case ToastId.TWEAK_C2S -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.tweak_c2s_message");
            case ToastId.TWEAK_S2C -> Component.m_237115_((String)"gui.nostalgic_tweaks.toast.tweak_s2c_message");
        };
        this.messageLines = this.font.m_92923_((FormattedText)message, 182);
        this.width = 24 + this.messageLines.stream().mapToInt(arg_0 -> ((Font)this.font).m_92724_(arg_0)).max().orElse(182);
        if (this.messageLines.size() == 1) {
            this.width = Math.max(42 + this.font.m_92852_((FormattedText)this.title), 24 + this.font.m_92724_(this.messageLines.get(0)));
        }
    }

    private void setVisible(boolean visible) {
        this.isVisible = visible;
        this.setup();
    }

    public void open() {
        this.setVisible(true);
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)this);
    }

    public void close() {
        this.setVisible(false);
    }

    public boolean isOpened() {
        return this.isVisible;
    }

    public boolean isClosed() {
        return !this.isOpened();
    }

    public NostalgicToast setTimer(TimeWatcher timer) {
        this.timer = timer;
        this.timer.skip();
        return this;
    }

    public Object m_7283_() {
        return this.id;
    }

    public int m_7828_() {
        return this.width;
    }

    public int m_94899_() {
        return 37 + this.messageLines.size() * 12;
    }

    private int drawHeight() {
        return this.m_94899_();
    }

    public Toast.Visibility m_7172_(PoseStack poseStack, ToastComponent toast, long timeSinceLastVisible) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.TOASTS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toast.m_93228_(poseStack, 0, 0, 0, 0, 8, 8);
        toast.m_93228_(poseStack, 0, this.drawHeight() - 8, 0, 9, 8, 8);
        toast.m_93228_(poseStack, this.m_7828_() - 8, 0, 9, 0, 8, 8);
        toast.m_93228_(poseStack, this.m_7828_() - 8, this.drawHeight() - 8, 9, 9, 8, 8);
        for (int x = 8; x < this.m_7828_() - 8; ++x) {
            toast.m_93228_(poseStack, x, 0, 8, 0, 1, 8);
            toast.m_93228_(poseStack, x, this.drawHeight() - 8, 8, 9, 1, 8);
        }
        for (int y = 0; y < this.drawHeight() - 16; ++y) {
            toast.m_93228_(poseStack, 0, 8 + y, 0, 8, 8, 1);
            toast.m_93228_(poseStack, this.m_7828_() - 8, 8 + y, 9, 8, 8, 1);
        }
        RenderUtil.fill(poseStack, 8.0f, (float)(this.m_7828_() - 8), 8.0f, (float)(this.drawHeight() - 8), -1358954496);
        GearSpinner.getInstance().render(poseStack, 16.0f, 10, 10);
        poseStack.m_85836_();
        poseStack.m_85837_(23.0, 23.0, 1.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-20.0f));
        String splash = "N.T";
        float scale = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        scale = scale * 5.0f / (float)this.font.m_92895_(splash);
        poseStack.m_85841_(scale, scale, scale);
        GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.font, (String)splash, (int)1, (int)-6, (int)0xFFFF00);
        poseStack.m_85849_();
        this.font.m_92763_(poseStack, this.title, 30.0f, 14.0f, 0xFFFF00);
        for (int i = 0; i < this.messageLines.size(); ++i) {
            this.font.m_92744_(poseStack, this.messageLines.get(i), 12.0f, 30.0f + (float)i * 12.0f, 0xFFFFFF);
        }
        if (this.timer != null && this.timer.isReady()) {
            this.close();
        }
        return this.isVisible ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }
}

