/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.util.common.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SearchCrumbs
extends AbstractWidget {
    private final ArrayList<Crumb> crumbs = new ArrayList();
    private final MutableComponent slashText = Component.m_237113_((String)"/").m_130940_(ChatFormatting.WHITE);
    public final int startX;

    public SearchCrumbs(TweakClientCache<?> tweak) {
        super(8, 0, 0, 0, (Component)Component.m_237119_());
        String subKey;
        String catKey;
        this.startX = 8;
        String groupKey = tweak.getGroup().getLangKey();
        Crumb groupCrumb = new Crumb(this.startX, tweak, Component.m_237115_((String)groupKey).m_130940_(ChatFormatting.GOLD), JumpType.GROUP);
        this.crumbs.add(groupCrumb);
        if (tweak.getCategory() != null) {
            catKey = tweak.getCategory().container().getLangKey();
            MutableComponent catText = Component.m_237115_((String)catKey).m_130940_(ChatFormatting.YELLOW);
            Crumb catCrumb = new Crumb(groupCrumb.getEndX(), tweak, catText, JumpType.CATEGORY);
            this.crumbs.add(catCrumb);
        }
        if (tweak.getSubcategory() != null) {
            catKey = tweak.getSubcategory().container().getCategory().getLangKey();
            subKey = tweak.getSubcategory().container().getLangKey();
            MutableComponent catText = Component.m_237115_((String)catKey).m_130940_(ChatFormatting.YELLOW);
            MutableComponent subText = Component.m_237115_((String)subKey).m_130940_(ChatFormatting.GREEN);
            Crumb catCrumb = new Crumb(groupCrumb.getEndX(), tweak, catText, JumpType.CATEGORY);
            Crumb subCrumb = new Crumb(catCrumb.getEndX(), tweak, subText, JumpType.SUBCATEGORY);
            this.crumbs.add(catCrumb);
            this.crumbs.add(subCrumb);
        }
        if (tweak.getEmbed() != null) {
            catKey = tweak.getEmbed().container().getSubcategory().getCategory().getLangKey();
            subKey = tweak.getEmbed().container().getSubcategory().getLangKey();
            String embKey = tweak.getEmbed().container().getLangKey();
            MutableComponent catText = Component.m_237115_((String)catKey).m_130940_(ChatFormatting.YELLOW);
            MutableComponent subText = Component.m_237115_((String)subKey).m_130940_(ChatFormatting.GREEN);
            MutableComponent embText = Component.m_237115_((String)embKey).m_130940_(ChatFormatting.AQUA);
            Crumb catCrumb = new Crumb(groupCrumb.getEndX(), tweak, catText, JumpType.CATEGORY);
            Crumb subCrumb = new Crumb(catCrumb.getEndX(), tweak, subText, JumpType.SUBCATEGORY);
            Crumb embCrumb = new Crumb(subCrumb.getEndX(), tweak, embText, JumpType.EMBEDDED);
            this.crumbs.add(catCrumb);
            this.crumbs.add(subCrumb);
            this.crumbs.add(embCrumb);
        }
    }

    private void drawCrumb(PoseStack poseStack, Crumb crumb, boolean isUnderlined) {
        MutableComponent crumbText = isUnderlined ? crumb.text().m_6881_().m_130940_(ChatFormatting.UNDERLINE) : crumb.text();
        SearchCrumbs.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)crumbText, (int)crumb.startX(), (int)this.f_93621_, (int)0xFFFFFF);
    }

    private void drawSlash(PoseStack poseStack, Crumb crumb) {
        Font font = Minecraft.m_91087_().f_91062_;
        int startX = crumb.getEndX() - font.m_92852_((FormattedText)Component.m_237113_((String)"/"));
        SearchCrumbs.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.slashText, (int)startX, (int)this.f_93621_, (int)0xFFFFFF);
    }

    private boolean isOverCrumb(double mouseX, double mouseY, Crumb crumb) {
        if (this.f_93621_ == 0 || ConfigWidgets.isOutsideRowList(mouseY)) {
            return false;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92852_((FormattedText)crumb.text());
        Objects.requireNonNull(font);
        int height = 9;
        return MathUtil.isWithinBox(mouseX, mouseY, crumb.startX(), this.f_93621_, width, height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        for (Crumb crumb : this.crumbs) {
            Screen screen;
            if (!this.isOverCrumb(mouseX, mouseY, crumb) || !((screen = minecraft.f_91080_) instanceof ConfigScreen)) continue;
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.setTabFromGroupKey(crumb.tweak().getGroup().getLangKey());
            if (crumb.tweak().getCategory() != null && crumb.jump() == JumpType.CATEGORY) {
                configScreen.setScrollOnContainer((Object)crumb.tweak().getCategory().container());
            }
            if (crumb.tweak().getSubcategory() != null) {
                if (crumb.jump() == JumpType.CATEGORY) {
                    configScreen.setScrollOnContainer((Object)crumb.tweak().getSubcategory().container().getCategory());
                } else if (crumb.jump() == JumpType.SUBCATEGORY) {
                    configScreen.setScrollOnContainer((Object)crumb.tweak().getSubcategory().container());
                }
            }
            if (crumb.tweak().getEmbed() != null) {
                if (crumb.jump() == JumpType.CATEGORY) {
                    configScreen.setScrollOnContainer((Object)crumb.tweak().getEmbed().container().getSubcategory().getCategory());
                } else if (crumb.jump() == JumpType.SUBCATEGORY) {
                    configScreen.setScrollOnContainer((Object)crumb.tweak().getEmbed().container().getSubcategory());
                } else if (crumb.jump() == JumpType.EMBEDDED) {
                    configScreen.setScrollOnContainer((Object)crumb.tweak().getEmbed().container());
                }
            }
            this.m_7435_(minecraft.m_91106_());
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.crumbs.size() == 1) {
            Crumb crumb = this.crumbs.get(0);
            this.drawCrumb(poseStack, crumb, this.isOverCrumb(mouseX, mouseY, crumb));
        } else {
            for (int i = 0; i < this.crumbs.size(); ++i) {
                Crumb crumb = this.crumbs.get(i);
                if (i != this.crumbs.size() - 1) {
                    this.drawSlash(poseStack, crumb);
                }
                this.drawCrumb(poseStack, crumb, this.isOverCrumb(mouseX, mouseY, crumb));
            }
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    private record Crumb(int startX, TweakClientCache<?> tweak, MutableComponent text, JumpType jump) {
        public int getEndX() {
            Font font = Minecraft.m_91087_().f_91062_;
            return this.startX + font.m_92852_((FormattedText)this.text) + font.m_92852_((FormattedText)Component.m_237113_((String)"/"));
        }
    }

    private static enum JumpType {
        GROUP,
        CATEGORY,
        SUBCATEGORY,
        EMBEDDED;

    }
}

