/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.adrenix.nostalgic.client.config.annotation.TweakGui;
import mod.adrenix.nostalgic.client.config.annotation.TweakReload;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigWidgets;
import mod.adrenix.nostalgic.client.config.gui.widget.button.StatusButton;
import mod.adrenix.nostalgic.client.config.gui.widget.list.ConfigRowList;
import mod.adrenix.nostalgic.client.config.reflect.TweakClientCache;
import mod.adrenix.nostalgic.common.config.annotation.TweakData;
import mod.adrenix.nostalgic.common.config.tweak.GuiTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.TextUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TweakTag
extends AbstractWidget {
    public static final int U_NEW_OFFSET = 66;
    public static final int U_CLIENT_OFFSET = 69;
    public static final int U_SERVER_OFFSET = 72;
    public static final int U_DYNAMIC_OFFSET = 81;
    public static final int U_RELOAD_OFFSET = 75;
    public static final int U_RESTART_OFFSET = 78;
    public static final int U_KEY_OFFSET = 81;
    public static final int U_SYNC_OFFSET = 84;
    public static final int U_WARNING_OFFSET = 87;
    public static final int V_GLOBAL_OFFSET = 0;
    public static final int U_GLOBAL_WIDTH = 1;
    public static final int V_GLOBAL_HEIGHT = 11;
    public static final int TAG_MARGIN = 5;
    private String title;
    private boolean render = true;
    private boolean widthChanged = false;
    private final TweakClientCache<?> tweak;
    private final AbstractWidget controller;
    private final boolean isTooltip;

    public TweakTag(TweakClientCache<?> tweak, AbstractWidget controller, boolean isTooltip) {
        super(0, 0, 0, 0, (Component)Component.m_237119_());
        this.tweak = tweak;
        this.controller = controller;
        this.isTooltip = isTooltip;
        this.title = Component.m_237115_((String)this.tweak.getLangKey()).getString();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRender(boolean state) {
        this.render = state;
    }

    public boolean isWidthChanged() {
        return this.widthChanged;
    }

    public void resetTag() {
        this.widthChanged = false;
        this.title = Component.m_237115_((String)this.tweak.getLangKey()).getString();
    }

    private static int getTagWidth(Component tag, int startX) {
        return startX + 1 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tag) + 5;
    }

    private static void draw(Screen screen, PoseStack poseStack, int x, int y, int uOffset, int vOffset, boolean render) {
        if (render) {
            screen.m_93228_(poseStack, x, y, uOffset, vOffset, 1, 11);
        }
    }

    public static int renderTag(Screen screen, PoseStack poseStack, Component tag, int startX, int startY, int uOffset, boolean render) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
        Font font = Minecraft.m_91087_().f_91062_;
        int tagWidth = font.m_92852_((FormattedText)tag);
        int endX = TweakTag.getTagWidth(tag, startX);
        TweakTag.draw(screen, poseStack, startX, startY, uOffset, 0, render);
        for (int i = 0; i < tagWidth + 5; ++i) {
            TweakTag.draw(screen, poseStack, startX + 1 + i, startY, uOffset + 1, 0, render);
        }
        TweakTag.draw(screen, poseStack, endX, startY, uOffset, 0, render);
        if (render) {
            font.m_92889_(poseStack, tag, (float)(startX + 4), (float)(startY + 2), 0xFFFFFF);
        }
        return endX + 5;
    }

    public static int renderTag(Screen screen, PoseStack poseStack, Component tag, int startX, int startY, int uOffset) {
        return TweakTag.renderTag(screen, poseStack, tag, startX, startY, uOffset, true);
    }

    public static void renderTooltip(Screen screen, PoseStack poseStack, Component title, Component tooltip, int startX, int startY, int mouseX, int mouseY) {
        int endX = TweakTag.getTagWidth(title, startX);
        boolean isMouseOver = mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= startY + 11;
        boolean isInitialized = startY != 4;
        boolean isWithinList = ConfigWidgets.isInsideRowList(mouseY);
        if (isMouseOver && isWithinList && isInitialized && screen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)screen;
            configScreen.renderLast.add(() -> screen.m_96597_(poseStack, TextUtil.Wrap.tooltip(tooltip, 38), mouseX, mouseY));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        MutableComponent tooltip;
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        StatusButton.update();
        TweakGui.New newTag = this.tweak.getMetadata(TweakGui.New.class);
        TweakData.Client clientTag = this.tweak.getMetadata(TweakData.Client.class);
        TweakData.Server serverTag = this.tweak.getMetadata(TweakData.Server.class);
        TweakData.Dynamic dynamicTag = this.tweak.getMetadata(TweakData.Dynamic.class);
        TweakData.Conflict conflictTag = this.tweak.getMetadata(TweakData.Conflict.class);
        TweakGui.Alert alertTag = this.tweak.getMetadata(TweakGui.Alert.class);
        TweakGui.Sodium sodiumTag = this.tweak.getMetadata(TweakGui.Sodium.class);
        TweakGui.Restart restartTag = this.tweak.getMetadata(TweakGui.Restart.class);
        TweakGui.Warning warningTag = this.tweak.getMetadata(TweakGui.Warning.class);
        TweakGui.Optifine optifineTag = this.tweak.getMetadata(TweakGui.Optifine.class);
        TweakReload.Resources reloadTag = this.tweak.getMetadata(TweakReload.Resources.class);
        MutableComponent optifineTitle = Component.m_237113_((String)"Optifine");
        MutableComponent sodiumTitle = Component.m_237113_((String)"Sodium");
        ChatFormatting flashColor = StatusButton.isFlashOff() ? ChatFormatting.GRAY : ChatFormatting.RED;
        MutableComponent title = Component.m_237113_((String)this.title);
        MutableComponent newTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.new");
        MutableComponent clientTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.client");
        MutableComponent serverTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.server");
        MutableComponent dynamicTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.dynamic");
        MutableComponent reloadTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.reload").m_130940_(ChatFormatting.ITALIC);
        MutableComponent restartTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.restart").m_130940_(ChatFormatting.ITALIC);
        MutableComponent warningTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.warning").m_130940_(flashColor);
        MutableComponent alertTitle = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.alert").m_130940_(flashColor);
        MutableComponent newTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.new.@Tooltip");
        MutableComponent clientTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.client.@Tooltip");
        MutableComponent serverTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.server.@Tooltip");
        MutableComponent dynamicTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.dynamic.@Tooltip");
        MutableComponent reloadTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.reload.@Tooltip");
        MutableComponent restartTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.restart.@Tooltip");
        MutableComponent sodiumTooltip = Component.m_237115_((String)this.tweak.getSodiumKey());
        MutableComponent optifineTooltip = Component.m_237115_((String)this.tweak.getOptifineKey());
        MutableComponent warningTooltip = Component.m_237115_((String)this.tweak.getWarningKey());
        boolean isNewRenderable = (Boolean)TweakClientCache.get(GuiTweak.DISPLAY_NEW_TAGS).getValue();
        boolean isSidedRenderable = (Boolean)TweakClientCache.get(GuiTweak.DISPLAY_SIDED_TAGS).getValue();
        boolean isTooltipRenderable = (Boolean)TweakClientCache.get(GuiTweak.DISPLAY_TAG_TOOLTIPS).getValue();
        int startX = ConfigRowList.getStartX() + minecraft.f_91062_.m_92852_((FormattedText)title) + (this.isTooltip ? 20 : 4);
        int startY = this.controller.f_93621_ + 4;
        int lastX = startX;
        if (newTag != null && isNewRenderable) {
            if (isTooltipRenderable) {
                TweakTag.renderTooltip(screen, poseStack, (Component)newTitle, (Component)newTooltip, lastX, startY, mouseX, mouseY);
            }
            lastX = TweakTag.renderTag(screen, poseStack, (Component)newTitle, lastX, startY, 66, this.render);
        }
        if (clientTag != null && isSidedRenderable) {
            if (isTooltipRenderable) {
                TweakTag.renderTooltip(screen, poseStack, (Component)clientTitle, (Component)clientTooltip, lastX, startY, mouseX, mouseY);
            }
            lastX = TweakTag.renderTag(screen, poseStack, (Component)clientTitle, lastX, startY, 69, this.render);
        }
        if (serverTag != null && isSidedRenderable) {
            if (isTooltipRenderable) {
                TweakTag.renderTooltip(screen, poseStack, (Component)serverTitle, (Component)serverTooltip, lastX, startY, mouseX, mouseY);
            }
            lastX = TweakTag.renderTag(screen, poseStack, (Component)serverTitle, lastX, startY, 72, this.render);
        }
        if (dynamicTag != null && isSidedRenderable) {
            if (isTooltipRenderable) {
                TweakTag.renderTooltip(screen, poseStack, (Component)dynamicTitle, (Component)dynamicTooltip, lastX, startY, mouseX, mouseY);
            }
            lastX = TweakTag.renderTag(screen, poseStack, (Component)dynamicTitle, lastX, startY, 81, this.render);
        }
        if (reloadTag != null) {
            TweakTag.renderTooltip(screen, poseStack, (Component)reloadTitle, (Component)reloadTooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)reloadTitle, lastX, startY, 75, this.render);
        }
        if (restartTag != null) {
            TweakTag.renderTooltip(screen, poseStack, (Component)restartTitle, (Component)restartTooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)restartTitle, lastX, startY, 78, this.render);
        }
        if (alertTag != null && alertTag.condition().active()) {
            tooltip = Component.m_237115_((String)alertTag.langKey());
            TweakTag.renderTooltip(screen, poseStack, (Component)alertTitle, (Component)tooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)alertTitle, lastX, startY, 87, this.render);
        }
        if (conflictTag != null && this.tweak.isConflict()) {
            tooltip = Component.m_237115_((String)this.tweak.getConflictKey());
            TweakTag.renderTooltip(screen, poseStack, (Component)alertTitle, (Component)tooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)alertTitle, lastX, startY, 87, this.render);
        }
        if (warningTag != null) {
            TweakTag.renderTooltip(screen, poseStack, (Component)warningTitle, (Component)warningTooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)warningTitle, lastX, startY, 87, this.render);
        }
        if (sodiumTag != null && ModTracker.SODIUM.isInstalled()) {
            if (sodiumTag.incompatible()) {
                sodiumTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.sodium.@Tooltip");
            }
            TweakTag.renderTooltip(screen, poseStack, (Component)sodiumTitle, (Component)sodiumTooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)sodiumTitle, lastX, startY, 78, this.render);
        }
        if (optifineTag != null && ModTracker.OPTIFINE.isInstalled()) {
            if (optifineTag.incompatible()) {
                optifineTooltip = Component.m_237115_((String)"gui.nostalgic_tweaks.config.tag.optifine.@Tooltip");
            }
            TweakTag.renderTooltip(screen, poseStack, (Component)optifineTitle, (Component)optifineTooltip, lastX, startY, mouseX, mouseY);
            lastX = TweakTag.renderTag(screen, poseStack, (Component)optifineTitle, lastX, startY, 78, this.render);
        }
        int previousWidth = this.f_93618_;
        this.f_93620_ = startX;
        this.m_93674_(lastX - startX);
        if (previousWidth != this.f_93618_) {
            this.widthChanged = true;
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

