/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import mod.adrenix.nostalgic.client.config.gui.overlay.Overlay;
import mod.adrenix.nostalgic.client.config.gui.widget.list.row.ConfigRowGroup;
import mod.adrenix.nostalgic.util.client.KeyUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ContainerButton
extends Button {
    private static final Map<Enum<?>, Boolean> EXPANDED = new HashMap();
    private final Enum<?> id;
    private final ConfigRowGroup.ContainerRow row;
    private final Component title;
    private boolean grandparentTreeNeeded;
    private boolean parentTreeNeeded;
    private boolean lastSubcategory;
    private boolean highlighted;

    public ContainerButton(ConfigRowGroup.ContainerRow row, Enum<?> id, Component title, ConfigRowGroup.ContainerType containerType) {
        super(ConfigRowGroup.ContainerRow.getIndent(containerType), 0, 0, 0, (Component)Component.m_237119_(), ignored -> {});
        this.id = id;
        this.row = row;
        this.title = title;
        this.f_93618_ = 18;
        this.f_93619_ = 16;
        EXPANDED.putIfAbsent(id, false);
    }

    public static void expand(Enum<?> id) {
        if (EXPANDED.containsKey(id)) {
            EXPANDED.put(id, true);
        }
    }

    public static void collapse(Enum<?> id) {
        if (EXPANDED.containsKey(id)) {
            EXPANDED.put(id, false);
        }
    }

    private void toggle() {
        EXPANDED.put(this.id, EXPANDED.get(this.id) == false);
    }

    public void collapse() {
        if (this.isExpanded()) {
            this.toggle();
            this.row.collapse();
        }
    }

    public static void collapseAll() {
        EXPANDED.forEach((id, state) -> EXPANDED.put((Enum<?>)id, false));
    }

    public void init() {
        if (this.isExpanded() && !this.row.isExpanded()) {
            this.row.expand();
        }
        if (!this.isExpanded() && this.row.isExpanded()) {
            this.row.collapse();
        }
    }

    public Component getTitle() {
        return this.title;
    }

    public void setGrandparentTreeNeeded(boolean state) {
        this.grandparentTreeNeeded = state;
    }

    public void setParentTreeNeeded(boolean state) {
        this.parentTreeNeeded = state;
    }

    public void setLastSubcategory(boolean state) {
        this.lastSubcategory = state;
    }

    public void setHighlight(boolean state) {
        this.highlighted = state;
    }

    public boolean isGrandparentTreeNeeded() {
        return this.grandparentTreeNeeded;
    }

    public boolean isParentTreeNeeded() {
        return this.parentTreeNeeded;
    }

    public boolean isLastSubcategory() {
        return this.lastSubcategory;
    }

    public boolean isExpanded() {
        return EXPANDED.get(this.id);
    }

    public Enum<?> getId() {
        return this.id;
    }

    public void silentPress() {
        if (this.isExpanded()) {
            this.row.collapse();
        } else {
            this.row.expand();
        }
        this.toggle();
    }

    public void m_5691_() {
        this.silentPress();
        super.m_5691_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeyUtil.isEnter(keyCode) && this.m_93696_() && this.m_142518_()) {
            this.silentPress();
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean isMouseOver;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        boolean expanded = this.isExpanded();
        if (expanded && !this.row.isExpanded()) {
            this.row.expand();
        }
        if (!expanded && this.row.isExpanded()) {
            this.row.collapse();
        }
        int uOffset = 33;
        int vOffset = 0;
        int uWidth = 12;
        int vHeight = 18;
        int blitX = this.f_93620_;
        int blitY = this.f_93621_;
        int color = this.highlighted ? 0xFFAA00 : 0xFFFFFF;
        boolean bl = isMouseOver = this.m_5953_(expanded ? (double)(mouseX + 4) : (double)mouseX, expanded ? (double)(mouseY - 4) : (double)mouseY) || this.m_93696_();
        if (isMouseOver) {
            uOffset = expanded ? 47 : 33;
            vOffset = 23;
        } else if (expanded) {
            uOffset = 47;
        }
        if (expanded) {
            uWidth = 18;
            vHeight = 12;
            blitX = this.f_93620_ - 4;
            blitY = this.f_93621_ + 4;
        }
        this.f_93618_ = 20 + minecraft.f_91062_.m_92852_((FormattedText)this.title);
        this.f_93623_ = !Overlay.isOpened();
        screen.m_93228_(poseStack, blitX, blitY, uOffset, vOffset, uWidth, vHeight);
        Screen.m_93243_((PoseStack)poseStack, (Font)minecraft.f_91062_, (Component)this.title, (int)(this.f_93620_ + 20), (int)(this.f_93621_ + 5), (int)(isMouseOver ? 16766976 : color));
    }
}

