/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.client.config.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import mod.adrenix.nostalgic.client.config.gui.screen.config.ConfigScreen;
import mod.adrenix.nostalgic.client.config.gui.screen.list.ListScreen;
import mod.adrenix.nostalgic.util.common.MathUtil;
import mod.adrenix.nostalgic.util.common.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class OverlapButton
extends Button {
    protected final ConfigScreen screen;
    private boolean isListButton = false;
    private final Set<Widget> widgets;

    private static int getWidth(Component text) {
        return Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) + 8;
    }

    public OverlapButton(int startX, int startY, int width, int height, Component text, Button.OnPress onPress) {
        super(startX, startY, width, height, text, onPress);
        this.screen = (ConfigScreen)Minecraft.m_91087_().f_91080_;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ListScreen) {
            ListScreen listScreen = (ListScreen)screen;
            this.widgets = listScreen.getListWidgets();
        } else {
            screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof ConfigScreen) {
                ConfigScreen configScreen = (ConfigScreen)screen;
                this.widgets = configScreen.getWidgets().children;
            } else {
                this.widgets = new HashSet<Widget>();
            }
        }
    }

    public OverlapButton(Component text, Button.OnPress onPress) {
        this(0, 24, OverlapButton.getWidth(text), 20, text, onPress);
    }

    public OverlapButton setAsList() {
        this.isListButton = true;
        this.f_93618_ = 20;
        this.f_93619_ = 20;
        return this;
    }

    private boolean isMouseOver(AbstractWidget widget, int mouseX, int mouseY) {
        boolean isSame = widget.equals((Object)this);
        boolean isInBounds = MathUtil.isWithinBox(mouseX, mouseY, widget.f_93620_, widget.f_93621_, widget.m_5711_(), widget.m_93694_());
        return !isSame && isInBounds;
    }

    protected boolean shouldRenderToolTip(int mouseX, int mouseY) {
        boolean isOtherHovered = false;
        for (Widget child : this.widgets) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, mouseX, mouseY)) continue;
            isOtherHovered = true;
        }
        return !isOtherHovered;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (Widget child : this.widgets) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, mouseX, mouseY)) continue;
            this.f_93622_ = false;
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.isListButton) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureLocation.WIDGETS);
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, this.f_93622_ && this.f_93623_ ? 20 : 0, 163, 20, 20);
        }
    }
}

